/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting.util;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.enums.PsDataTypeEnum;
import kd.epm.epbs.common.util.JSONUtils;
import org.apache.commons.lang3.BooleanUtils;

public class ParamSettingUtils {
    private ParamSettingUtils() {
    }

    public static boolean isDevModel() {
        return "true".equals(System.getProperty("epbs.dev.model"));
    }

    public static String convertParams2String(PsDataTypeEnum type, Object value) {
        if (value != null) {
            switch (type) {
                case BOOL: {
                    if (!(value instanceof Boolean)) break;
                    return (Boolean)value != false ? "1" : "0";
                }
                case TEXT: {
                    if (!(value instanceof String)) break;
                    return value.toString();
                }
                case DATE: {
                    if (!(value instanceof Date)) break;
                    return ((Date)value).getTime() + "";
                }
                case INT: {
                    if (!(value instanceof Long) && !(value instanceof Integer)) break;
                    return value.toString();
                }
                case JSON: {
                    if (value instanceof JSON) {
                        return ((JSON)value).toJSONString();
                    }
                    return JSONUtils.toString((Object)value);
                }
                case DECIMAL: {
                    if (!(value instanceof BigDecimal)) break;
                    return ((BigDecimal)value).stripTrailingZeros().toPlainString();
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u5339\u914d%2$s", (String)"ParamSettingUtils_1", (String)"epm-epbs-business", (Object[])new Object[0]), type.name(), value.getClass().getName()));
        }
        return "";
    }

    public static Object convertParams2Object(PsDataTypeEnum type, String params) {
        if (type == null || StringUtils.isEmpty((String)params)) {
            return null;
        }
        switch (type) {
            case BOOL: {
                return BooleanUtils.toBoolean((String)params);
            }
            case TEXT: {
                return params;
            }
            case DATE: {
                return new Date(Long.parseLong(params));
            }
            case INT: {
                return Long.parseLong(params);
            }
            case JSON: {
                return JSON.parseObject((String)params);
            }
            case DECIMAL: {
                return new BigDecimal(params);
            }
        }
        return params;
    }

    public static String formatPropString(Object obj, IDataEntityProperty property) {
        return ParamSettingUtils.formatPropString(obj, property, null);
    }

    public static String formatPropString(Object obj, IDataEntityProperty property, IClientViewProxy clientViewProxy) {
        if (obj == null) {
            return "";
        }
        try {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? ResManager.loadKDString((String)"\u5f00\u542f", (String)"ParamSettingUtils_2", (String)"epm-epbs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5173\u95ed", (String)"ParamSettingUtils_3", (String)"epm-epbs-business", (Object[])new Object[0]);
            }
            if (obj instanceof Date) {
                SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
                df.applyPattern("yyyy-MM-dd HH:mm:ss");
                return df.format(obj);
            }
            if (obj instanceof DynamicObjectCollection && property instanceof MulBasedataProp) {
                Optional<IDataEntityProperty> fbasedataid = ((DynamicObjectCollection)obj).getDynamicObjectType().getProperties().stream().filter(e -> e.getName().equals("fbasedataid")).findFirst();
                if (fbasedataid.isPresent()) {
                    return ((DynamicObjectCollection)obj).stream().map(e -> e.getDynamicObject((IDataEntityProperty)fbasedataid.get())).map(e -> e.getString(ParamSettingUtils.resolveBaseDataEntityType(e.getDynamicObjectType()))).collect(Collectors.joining(","));
                }
                String s = ((DynamicObjectCollection)obj).getDynamicObjectType().getProperties().stream().filter(e -> e.getName().equals("name") || e.getName().equals("number")).map(e -> e.getName()).findFirst().orElseGet(() -> "fbasedataid_id");
                return ((DynamicObjectCollection)obj).stream().map(e -> e.getString(s)).collect(Collectors.joining(","));
            }
            if (obj instanceof String && StringUtils.isNotEmpty((String)obj.toString())) {
                if (property instanceof ComboProp) {
                    List<String> vls = Arrays.asList(((String)obj).split(","));
                    String str = ((ComboProp)property).getComboItems().stream().filter(e -> vls.contains(e.getValue())).map(e -> e.getName().getLocaleValue()).collect(Collectors.joining(","));
                    if (StringUtils.isEmpty((String)str) && null != clientViewProxy) {
                        Map state = clientViewProxy.getControlMetaState(property.getName());
                        List comboItems = null != state && !state.isEmpty() ? (List)state.get("st") : Collections.emptyList();
                        str = comboItems.stream().filter(e -> vls.contains(e.get(0))).map(e -> (String)((Map)e.get(1)).get(Lang.get().toString())).collect(Collectors.joining(","));
                    }
                    return str;
                }
            } else {
                if (obj instanceof BigDecimal) {
                    return ((BigDecimal)obj).stripTrailingZeros().toPlainString();
                }
                if (obj instanceof DynamicObject && property instanceof BasedataProp) {
                    return ((DynamicObject)obj).getString(ParamSettingUtils.resolveBaseDataEntityType(((DynamicObject)obj).getDynamicObjectType()));
                }
                if (obj instanceof ILocaleString) {
                    return ((ILocaleString)obj).getLocaleValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj.toString();
    }

    public static boolean isShow(IDataEntityProperty property) {
        return property instanceof DecimalProp || property instanceof BooleanProp || property instanceof TextProp && !property.getClass().equals(MuliLangTextProp.class) || property instanceof DateProp;
    }

    private static String resolveBaseDataEntityType(DynamicObjectType type) {
        String key = null;
        if (type instanceof BasedataEntityType) {
            key = ((BasedataEntityType)type).getNumberProperty();
            if (StringUtils.isEmpty((String)key)) {
                key = ((BasedataEntityType)type).getNameProperty();
            }
            if (StringUtils.isEmpty((String)key)) {
                key = ((BasedataEntityType)type).getPrimaryKey().getName();
            }
        }
        return key;
    }

    public static String convertShowParam(DynamicObject row) {
        if (row.getBoolean("isshow")) {
            String param = row.getString("entryentity.params");
            if (StringUtils.isEmpty((String)param)) {
                param = row.getString("defaultparams");
            }
            if (StringUtils.isNotEmpty((String)param)) {
                switch (PsDataTypeEnum.getByIndex(row.getInt("type"))) {
                    case BOOL: {
                        return BooleanUtils.toBoolean((String)param) ? ResManager.loadKDString((String)"\u662f", (String)"ParamSettingUtils_4", (String)"epm-epbs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ParamSettingUtils_5", (String)"epm-epbs-business", (Object[])new Object[0]);
                    }
                    case TEXT: 
                    case INT: 
                    case DECIMAL: {
                        return param;
                    }
                    case DATE: {
                        return new Date(Long.parseLong(param)).toString();
                    }
                }
                return "";
            }
        }
        return "";
    }
}

