/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.EmailEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TelephoneEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.JSONUtils;
import kd.epm.epbs.business.paramsetting.enums.PsControlTypeEnum;
import kd.epm.epbs.business.paramsetting.model.ParamSetControl;
import kd.epm.epbs.business.paramsetting.model.ParamSetFormModel;
import kd.epm.epbs.common.util.ReflectUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class PsControlFieldUtils {
    private static final Log LOG = LogFactory.getLog(PsControlFieldUtils.class);

    public static FieldAp createFieldAp(ParamSetControl paramSetControl) {
        FieldAp f7Field = new FieldAp();
        f7Field.setName(paramSetControl.getNameWithDefault());
        f7Field.setFieldId(paramSetControl.getNumberWithDefault().toLowerCase(Locale.ROOT));
        f7Field.setKey(paramSetControl.getNumberWithDefault().toLowerCase(Locale.ROOT));
        f7Field.setLabelDirection("v");
        f7Field.setShowTitle(true);
        Field field = PsControlFieldUtils.createField(paramSetControl);
        f7Field.setField(field);
        f7Field.setFireUpdEvt(true);
        return f7Field;
    }

    public static Field createField(ParamSetControl paramSetControl) {
        PsControlTypeEnum psControlTypeEnum = PsControlTypeEnum.getEnumByIndex(paramSetControl.getType());
        Field field = psControlTypeEnum.createField();
        PsControlFieldUtils.fillStyle(field, paramSetControl);
        field.setId(paramSetControl.getNumberWithDefault().toLowerCase(Locale.ROOT));
        field.setKey(paramSetControl.getNumberWithDefault().toLowerCase(Locale.ROOT));
        return field;
    }

    public static ParamSetControl castJson2Control(String val) {
        try {
            return (ParamSetControl)JSONUtils.cast((String)val, ParamSetControl.class);
        }
        catch (IOException e) {
            LOG.error("method failed", (Throwable)e);
            return null;
        }
    }

    public static ParamSetFormModel castJson2Form(String val) {
        try {
            return (ParamSetFormModel)JSONUtils.cast((String)val, ParamSetFormModel.class);
        }
        catch (IOException e) {
            LOG.error("method failed", (Throwable)e);
            return null;
        }
    }

    public static String toJsonString(Object t) {
        try {
            return JSONUtils.toString((Object)t);
        }
        catch (IOException e) {
            LOG.error("method failed", (Throwable)e);
            return null;
        }
    }

    private static void fillStyle(Object obj, ParamSetControl paramSetControl) {
        if (paramSetControl.getStyles() != null && !paramSetControl.getStyles().isEmpty()) {
            paramSetControl.getStyles().forEach((fieldKey, v) -> {
                if ("comboxItems".equals(fieldKey)) {
                    if (obj instanceof ComboProp) {
                        List comboItems = ((List)v).stream().map(e -> new ValueMapItem(null, (String)e.get("value"), LocaleString.fromMap((Map)((Map)e.get("title"))))).collect(Collectors.toList());
                        if (PsControlTypeEnum.RADIOGROUP.getIndex() == paramSetControl.getType()) {
                            ((ComboProp)obj).setComboValueCheck(false);
                        }
                        ((ComboProp)obj).setComboItems(comboItems);
                    } else if (obj instanceof ComboField) {
                        ArrayList<kd.bos.metadata.entity.commonfield.ComboItem> list = new ArrayList<kd.bos.metadata.entity.commonfield.ComboItem>(10);
                        int i = 0;
                        for (Map item : (List)v) {
                            list.add(new kd.bos.metadata.entity.commonfield.ComboItem(i++, LocaleString.fromMap((Map)((Map)item.get("title"))), item.getOrDefault("value", "").toString()));
                        }
                        if (PsControlTypeEnum.RADIOGROUP.getIndex() == paramSetControl.getType()) {
                            ((ComboField)obj).setComboValueCheck(false);
                        }
                        ((ComboField)obj).setItems(list);
                    }
                } else if ("baseEntityId".equals(fieldKey) && obj instanceof BasedataField) {
                    ((BasedataField)obj).setBaseEntityNumber(v.toString());
                } else {
                    try {
                        MethodUtils.invokeMethod((Object)obj, (String)("set" + Character.toUpperCase(fieldKey.charAt(0)) + fieldKey.substring(1)), (Object)v);
                    }
                    catch (Exception e2) {
                        LOG.error("method failed", (Throwable)e2);
                    }
                }
            });
        }
    }

    public static void createFieldProp(ParamSetControl control, MainEntityType newMainType) {
        TextProp fieldProp = null;
        String fieldKey = control.getNumberWithDefault().toLowerCase(Locale.ROOT);
        PsControlTypeEnum enumByIndex = PsControlTypeEnum.getEnumByIndex(control.getType());
        switch (enumByIndex) {
            case TEXT: 
            case TELEPHONE: 
            case EMAIL: {
                fieldProp = new TextProp();
                break;
            }
            case TEXTAREA: {
                fieldProp = new TextAreaProp();
                break;
            }
            case MULILANGTEXT: {
                MuliLangTextProp muliLangTextProp = new MuliLangTextProp();
                TextProp textProp = new TextProp();
                textProp.setName(fieldKey);
                textProp.setDbIgnore(true);
                DynamicObjectType orCreateLocaleType = newMainType.getOrCreateLocaleType();
                orCreateLocaleType.registerSimpleProperty((DynamicSimpleProperty)textProp);
                muliLangTextProp.setDbIgnore(true);
                muliLangTextProp.setName(fieldKey);
                muliLangTextProp.setLocaleProperty((IDataEntityProperty)newMainType.getLocaleProperty(), (DynamicSimpleProperty)textProp);
                fieldProp = muliLangTextProp;
                break;
            }
            case INT: {
                fieldProp = new IntegerProp();
                break;
            }
            case DECIMAL: {
                fieldProp = new DecimalProp();
                break;
            }
            case BIGINT: {
                fieldProp = new BigIntProp();
                break;
            }
            case DATE: {
                newMainType.addProperty(PsControlFieldUtils.createProp(fieldKey, DateProp.class, control));
                return;
            }
            case DATERANGE: {
                DateProp st = (DateProp)PsControlFieldUtils.createProp(fieldKey + "_startdate", DateProp.class, control);
                DateProp end = (DateProp)PsControlFieldUtils.createProp(fieldKey + "_enddate", DateProp.class, control);
                st.setRelateDateTimeRange(end.getName());
                end.setRelateDateTimeRange(st.getName());
                newMainType.addProperty((DynamicProperty)st);
                newMainType.addProperty((DynamicProperty)end);
                return;
            }
            case DATETIME: {
                newMainType.addProperty(PsControlFieldUtils.createProp(fieldKey, DateTimeProp.class, control));
                return;
            }
            case TIME: {
                newMainType.addProperty(PsControlFieldUtils.createProp(fieldKey, TimeProp.class, control));
                return;
            }
            case TIMERANGE: {
                TimeProp stime = (TimeProp)PsControlFieldUtils.createProp(fieldKey + "_starttime", TimeProp.class, control);
                TimeProp endtime = (TimeProp)PsControlFieldUtils.createProp(fieldKey + "_endtime", TimeProp.class, control);
                stime.setRelateTimeRange(endtime.getName());
                endtime.setRelateTimeRange(stime.getName());
                newMainType.addProperty((DynamicProperty)stime);
                newMainType.addProperty((DynamicProperty)endtime);
                return;
            }
            case CHECKBOX: {
                fieldProp = new BooleanProp();
                break;
            }
            case RADIOGROUP: {
                ComboProp comob = new ComboProp();
                comob.setGroupControl(true);
                comob.setComboValueCheck(true);
                comob.setDbIgnore(true);
                comob.setName(fieldKey);
                comob.setDisplayName(control.getNameWithDefault());
                PsControlFieldUtils.fillStyle(comob, control);
                comob.setMustInput(false);
                newMainType.addProperty((DynamicProperty)comob);
                if (control.getStyles() != null) {
                    ((List)control.getStyles().getOrDefault("comboxItems", new ArrayList())).forEach(e -> {
                        BooleanProp booleanProp = new BooleanProp();
                        booleanProp.setDbIgnore(true);
                        booleanProp.setName(fieldKey + "_radio_" + e.get("value"));
                        booleanProp.setDisplayName(LocaleString.fromMap((Map)((Map)e.get("title"))));
                        newMainType.addProperty((DynamicProperty)booleanProp);
                    });
                }
                return;
            }
            case RADIO: {
                fieldProp = new BooleanProp();
                break;
            }
            case COMBO: {
                fieldProp = new ComboProp();
                break;
            }
            case MULCOMBO: {
                fieldProp = new MulComboProp();
                break;
            }
            case USER: {
                UserProp userprop = new UserProp();
                userprop.setDbIgnore(true);
                userprop.setName(control.getNumberWithDefault().toLowerCase(Locale.ROOT));
                userprop.setDisplayName(control.getNameWithDefault());
                userprop.setAlias("");
                userprop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)userprop.getBaseEntityId()));
                DynamicSimpleProperty iduserprop = userprop.createRefIDProp();
                iduserprop.setName(userprop.getName() + "_id");
                iduserprop.setDbIgnore(true);
                userprop.setRefIdProp((IDataEntityProperty)iduserprop);
                userprop.setRefIdPropName(iduserprop.getName());
                newMainType.addProperty((DynamicProperty)iduserprop);
                newMainType.registerComplexProperty((DynamicComplexProperty)userprop);
                return;
            }
            case BASEDATA: {
                BasedataProp prop = new BasedataProp();
                prop.setDbIgnore(true);
                prop.setName(control.getNumberWithDefault().toLowerCase(Locale.ROOT));
                prop.setDisplayName(control.getNameWithDefault());
                prop.setAlias("");
                PsControlFieldUtils.fillStyle(prop, control);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId()));
                DynamicSimpleProperty idprop = prop.createRefIDProp();
                idprop.setName(prop.getName() + "_id");
                idprop.setDbIgnore(true);
                prop.setRefIdProp((IDataEntityProperty)idprop);
                prop.setRefIdPropName(idprop.getName());
                newMainType.addProperty((DynamicProperty)idprop);
                newMainType.registerComplexProperty((DynamicComplexProperty)prop);
                return;
            }
            case MULBASEDATA: {
                String baseEntityId = control.getStyles().getOrDefault("baseEntityId", "").toString();
                MainEntityType originalType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                DynamicObjectType multiSelcType = new DynamicObjectType(fieldKey);
                multiSelcType.setAlias(originalType.getAlias());
                multiSelcType.setDbIgnore(StringUtils.isBlank((CharSequence)originalType.getAlias()));
                multiSelcType.setDBRouteKey(StringUtils.isNotBlank((CharSequence)originalType.getAlias()) ? originalType.getDBRouteKey() : "");
                multiSelcType.setExtendName(baseEntityId);
                PsControlFieldUtils.registerProperties(multiSelcType, baseEntityId);
                MulBasedataProp prop2 = new MulBasedataProp(fieldKey, multiSelcType);
                prop2.setDbIgnore(true);
                prop2.setDisplayProp("name");
                prop2.setName(control.getNumberWithDefault().toLowerCase(Locale.ROOT));
                prop2.setDisplayName(control.getNameWithDefault());
                PsControlFieldUtils.fillStyle(prop2, control);
                newMainType.addProperty((DynamicProperty)prop2);
                return;
            }
        }
        if (fieldProp != null) {
            fieldProp.setDbIgnore(true);
            fieldProp.setName(fieldKey);
            fieldProp.setDisplayName(control.getNameWithDefault());
            fieldProp.setMustInput(true);
            PsControlFieldUtils.fillStyle(fieldProp, control);
            newMainType.addProperty((DynamicProperty)fieldProp);
        }
    }

    public static void registerProperties(DynamicObjectType type, String basedataEntity) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        baseProp.setBaseEntityId(basedataEntity);
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
        baseProp.setDisplayProp("name,number");
        LongProp idprop = new LongProp();
        idprop.setName("fbasedataid_id");
        idprop.setAlias("FBasedataId");
        baseProp.setRefIdProp((IDataEntityProperty)idprop);
        baseProp.setRefIdPropName(idprop.getName());
        type.addProperty((DynamicProperty)baseProp);
        type.addProperty((DynamicProperty)idprop);
    }

    private static DynamicProperty createProp(String fieldKey, Class<? extends DynamicProperty> clazz, ParamSetControl control) {
        try {
            DynamicProperty o = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            o.setName(fieldKey);
            o.setDbIgnore(true);
            o.setDisplayName(control.getNameWithDefault());
            PsControlFieldUtils.fillStyle(o, control);
            return o;
        }
        catch (Exception e) {
            LOG.error("method failed", (Throwable)e);
            return new DynamicProperty();
        }
    }

    public static FieldEdit createFieldEdit(ParamSetControl paramSetControl, IFormView formView) {
        String fielKey = paramSetControl.getNumberWithDefault().toLowerCase(Locale.ROOT);
        TextEdit fieldEdit = null;
        switch (PsControlTypeEnum.getEnumByIndex(paramSetControl.getType())) {
            case TEXT: 
            case TEXTAREA: 
            case MULILANGTEXT: {
                fieldEdit = new TextEdit();
                break;
            }
            case INT: {
                fieldEdit = new IntegerEdit();
                break;
            }
            case DECIMAL: {
                fieldEdit = new DecimalEdit();
                break;
            }
            case BIGINT: {
                fieldEdit = new IntegerEdit();
                break;
            }
            case DATE: {
                fieldEdit = new DateEdit();
                break;
            }
            case DATETIME: {
                fieldEdit = new DateTimeEdit();
                break;
            }
            case DATERANGE: {
                DateRangeEdit dateRangeEdit = new DateRangeEdit();
                dateRangeEdit.setEndDateFieldKey(fielKey + "_enddate");
                dateRangeEdit.setStartDateFieldKey(fielKey + "_startdate");
                fieldEdit = dateRangeEdit;
                break;
            }
            case TIME: {
                fieldEdit = new TimeEdit();
                break;
            }
            case TIMERANGE: {
                TimeRangeEdit timeRangeEdit = new TimeRangeEdit();
                timeRangeEdit.setEndDateFieldKey(fielKey + "_endtime");
                timeRangeEdit.setStartDateFieldKey(fielKey + "_starttime");
                fieldEdit = timeRangeEdit;
                break;
            }
            case CHECKBOX: {
                fieldEdit = new FieldEdit();
                break;
            }
            case RADIOGROUP: {
                ComboEdit radioGroupEdit;
                try {
                    radioGroupEdit = (ComboEdit)ReflectUtils.newInstance((String)"kd.bos.form.field.RadioGroupEdit");
                    ReflectUtils.invokeMethod((Object)radioGroupEdit, (String)"setId", (Object)fielKey);
                }
                catch (Exception e2) {
                    radioGroupEdit = new ComboEdit();
                }
                radioGroupEdit.setKey(fielKey);
                radioGroupEdit.setFieldKey(fielKey);
                radioGroupEdit.setModel(formView.getModel());
                radioGroupEdit.setView(formView);
                ArrayList list = new ArrayList();
                if (paramSetControl.getStyles() != null) {
                    ((List)paramSetControl.getStyles().getOrDefault("comboxItems", new ArrayList())).forEach(e -> list.add(new ComboItem(LocaleString.fromMap((Map)((Map)e.get("title"))), (String)e.get("value"))));
                }
                radioGroupEdit.setCaption(paramSetControl.getNameWithDefault());
                ReflectUtils.invokeMethod((Object)radioGroupEdit, (String)"setComboItems", list);
                return radioGroupEdit;
            }
            case RADIO: {
                fieldEdit = (FieldEdit)ReflectUtils.newInstance((String)"kd.bos.form.field.RadioEdit");
                ReflectUtils.invokeMethod((Object)fieldEdit, (String)"setItems", (Object)"1");
                break;
            }
            case COMBO: {
                fieldEdit = new ComboEdit();
                break;
            }
            case MULCOMBO: {
                fieldEdit = new MulComboEdit();
                break;
            }
            case USER: {
                fieldEdit = new UserEdit();
                break;
            }
            case BASEDATA: {
                fieldEdit = new BasedataEdit();
                break;
            }
            case MULBASEDATA: {
                fieldEdit = new MulBasedataEdit();
                ((MulBasedataEdit)fieldEdit).setDisplayProp("name");
                break;
            }
            case TELEPHONE: {
                fieldEdit = new TelephoneEdit();
                break;
            }
            case EMAIL: {
                fieldEdit = new EmailEdit();
            }
        }
        if (fieldEdit != null) {
            fieldEdit.setKey(fielKey);
            fieldEdit.setFieldKey(fielKey);
            fieldEdit.setModel(formView.getModel());
            fieldEdit.setView(formView);
            fieldEdit.addTips(paramSetControl.createTips());
        }
        return fieldEdit;
    }
}

