/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.admin;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.epbs.business.permission.funcPerm.EpbsFuncPermHelper;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ModelAdminAssignBean
implements Serializable {
    private long modelId;
    private Map<String, List<Long>> addUser;
    private Map<String, List<Long>> rmUser;

    public ModelAdminAssignBean(long modelId, Map<String, List<Long>> addUser, Map<String, List<Long>> rmUser) {
        this.modelId = modelId;
        this.addUser = addUser;
        this.rmUser = rmUser;
    }

    public List<Long> getAssignUser() {
        return this.addUser.getOrDefault(ModelUserTypeEnum.USER.getType(), Collections.emptyList());
    }

    public List<Long> getAssignUserGroup() {
        return this.addUser.getOrDefault(ModelUserTypeEnum.USERGROUP.getType(), Collections.emptyList());
    }

    public List<Long> getUnAssignUser() {
        return this.rmUser.getOrDefault(ModelUserTypeEnum.USER.getType(), Collections.emptyList());
    }

    public List<Long> getUnAssignUserGroup() {
        return this.rmUser.getOrDefault(ModelUserTypeEnum.USERGROUP.getType(), Collections.emptyList());
    }

    public long getModelId() {
        return this.modelId;
    }

    public void assignRoleWithModelDimType(String roleId) {
        this.assignRole(roleId, "epbs_model");
    }

    public void assignRole(String roleId, String dimtype) {
        List<Long> assignUser;
        if (StringUtils.isEmpty((CharSequence)roleId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModelAdminAssignBean_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        List<Long> unassignUser = this.getUnAssignUser();
        if (CollectionUtils.isNotEmpty(unassignUser)) {
            Map collect = unassignUser.stream().collect(Collectors.toMap(Function.identity(), t -> Collections.singletonList(this.getModelId())));
            PermissionServiceHelper.roleAssignUserOrg((String)roleId, (String)dimtype, collect, null, (boolean)false);
        }
        if (CollectionUtils.isNotEmpty(assignUser = this.getAssignUser())) {
            Map collect = assignUser.stream().collect(Collectors.toMap(Function.identity(), t -> Collections.singletonList(this.getModelId())));
            PermissionServiceHelper.roleAssignUserOrg((String)roleId, (String)dimtype, collect, null, (boolean)true);
        }
        List<Long> unAssignUserGroup = this.getUnAssignUserGroup();
        List<Long> assignUserGroup = this.getAssignUserGroup();
        if (CollectionUtils.isNotEmpty(unAssignUserGroup) || CollectionUtils.isNotEmpty(assignUserGroup)) {
            EpbsFuncPermHelper.roleAssignUserGroup(this.getModelId(), unAssignUserGroup, assignUserGroup, roleId, dimtype);
        }
    }
}

