/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.admin;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.bd.model.UserDistributeServiceHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.QFBuilder;

public class ModelAdminContext {
    private long userId;
    private AppTypeEnum[] appTypes;

    public ModelAdminContext(AppTypeEnum ... appTypes) {
        this.appTypes = appTypes;
    }

    public ModelAdminContext(long userId, AppTypeEnum ... appTypes) {
        this(appTypes);
        this.userId = userId;
    }

    public long getUserId() {
        if (this.userId <= 0L) {
            this.userId = RequestContext.get().getCurrUserId();
        }
        return this.userId;
    }

    public AppTypeEnum[] getAppTypes() {
        return this.appTypes;
    }

    protected QFilter genQFilter() {
        Set<Long> groupIds = UserDistributeServiceHelper.queryGroupIdsWithUser2UserId(this.getUserId());
        QFilter qFilter = new QFilter("user", "in", groupIds);
        if (this.getAppTypes() != null) {
            QFBuilder qfBuilder = new QFBuilder();
            for (AppTypeEnum appType : this.appTypes) {
                qfBuilder.or("appnums", "like", (Object)("%," + appType.getAppNum() + ",%"));
            }
            qFilter.and(qfBuilder.toFilter());
        } else {
            qFilter.and("appnums", "not like", (Object)("%," + AppTypeEnum.RPT.getAppNum() + ",%"));
        }
        return qFilter;
    }

    private String getAppNums() {
        AppTypeEnum[] appTypes = this.getAppTypes();
        if (this.getAppTypes() != null) {
            return Arrays.stream(this.getAppTypes()).map(e -> e.getAppNum()).collect(Collectors.joining("|"));
        }
        return AppTypeEnum.EPBS.getAppNum();
    }

    protected String getCacheKey() {
        return this.userId + "$" + this.getAppNums();
    }
}

