/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.mservice.AppBizServiceEnum;
import kd.epm.epbs.business.mservice.AppBizServiceHelper;
import kd.epm.epbs.business.permission.admin.ModelAdminAssignBean;
import kd.epm.epbs.business.permission.admin.ModelAdminContext;
import kd.epm.epbs.business.permission.funcPerm.PermItemHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.ModelAdminTypeEnum;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.TXUtils;

public final class ModelAdminPermService {
    public static final String MODEL_ADMIN_CACHE = "ModelAdminCACHE$";
    public static final ModelAdminPermService instance = new ModelAdminPermService();

    private ModelAdminPermService() {
    }

    public static ModelAdminPermService getInstance() {
        return instance;
    }

    public Set<Long> getLimitedModelListByUser(ModelAdminContext _ctx) {
        return (Set)ThreadCache.get((Object)(MODEL_ADMIN_CACHE + _ctx.getCacheKey()), () -> this.queryModelAdmin(_ctx));
    }

    public Set<Long> queryModelAdmin(ModelAdminContext _ctx) {
        return QueryServiceHelper.query((String)"epbs_model_admin", (String)"model.id", (QFilter[])_ctx.genQFilter().toArray()).stream().filter(dy -> dy.getLong("model.id") != 0L).map(dy -> dy.getLong("model.id")).collect(Collectors.toSet());
    }

    public boolean isUserHasRootPermByModel(long modelId, ModelAdminContext _ctx) {
        if (PermItemHelper.isGalaxySystem()) {
            return false;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(_ctx.genQFilter());
        return QueryServiceHelper.exists((String)"epbs_model_admin", (QFilter[])qFilter.toArray());
    }

    public void createModelAdmin(DynamicObject modelDy) {
        long modelId = modelDy.getLong("id");
        long userId = modelDy.getLong("creator_id");
        String srcappnum = modelDy.getString("srcappnum");
        String appnums = modelDy.getString("appnums");
        this.createOrAppendModelAdmin(modelId, userId, srcappnum, appnums);
    }

    public void createOrAppendModelAdmin(long modelId, long userId, String srcAppNum, String tarAppNums) {
        if (StringUtils.isNotEmpty((String)srcAppNum) && StringUtils.isNotEmpty((String)tarAppNums) && userId > 0L && modelId > 0L) {
            List list = Arrays.stream(tarAppNums.split(",")).filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("user", "=", (Object)userId);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"epbs_model_admin", (String)"id,appnums", (QFilter[])qFilter.toArray());
            if (load != null && load.length > 0) {
                for (DynamicObject dy : load) {
                    String appnums = dy.getString("appnums");
                    Set col = Arrays.stream(appnums.split(",")).collect(Collectors.toSet());
                    if ((list = list.stream().filter(e -> !col.contains(e)).collect(Collectors.toList())).isEmpty()) break;
                    dy.set("appnums", (Object)(appnums + list.stream().collect(Collectors.joining(",")) + ","));
                }
                SaveServiceHelper.save((DynamicObject[])load);
            } else {
                if (!list.contains(AppTypeEnum.EPBS.getAppNum())) {
                    list.add(AppTypeEnum.EPBS.getAppNum());
                }
                if (AppTypeEnum.CM.getAppNum().equals(srcAppNum) && AppUtils.getAppNumsCache().contains(AppTypeEnum.EPDM.getAppNum()) && !list.contains(AppTypeEnum.EPDM.getAppNum())) {
                    list.add(AppTypeEnum.EPDM.getAppNum());
                }
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_model_admin");
                dy.set("usertype", (Object)"bos_user");
                dy.set("user", (Object)userId);
                dy.set("model", (Object)modelId);
                dy.set("type", (Object)ModelAdminTypeEnum.CREATOR.getType());
                dy.set("creator", (Object)userId);
                dy.set("createtime", (Object)TimeServiceHelper.now());
                dy.set("appnums", (Object)list.stream().collect(Collectors.joining(",", ",", ",")));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            }
            if (!list.isEmpty()) {
                HashMap<String, List<Long>> addUser = new HashMap<String, List<Long>>(16);
                addUser.put(ModelUserTypeEnum.USER.getType(), Collections.singletonList(userId));
                ModelAdminAssignBean modelAdminBean = new ModelAdminAssignBean(modelId, addUser, new HashMap<String, List<Long>>(16));
                for (String appnum : list) {
                    if (AppTypeEnum.EPBS.getAppNum().equals(appnum)) {
                        modelAdminBean.assignRoleWithModelDimType("3VK4H5=JCWAD");
                        modelAdminBean.assignRole("3VK4H5=JCWAD", "bos_org");
                        continue;
                    }
                    AppBizServiceHelper.invokeBizServiceExt(AppTypeEnum.getEnumByAppnum((String)appnum), AppBizServiceEnum.assignModelAdmin, modelAdminBean);
                }
            }
        }
    }

    public void delete(Collection<Long> modelIds) {
        QFilter qFilter = new QFilter("model", "in", modelIds);
        HashMap map = new HashMap(16);
        for (DynamicObject dy : QueryServiceHelper.query((String)"epbs_model_admin", (String)"id,usertype,user_id,appnums,model_id", (QFilter[])qFilter.toArray())) {
            String appnums = dy.getString("appnums");
            String userType = dy.getString("usertype");
            Long userId = dy.getLong("user_id");
            Long modelId = dy.getLong("model_id");
            Arrays.stream(appnums.split(",")).filter(e -> StringUtils.isNotEmpty((String)e)).forEach(appnum -> map.computeIfAbsent(appnum + "!" + modelId, k -> new HashMap(16)).computeIfAbsent(userType, k -> new ArrayList(4)).add(userId));
        }
        DeleteServiceHelper.delete((String)"epbs_model_admin", (QFilter[])qFilter.toArray());
        TXUtils.requiresNew(e -> map.forEach((k, v) -> {
            String[] split = k.split("!");
            String appnum = split[0];
            ModelAdminAssignBean bean = new ModelAdminAssignBean(IDUtils.toLong((Object)split[1]), Collections.emptyMap(), (Map<String, List<Long>>)v);
            if (AppTypeEnum.EPBS.getAppNum().equals(appnum)) {
                bean.assignRoleWithModelDimType("3VK4H5=JCWAD");
                bean.assignRole("3VK4H5=JCWAD", "bos_org");
            } else {
                AppBizServiceHelper.invokeBizServiceExt(AppTypeEnum.getEnumByAppnum((String)appnum), AppBizServiceEnum.assignModelAdmin, bean);
            }
        }));
    }

    public Collection<Long> getModelPermByUser(AppTypeEnum appType, String entityNum, String permItemId) {
        HasPermDimObjResult perResult = StringUtils.isEmpty((String)entityNum) ? PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"DIM_EPBS_MODEL") : PermissionServiceHelper.getHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)appType.getAppNum()).getId(), (String)entityNum, (String)permItemId);
        QFilter qf = new QFilter("1", "=", (Object)1);
        if (!perResult.hasAllDimObjPerm()) {
            qf.and("id", "in", (Object)perResult.getHasPermDimObjs());
        }
        qf.and("appnums", "like", (Object)("%," + appType.getAppNum() + ",%"));
        return QueryServiceHelper.queryPrimaryKeys((String)"epbs_model", (QFilter[])qf.toArray(), null, (int)-1).stream().map(e -> IDUtils.toLong((Object)e)).collect(Collectors.toSet());
    }
}

