/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.permission.data.AuthBizBean;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.business.permission.data.AuthSetRowBean;
import kd.epm.epbs.business.permission.util.AuthSetUtils;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.ProjectConstant;
import kd.epm.epbs.common.util.TXUtils;

public class AuthSetSaveOp {
    private long modelId;
    private String appNum;
    private AuthTypeEnum authType;
    private Set<Long> rmAuthSetIds = new HashSet<Long>(16);
    private Set<Long> rmGroupSetIds = new HashSet<Long>(16);
    private List<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
    private List<DynamicObject> insertList = new ArrayList<DynamicObject>(10);

    public AuthSetSaveOp(long modelId, String appNum, AuthTypeEnum authTypeEnum) {
        this.modelId = modelId;
        this.appNum = appNum;
        this.authType = authTypeEnum;
    }

    public AuthSetSaveOp genDys(List<AuthBizBean> authBizBeans) {
        QFilter qFilter = new QFilter("authtype", "=", (Object)(this.authType.getType() + ""));
        qFilter.and("model_id", "=", (Object)this.modelId);
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"epbs_auth_set", (QFilter[])qFilter.toArray(), null, (int)-1);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epbs_auth_set"));
        Map<Long, DynamicObject> map = Arrays.stream(load).collect(Collectors.toMap(k -> k.getLong("authbiz_id"), v -> v, (v, v1) -> v1));
        for (int idx = 0; idx < authBizBeans.size(); ++idx) {
            AuthBizBean bizBean = authBizBeans.get(idx);
            DynamicObject dy = map.remove(bizBean.getAuthbiz());
            if (dy == null) {
                dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_auth_set");
                dy.set("authtype", (Object)(this.authType.getType() + ""));
                dy.set("authbiz", (Object)bizBean.getAuthbiz());
                dy.set("model", (Object)this.modelId);
                dy.set("appnum", (Object)this.appNum);
                dy.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
                this.insertList.add(dy);
            } else {
                dy.set("enable", (Object)"1");
                this.updateList.add(dy);
            }
            dy.set("dseq", (Object)idx);
            DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
            Map oldGroups = entryentity.stream().collect(Collectors.groupingBy(e -> e.getLong("group"), Collectors.mapping(a -> a.getString("entitynumber") + "#" + a.getString("dimnumber"), Collectors.toSet())));
            entryentity.clear();
            Map<Long, AuthSetRowBean> groupDetails = bizBean.getDatas();
            int seq = 0;
            for (Map.Entry<Long, AuthSetRowBean> entry : groupDetails.entrySet()) {
                List<AuthSetDetailBean> datas = entry.getValue().getDetails();
                Long group = entry.getKey();
                Iterator iterator = oldGroups.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry oldentry = iterator.next();
                    if (datas.size() != oldentry.getValue().size() || !datas.stream().allMatch(e -> ((Set)oldentry.getValue()).contains(e.getEntityNumber() + "#" + e.getDimNumber()))) continue;
                    group = oldentry.getKey();
                    iterator.remove();
                    break;
                }
                for (int j = 0; j < datas.size(); ++j) {
                    AuthSetDetailBean setBean = datas.get(j);
                    DynamicObject detail = entryentity.addNew();
                    detail.set("group", (Object)group);
                    detail.set("seq", (Object)seq++);
                    detail.set("hasperm", (Object)entry.getValue().isHasPerm());
                    detail.set("dimnumber", (Object)setBean.getDimNumber());
                    detail.set("entitynumber", (Object)setBean.getEntityNumber());
                }
            }
            this.rmGroupSetIds.addAll(oldGroups.keySet());
        }
        map.values().stream().forEach(a -> {
            this.rmAuthSetIds.add(a.getLong("id"));
            a.getDynamicObjectCollection("entryentity").forEach(e -> this.rmGroupSetIds.add(e.getLong("group")));
        });
        return this;
    }

    public void save() {
        TXUtils.required(e -> {
            Collection<Object> permTreeIds;
            if (!this.rmAuthSetIds.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"epbs_auth_set"), (Object[])this.rmAuthSetIds.toArray());
            }
            if (!this.rmGroupSetIds.isEmpty() && !(permTreeIds = AuthSetUtils.getDataPermTreeId(this.modelId)).isEmpty()) {
                QFilter qFilter = new QFilter("groupset", "in", this.rmGroupSetIds);
                qFilter.and("permtree", "in", permTreeIds);
                DeleteServiceHelper.delete((String)"epbs_dataperm_assign", (QFilter[])qFilter.toArray());
                String sql = "delete from T_EPBS_DATAPERMTREE_TAB where FGROUPSETID in(%s) and fid in(%s);";
                String format = String.format(sql, this.rmGroupSetIds.stream().map(a -> "?").collect(Collectors.joining(",")), permTreeIds.stream().map(a -> "?").collect(Collectors.joining(",")));
                ArrayList<Long> param = new ArrayList<Long>(this.rmGroupSetIds);
                param.addAll(permTreeIds);
                DB.execute((DBRoute)ProjectConstant.DB_ROUTE, (String)format, (Object[])param.toArray());
            }
            if (!this.insertList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])this.insertList.toArray(new DynamicObject[0]));
            }
            if (!this.updateList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])this.updateList.toArray(new DynamicObject[0]));
            }
            ModelCacheHelper.invalidateModelKeyById((Long)this.modelId);
            OperationLogUtil.writeLog((String)AppTypeEnum.EPBS.getAppNum(), (String)"epbs_auth_set", (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4f53\u7cfb\u3010%1$s\u3011\u7684\u6388\u6743\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f\u3002", "AuthSetSaveOp_1", "epm-epbs-business", new Object[]{ModelCacheHelper.getShowNumber((long)this.modelId)}));
        });
    }
}

