/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.UserTypeEnum;
import kd.epm.epbs.common.util.CommonServiceHelper;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.NumberGenHelper;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.TXUtils;

public class DataPermRoleHelper {
    public static final String DATAROLE_TYPE = "dataRoleType";
    public static final String DATAROLE_ID = "roleId";

    public static Long copyRole(long roleId) {
        DynamicObject roledy = BusinessDataServiceHelper.loadSingle((Object)roleId, (String)"epbs_dataperm_role");
        CloneUtils cloneUtils = new CloneUtils(true, true);
        String oldnumber = roledy.getString("number");
        roledy = (DynamicObject)cloneUtils.clone((IDataEntityBase)roledy);
        long newRoleId = GlobalIdUtil.genGlobalLongId();
        roledy.set("id", (Object)newRoleId);
        Consumer<DynamicObject> consumer = e -> {
            e.set("creator_id", (Object)RequestContext.getOrCreate().getCurrUserId());
            e.set("createtime", (Object)TimeServiceHelper.now());
            e.set("modifier_id", (Object)RequestContext.getOrCreate().getCurrUserId());
            e.set("modifytime", (Object)TimeServiceHelper.now());
        };
        consumer.accept(roledy);
        roledy.set("number", (Object)new NumberGenHelper("epbs_dataperm_role").copyCodeWithDefault(roledy.getString("number"), () -> GlobalIdUtil.genStringId()));
        QFilter qFilter = new QFilter("role", "=", (Object)roleId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epbs_dataperm_tree", (String)"id,model,entitynumber,role_id,parent_id,dseq,modifytime,modifier_id,creator_id,createtime,entryentity.groupset,entryentity.authtype,entryentity.seq,entryentity.id", (QFilter[])qFilter.toArray());
        HashMap hisMap = new HashMap(16);
        ArrayList treelist = new ArrayList(load.length);
        Arrays.stream(load).forEach(dy -> {
            Long newid = hisMap.computeIfAbsent(dy.getLong("id"), k -> GlobalIdUtil.genGlobalLongId());
            long parentId = dy.getLong("parent_id");
            DynamicObject newdy = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            newdy.set("id", (Object)newid);
            newdy.set("role_id", (Object)newRoleId);
            if (parentId > 0L) {
                parentId = hisMap.computeIfAbsent(parentId, k -> GlobalIdUtil.genGlobalLongId());
                newdy.set("parent_id", (Object)parentId);
            }
            consumer.accept(newdy);
            treelist.add(newdy);
        });
        String dataFields = CommonServiceHelper.getSelectFields((String)"epbs_dataperm_assign");
        DynamicObject[] dataPermDys = BusinessDataServiceHelper.load((String)"epbs_dataperm_assign", (String)"permtree_id,groupset,dseq,permval,creator_id,createtime,modifier_id,modifytime,entryentity.id,entryentity.seq,entryentity.memberid,entryentity.scope,entryentity.dimnumber,entryentity.entitynumber", (QFilter[])new QFilter("permtree", "in", hisMap.keySet()).toArray());
        ArrayList<DynamicObject> dpList = new ArrayList<DynamicObject>(dataPermDys.length);
        for (DynamicObject dataPermDy : dataPermDys) {
            DynamicObject newdy = (DynamicObject)cloneUtils.clone((IDataEntityBase)dataPermDy);
            long newid = GlobalIdUtil.genGlobalLongId();
            newdy.set("id", (Object)newid);
            newdy.set("permtree_id", hisMap.get(newdy.getLong("permtree_id")));
            consumer.accept(newdy);
            dpList.add(newdy);
        }
        DynamicObject finalRoledy = roledy;
        TXUtils.required(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalRoledy});
            if (!treelist.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])treelist.toArray(new DynamicObject[0]));
            }
            if (!dpList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])dpList.toArray(new DynamicObject[0]));
            }
        });
        OperationLogUtil.writeLog((String)AppTypeEnum.EPBS.getAppNum(), (String)"epbs_dataperm_role", (IOperationTypeInfo)OperationTypeEnum.COPY, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6570\u636e\u89d2\u8272\u590d\u5236\u3010%1$s\u3011\u751f\u6210\u3010%2$s\u3011\u6210\u529f\u3002", "DataPermRoleHelper_6", "epm-epbs-business", new Object[]{oldnumber, roledy.getString("number")}));
        return newRoleId;
    }

    public static void delete(Collection<Long> roleIds) {
        QFilter[] qFilter = new QFilter("role", "in", roleIds).toArray();
        List treeIds = QueryServiceHelper.queryPrimaryKeys((String)"epbs_dataperm_tree", (QFilter[])qFilter, null, (int)-1);
        TXUtils.required(tx -> {
            if (!treeIds.isEmpty()) {
                QFilter[] permtrees = new QFilter("permtree", "in", (Object)treeIds).toArray();
                DeleteServiceHelper.delete((String)"epbs_dataperm_assign", (QFilter[])permtrees);
                DeleteServiceHelper.delete((String)"epbs_dataperm_tree", (QFilter[])new QFilter("id", "in", (Object)treeIds).toArray());
            }
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"epbs_dataperm_role"), (Object[])roleIds.toArray(new Object[0]));
            DeleteServiceHelper.delete((String)"epbs_dataperm_roleuser", (QFilter[])qFilter);
        });
    }

    public static boolean existsRole(long roleId) {
        return QueryServiceHelper.exists((String)"epbs_dataperm_role", (Object)roleId);
    }

    public static void openDataPermRoleEdit(AbstractFormPlugin plugin, String closeKey, Long pkId, Consumer<FormShowParameter> consumer) {
        IFormView mainPageView = plugin.getView().getMainView();
        FormShowParameter formShowParameter = new FormShowParameter();
        if (pkId != null) {
            String pageId = plugin.getView().getPageId() + "-" + RequestContext.getOrCreate().getCurrUserId() + "-" + pkId;
            formShowParameter.setPageId(pageId);
            if (mainPageView != null && mainPageView.getView(pageId) != null) {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                plugin.getView().sendFormAction(childFormView);
                return;
            }
        }
        formShowParameter.setCaption("epbs_dataperm_rolelist".equals(plugin.getView().getEntityId()) ? ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u89d2\u8272\u6388\u6743", (String)"DataPermRoleHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u76f4\u63a5\u6388\u6743", (String)"DataPermRoleHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setFormId("epbs_dataperm_auth");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, closeKey));
        consumer.accept(formShowParameter);
        IFormView parentView = plugin.getView().getParentView();
        if (parentView == null) {
            plugin.getView().showForm(formShowParameter);
        } else {
            parentView.showForm(formShowParameter);
            plugin.getView().sendFormAction(parentView);
        }
    }

    public static void openUserAssignDataRolePage(ModelUserTypeEnum type, long authTypeId, AbstractFormPlugin plugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("epbs_userassigndatarole");
        formShowParameter.setCustomParam("authType", (Object)type.name().toLowerCase(Locale.ENGLISH));
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u5206\u914d\u6570\u636e\u89d2\u8272", (String)"DataPermRoleHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), type == ModelUserTypeEnum.USER ? UserTypeEnum.USER.getName().getLocaleString() : UserTypeEnum.USERGROUP.getName().getLocaleString()));
        formShowParameter.setCustomParam("authTypeId", (Object)String.valueOf(authTypeId));
        plugin.getView().showForm(formShowParameter);
    }
}

