/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.bd.model.UserDistributeServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.business.permission.data.context.PermContext;
import kd.epm.epbs.business.permission.data.context.RoleVersionBean;
import kd.epm.epbs.common.cache.permset.bean.DataPermMemItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermValueItem;
import kd.epm.epbs.common.cache.permset.bean.PermClassTreeItem;
import kd.epm.epbs.common.cache.permset.bean.UserDataPerm;
import kd.epm.epbs.common.enums.AuthTypeTabEnum;

public class DataPermServiceHelper {
    public static boolean openPermClass(long modelId) {
        return ParamSettingServiceHelper.getBoolean(modelId, "EPM003");
    }

    public static boolean openPermPriority(long modelId) {
        return ParamSettingServiceHelper.getBoolean(modelId, "PermissionPriority");
    }

    public static boolean openExcept(long modelId) {
        return ParamSettingServiceHelper.getBoolean(0L, "EPM005");
    }

    public static Set<Long> queryDataPermRoleIds(PermContext _ctx) {
        Set<Long> groupIds = UserDistributeServiceHelper.queryGroupIdsWithUser2UserId(_ctx.getUserId());
        HashSet<Long> allUser = new HashSet<Long>(groupIds);
        QueryServiceHelper.query((String)"epbs_dataperm_roleuser", (String)"user_id,usertype,role_id", (QFilter[])new QFilter[]{new QFilter("user_id", "in", allUser)}).forEach(dy -> allUser.add(dy.getLong("datarole_id")));
        return allUser;
    }

    private static DynamicObjectCollection queryRole(PermContext _ctx) {
        Set<Long> groupIds = UserDistributeServiceHelper.queryGroupIdsWithUser2UserId(_ctx.getUserId());
        HashSet<Long> allUser = new HashSet<Long>(groupIds);
        return QueryServiceHelper.query((String)"epbs_dataperm_roleuser", (String)"user_id,usertype,role_id", (QFilter[])new QFilter[]{new QFilter("user_id", "in", allUser)});
    }

    public static List<RoleVersionBean> queryRoleVersions(PermContext _ctx) {
        String acctId = CacheKeyUtil.getAcctId();
        DynamicObjectCollection dys = DataPermServiceHelper.queryRole(_ctx);
        if (!dys.isEmpty()) {
            ArrayList<RoleVersionBean> list = new ArrayList<RoleVersionBean>(dys.size());
            dys.forEach(dy -> list.add(new RoleVersionBean(dy.getLong("role_id"), acctId)));
            return list;
        }
        return Collections.emptyList();
    }

    public static Map<String, DataPermTreeItem> queryDataPerm(Map<Long, Tuple<RoleVersionBean, Set<Long>>> role2BizModelMap, Long groupSetId) {
        DataPermTreeItem gen;
        Tuple tup;
        QFilter qFilter = new QFilter("role", "in", role2BizModelMap.keySet());
        qFilter.and("model", "in", role2BizModelMap.values().stream().flatMap(e -> ((Set)e.item2).stream()).collect(Collectors.toSet()));
        HashMap tree2KeyMap = new HashMap(16);
        QueryServiceHelper.query((String)"epbs_dataperm_tree", (String)"id,model,role_id", (QFilter[])new QFilter[]{qFilter}).forEach(dy -> tree2KeyMap.put(dy.getLong("id"), Tuple.create((Object)((Tuple)role2BizModelMap.get((Object)Long.valueOf((long)dy.getLong((String)"role_id")))).item1, (Object)dy.getLong("model"))));
        HashMap<String, DataPermTreeItem> resMap = new HashMap<String, DataPermTreeItem>(16);
        QFilter qFilter2 = new QFilter("permtree", "in", tree2KeyMap.keySet());
        qFilter2.and("groupset", "=", (Object)groupSetId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_dataperm_assign", (String)"id,groupset,permtree,permval,dseq,entryentity.memberid,entryentity.scope,entryentity.dimnumber,entryentity.seq,entryentity.entitynumber", (QFilter[])qFilter2.toArray(), (String)"id,groupset,permtree,entryentity.seq");
        Long currId = 0L;
        ArrayList<DataPermMemItem> list = new ArrayList<DataPermMemItem>(10);
        UserDataPerm userDataPerm = new UserDataPerm();
        long treeId = 0L;
        long groupsetId = 0L;
        int permval = 0;
        for (DynamicObject dy2 : dys) {
            if (treeId != dy2.getLong("permtree") || groupsetId != dy2.getLong("groupset")) {
                if (currId != 0L) {
                    userDataPerm.add(permval, new DataPermValueItem("" + currId, list.toArray(new DataPermMemItem[0])));
                    list.clear();
                    Tuple tup2 = (Tuple)tree2KeyMap.get(treeId);
                    resMap.put(((RoleVersionBean)tup2.item1).genCacheKey((Long)tup2.item2, groupSetId), userDataPerm.gen(((RoleVersionBean)tup2.item1).getOrCreateVersion()));
                }
                treeId = dy2.getLong("permtree");
                groupsetId = dy2.getLong("groupset");
            }
            if (dy2.getLong("id") != currId.longValue()) {
                if (!list.isEmpty()) {
                    userDataPerm.add(permval, new DataPermValueItem("" + currId, list.toArray(new DataPermMemItem[0])));
                    list.clear();
                }
                currId = dy2.getLong("id");
            }
            permval = dy2.getInt("permval");
            list.add(new DataPermMemItem(dy2.getLong("entryentity.memberid"), dy2.getString("entryentity.dimnumber"), dy2.getString("entryentity.entitynumber"), dy2.getInt("entryentity.scope")));
        }
        if (!list.isEmpty()) {
            userDataPerm.add(permval, new DataPermValueItem("" + currId, list.toArray(new DataPermMemItem[0])));
            list.clear();
        }
        if ((tup = (Tuple)tree2KeyMap.get(treeId)) != null && (gen = userDataPerm.gen(((RoleVersionBean)tup.item1).getOrCreateVersion())) != null) {
            resMap.put(((RoleVersionBean)tup.item1).genCacheKey((Long)tup.item2, groupSetId), gen);
        }
        return resMap;
    }

    public static Map<String, PermClassTreeItem> queryPermClass(Map<Long, Tuple<RoleVersionBean, List<Long>>> role2BizModelMap) {
        QFilter qFilter = new QFilter("role", "in", role2BizModelMap.keySet());
        qFilter.and("model", "in", role2BizModelMap.values().stream().flatMap(e -> ((List)e.item2).stream()).collect(Collectors.toSet()));
        HashMap tree2KeyMap = new HashMap(16);
        QueryServiceHelper.query((String)"epbs_dataperm_tree", (String)"id,model,role_id", (QFilter[])new QFilter[]{qFilter}).forEach(dy -> tree2KeyMap.put(dy.getLong("id"), Tuple.create((Object)((Tuple)role2BizModelMap.get((Object)Long.valueOf((long)dy.getLong((String)"role_id")))).item1, (Object)dy.getLong("model"))));
        HashMap<String, PermClassTreeItem> resMap = new HashMap<String, PermClassTreeItem>(16);
        QFilter qFilter2 = new QFilter("permtree", "in", tree2KeyMap.keySet());
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_permclass_data", (String)"id,permtree,permval,dseq,permclass", (QFilter[])qFilter2.toArray(), (String)"permtree");
        long treeId = 0L;
        PermClassTreeItem permClassTreeItem = new PermClassTreeItem(0L);
        Tuple tup = null;
        for (DynamicObject dy2 : dys) {
            if (treeId != dy2.getLong("permtree")) {
                if (treeId != 0L) {
                    resMap.put(((RoleVersionBean)tup.item1).genCacheKey((Long)tup.item2, AuthTypeTabEnum.PERM_CLASS.getBizId()), permClassTreeItem);
                }
                treeId = dy2.getLong("permtree");
                tup = (Tuple)tree2KeyMap.get(treeId);
                permClassTreeItem = new PermClassTreeItem(((RoleVersionBean)tup.item1).getOrCreateVersion());
            }
            permClassTreeItem.addRecordRow(dy2.getLong("permclass"), dy2.getInt("permval"));
        }
        if (tup != null && !permClassTreeItem.getData().isEmpty()) {
            resMap.put(((RoleVersionBean)tup.item1).genCacheKey((Long)tup.item2, AuthTypeTabEnum.PERM_CLASS.getBizId()), permClassTreeItem);
        }
        return resMap;
    }

    public static long queryPermClassEntity(long modelId, String entityNumber, long entityId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("entitynumber", "=", (Object)entityNumber);
        qFilter.and("entityid", "=", (Object)entityId);
        return QueryServiceHelper.query((String)"epbs_permclass_entity", (String)"permclass", (QFilter[])qFilter.toArray()).stream().map(e -> e.getLong("permclass")).findFirst().orElseGet(() -> 0L);
    }
}

