/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.business.permission.util.DataRoleUtils;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.common.tree.TreeBuilderUtils;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataRoleDynamicTreeBuilder<T extends DynamicTreeContext>
extends SimpleDynamicTreeBuilder<T> {
    Map<String, List<Long>> bizModel2EntityNumberMap = new HashMap<String, List<Long>>(16);

    public DataRoleDynamicTreeBuilder(T cxt) {
        super(cxt);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"epbs_model");
        this.root = new TreeNode("", "0", dataEntityType.getDisplayName().getLocaleValue());
    }

    protected TreeNode newTreeNode(Row row) {
        this.bizModel2EntityNumberMap.computeIfAbsent(row.getString("entitynumber"), k -> new ArrayList(10)).add(row.getLong("id"));
        return new TreeNode(row.getString("parent"), row.getString("id"), null, (Object)DataRoleUtils.genTreeNodeData(row.getLong("treeid"), row.getString("entitynumber")));
    }

    protected TreeNode createTreeNode() {
        TreeNode root = super.createTreeNode();
        HashMap model2NameMap = new HashMap(16);
        this.bizModel2EntityNumberMap.forEach((entityNumber, ids) -> {
            String numberField = "epbs_model".equals(entityNumber) ? "shownumber as number" : "number";
            QueryServiceHelper.query((String)entityNumber, (String)("id,name," + numberField), (QFilter[])new QFilter("id", "in", ids).toArray()).forEach(dy -> model2NameMap.put(dy.getString("id"), TreeBuilderUtils.getShowText((ShowTypeEnum)((DynamicTreeContext)this._cxt).getShowTypeEnum(), (DynamicObject)dy)));
        });
        root.iterate(4, e -> {
            if (!"0".equals(e.getId())) {
                e.setText(model2NameMap.getOrDefault(e.getId(), "NULL"));
            }
        });
        if (StringUtils.isEmpty((CharSequence)((DynamicTreeContext)this._cxt).getFocusTreeId()) && CollectionUtils.isNotEmpty((Collection)root.getChildren())) {
            ((DynamicTreeContext)this._cxt).setFocusTreeId(((TreeNode)root.getChildren().get(0)).getId());
        }
        return root;
    }

    protected Map<String, List<TreeNode>> queryTreeNode() {
        Map map = super.queryTreeNode();
        Set<Long> limitedModelListByUser = ModelPermHelper.getLimitedModelListByUser(new AppTypeEnum[0]);
        map.entrySet().iterator().forEachRemaining(e -> {
            if (!((String)e.getKey()).equals("0") && !limitedModelListByUser.contains(IDUtils.toLong(e.getKey()))) {
                map.remove(e.getKey());
            }
        });
        return map;
    }
}

