/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.permission.bean.PermMemberBean;
import kd.epm.epbs.business.permission.bean.TabManagerBean;
import kd.epm.epbs.business.permission.bean.TabRowBean;
import kd.epm.epbs.business.permission.data.helper.DataPermCacheHelper;
import kd.epm.epbs.business.permission.util.DataRoleUtils;
import kd.epm.epbs.business.permission.util.TabManagerHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.tab.TabInfo;
import kd.epm.epbs.common.bean.tab.TabManager;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.DataRoleTabEnum;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.util.ControlValIfNullUtil;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.NumberRuleUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.TXUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DataRoleSaveOp {
    public static final String DATAROLE_ID = "roleId";
    public static final String AUTH_TYPE_ID = "authTypeId";
    public static final String LOADING_TREEIDS_CACHE = "loadingTreeIds";
    private IFormView view;
    private ModelUserTypeEnum type;
    private Long roleId;
    private Boolean isNew;
    List<DynamicObject> newDataRolePermTree = new ArrayList<DynamicObject>();
    List<DynamicObject> updateDataRolePermTree = new ArrayList<DynamicObject>();
    List<Long> rmDataRolePermTree = new ArrayList<Long>();
    List<DynamicObject> newDataPermPermRows = new ArrayList<DynamicObject>();
    List<DynamicObject> updateDataPermRows = new ArrayList<DynamicObject>();
    List<Long> rmDataPermRows = new ArrayList<Long>();
    Map<Integer, Map<String, List<String>>> errLogs = new HashMap<Integer, Map<String, List<String>>>(16);

    public DataRoleSaveOp(IFormView view) {
        this.view = view;
    }

    public Long getRoleId() {
        if (this.roleId == null) {
            this.roleId = IDUtils.toLong((Object)this.view.getPageCache().get(DATAROLE_ID));
        }
        return this.roleId;
    }

    public boolean isNew() {
        if (this.isNew == null) {
            this.isNew = IDUtils.toLong((Object)this.view.getPageCache().get(DATAROLE_ID)) == 0L;
        }
        return this.isNew;
    }

    protected ModelUserTypeEnum getType() {
        if (this.type == null) {
            this.type = ModelUserTypeEnum.indexOfVal((String)((String)this.view.getModel().getValue("type")));
        }
        return this.type;
    }

    protected boolean validateRoleBaseInfo() {
        DynamicObject dy = this.view.getModel().getDataEntity();
        if (this.getType() == null) {
            if (ControlValIfNullUtil.validateFail2ShowTips((IFormView)this.view, (String[])new String[]{"role_number", "role_name", "role_group"})) {
                return false;
            }
            if (!NumberRuleUtils.checkNumber((String)dy.getString("role_number"))) {
                this.view.showTipNotification(NumberRuleUtils.getMessage());
                return false;
            }
            Optional optional = NumberRuleUtils.checkIfRepeat((String)"epbs_dataperm_role", (String)dy.getString("role_number"), (Object)this.getRoleId());
            if (optional.isPresent()) {
                this.view.showTipNotification((String)optional.get());
                return false;
            }
        }
        return true;
    }

    protected long getAuthTypeId() {
        return IDUtils.toLong((Object)this.view.getFormShowParameter().getCustomParam(AUTH_TYPE_ID));
    }

    private DynamicObject getOrCreateDataRole() {
        DynamicObject dataRole;
        DynamicObject editDy = this.view.getModel().getDataEntity();
        if (this.isNew()) {
            dataRole = BusinessDataServiceHelper.newDynamicObject((String)"epbs_dataperm_role");
            this.roleId = this.getType() == null ? GlobalIdUtil.genGlobalLongId() : this.getAuthTypeId();
            dataRole.set("id", (Object)this.roleId);
            dataRole.set("enable", (Object)"1");
            dataRole.set("createtime", (Object)new Date());
            dataRole.set("creator", (Object)RequestContext.get().getCurrUserId());
            dataRole.set("type", editDy.get("type"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRole});
            this.view.getPageCache().put(DATAROLE_ID, "" + this.roleId);
        } else {
            if (!QueryServiceHelper.exists((String)"epbs_dataperm_role", (QFilter[])new QFilter("id", "=", (Object)this.getRoleId()).toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89d2\u8272\u3010%s\u3011\u5df2\u5220\u9664\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DataRoleSaveOp_1", (String)"epm-epbs-business", (Object[])new Object[]{editDy.get("role_number")}));
            }
            dataRole = BusinessDataServiceHelper.loadSingle((String)"epbs_dataperm_role", (String)"number,type,name,group,description,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getRoleId())});
            dataRole.set("modifytime", (Object)new Date());
            dataRole.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        dataRole.set("number", editDy.get("role_number"));
        dataRole.set("name", editDy.get("role_name"));
        dataRole.set("group", editDy.get("role_group"));
        dataRole.set("description", editDy.get("role_description"));
        return dataRole;
    }

    private Collection<Long> getHistoryDataRoleLeftTreeIds() {
        String treeIdStr = this.view.getPageCache().get(LOADING_TREEIDS_CACHE);
        return StringUtils.isEmpty((CharSequence)treeIdStr) ? Collections.emptyList() : (Collection)ObjectSerialUtil.deSerializedBytes((String)treeIdStr);
    }

    protected void buildDataPermLeftTreeAndRigthRows() {
        TreeNode rootNode = AbstractTreeBuilder.getRootWithCache((TreeView)((TreeView)this.view.getControl("treeviewap")));
        Collection<Long> oldedTreeIds = this.getHistoryDataRoleLeftTreeIds();
        HashSet<Long> exitsTreeIds = new HashSet<Long>(10);
        rootNode.iterate(10, e -> {
            String treeId;
            if (!"0".equals(e.getId()) && !"0".equals(treeId = (String)DataRoleUtils.genTreeNodeData((TreeNode)e).p1)) {
                exitsTreeIds.add(IDUtils.toLong((Object)treeId));
            }
        });
        Map<Long, DynamicObject> tree2NeedUpdate = this.getModel2NeedUpdateMap(exitsTreeIds);
        Map<Long, DynamicObject> assignDataPermRecords = this.getAssignDataPermRecord(exitsTreeIds);
        this.buildModelDataRoleDy(rootNode, tree2NeedUpdate, assignDataPermRecords, 1);
        if (!assignDataPermRecords.isEmpty()) {
            this.rmDataPermRows.addAll(assignDataPermRecords.keySet());
        }
        oldedTreeIds.stream().filter(e -> !exitsTreeIds.contains(e)).forEach(e -> this.rmDataRolePermTree.add((Long)e));
    }

    public Map<Long, DynamicObject> getAssignDataPermRecord(Collection<Long> treeIds) {
        Object[] permAssignDys;
        HashMap<Long, DynamicObject> permAssignDyMap = new HashMap<Long, DynamicObject>(16);
        if (!treeIds.isEmpty() && ArrayUtils.isNotEmpty((Object[])(permAssignDys = BusinessDataServiceHelper.load((String)"epbs_dataperm_assign", (String)"id,groupset,dseq,permval,modifier,modifytime,entryentity,entryentity.memberid,entryentity.scope,entryentity.dimnumber,entryentity.entitynumber,entryentity.seq", (QFilter[])new QFilter("permtree", "in", treeIds).toArray())))) {
            for (Object permAssignDy : permAssignDys) {
                permAssignDyMap.putIfAbsent(permAssignDy.getLong("id"), (DynamicObject)permAssignDy);
            }
        }
        return permAssignDyMap;
    }

    public Map<Long, DynamicObject> getModel2NeedUpdateMap(Collection<Long> treeIds) {
        HashMap<Long, DynamicObject> treeMap = new HashMap<Long, DynamicObject>(treeIds.size() + 1);
        if (!treeIds.isEmpty()) {
            DynamicObject[] treeDys;
            for (DynamicObject treeDy : treeDys = BusinessDataServiceHelper.load((Object[])treeIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epbs_dataperm_tree"))) {
                treeMap.put(treeDy.getLong("model"), treeDy);
            }
        }
        return treeMap;
    }

    private void buildModelDataRoleDy(TreeNode child, Map<Long, DynamicObject> tree2NeedUpdate, Map<Long, DynamicObject> assignDataPermRecords, int dseq) {
        if (!"0".equals(child.getId())) {
            long bizModelId = IDUtils.toLong((Object)child.getId());
            DynamicObject permTreeDy = tree2NeedUpdate.get(bizModelId);
            if (permTreeDy == null) {
                permTreeDy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_dataperm_tree");
                permTreeDy.set("id", (Object)DB.genGlobalLongId());
                permTreeDy.set("parent", (Object)IDUtils.toLong((Object)child.getParentid()));
                permTreeDy.set("entitynumber", DataRoleUtils.genTreeNodeData((TreeNode)child).p2);
                permTreeDy.set("model", (Object)child.getId());
                permTreeDy.set("creator", (Object)RequestContext.get().getCurrUserId());
                permTreeDy.set("role", (Object)this.getRoleId());
                permTreeDy.set("createtime", (Object)new Date());
                this.newDataRolePermTree.add(permTreeDy);
            } else {
                permTreeDy.set("modifytime", (Object)new Date());
                permTreeDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                this.updateDataRolePermTree.add(permTreeDy);
            }
            permTreeDy.set("dseq", (Object)dseq);
            TabManagerHelper helper = TabManagerHelper.getInstance(this.view.getPageCache(), child.getId());
            if (helper == null) {
                return;
            }
            DynamicObjectCollection authTabDys = permTreeDy.getDynamicObjectCollection("entryentity");
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)authTabDys)) {
                authTabDys.forEach(authTabDy -> map.putIfAbsent(authTabDy.getLong("groupset"), authTabDy));
            }
            for (DataRoleTabEnum firstLevelTab : DataRoleTabEnum.values()) {
                TabManager tabManager = helper.getTabManager(this.view.getPageCache(), firstLevelTab.getTabKey());
                List tabs = tabManager.getTabs();
                for (TabInfo tab : tabs) {
                    TabManagerBean data = (TabManagerBean)tab.getData();
                    DynamicObject authTabDy2 = map.get(data.getGroupId()) == null ? authTabDys.addNew() : (DynamicObject)map.get(data.getGroupId());
                    authTabDy2.set("groupset", (Object)data.getGroupId());
                    authTabDy2.set("authType", (Object)data.getAuthType());
                    if (!CollectionUtils.isNotEmpty(data.getTabRowBeans())) continue;
                    this.buildAuthDataRowDys(data, permTreeDy, assignDataPermRecords);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)child.getChildren())) {
            List children = child.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.buildModelDataRoleDy((TreeNode)children.get(i), tree2NeedUpdate, assignDataPermRecords, dseq + i);
            }
        }
    }

    protected void addLog(int authtype, String name, String logInfo) {
        this.errLogs.computeIfAbsent(authtype, k -> new HashMap(16)).computeIfAbsent(name, k -> new ArrayList(10)).add(logInfo);
    }

    private void buildAuthDataRowDys(TabManagerBean authData, DynamicObject permTreeDy, Map<Long, DynamicObject> permAssignDyMap) {
        List<TabRowBean> tabRowBeans = authData.getTabRowBeans();
        HashMap<String, Integer> sampleValidateMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < tabRowBeans.size(); ++i) {
            String str;
            DynamicObject rowDetailDy2;
            TabRowBean rowDy = tabRowBeans.get(i);
            if (rowDy.getPermVal() < 1) {
                this.addLog(authData.getAuthType(), authData.getName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u8bbe\u7f6e\u6743\u9650\u503c\u3002", (String)"DataRoleSaveOp_2", (String)"epm-epbs-business", (Object[])new Object[0]), i + 1));
                continue;
            }
            DynamicObject rowDetail = permAssignDyMap.remove(rowDy.getPkId());
            if (rowDetail != null) {
                rowDetail.set("modifytime", (Object)new Date());
                rowDetail.set("modifier", (Object)RequestContext.get().getCurrUserId());
                this.updateDataPermRows.add(rowDetail);
            } else {
                rowDetail = BusinessDataServiceHelper.newDynamicObject((String)"epbs_dataperm_assign");
                rowDetail.set("id", (Object)DB.genGlobalLongId());
                rowDetail.set("groupset", (Object)rowDy.getGroupId());
                rowDetail.set("permtree", (Object)permTreeDy.getLong("id"));
                rowDetail.set("creator", permTreeDy.get("creator"));
                rowDetail.set("createtime", permTreeDy.get("createtime"));
                this.newDataPermPermRows.add(rowDetail);
            }
            rowDetail.set("dseq", (Object)i);
            rowDetail.set("permval", (Object)rowDy.getPermVal());
            DynamicObjectCollection rowDetailDys = rowDetail.getDynamicObjectCollection("entryentity");
            HashMap<Integer, DynamicObject> rowDetailDyMap = new HashMap<Integer, DynamicObject>();
            if (CollectionUtils.isNotEmpty((Collection)rowDetailDys)) {
                if (rowDetailDys.size() != rowDy.getPermMemberBeanList().size()) {
                    this.addLog(authData.getAuthType(), authData.getName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bb0\u5f55\u5339\u914d\u4e0d\u5bf9\u3002", (String)"DataRoleSaveOp_3", (String)"epm-epbs-business", (Object[])new Object[0]), i + 1));
                    continue;
                }
                for (DynamicObject rowDetailDy2 : rowDetailDys) {
                    rowDetailDyMap.putIfAbsent(rowDetailDy2.getInt("seq"), rowDetailDy2);
                }
            }
            StringJoiner sj = new StringJoiner("|");
            rowDetailDy2 = rowDy.getPermMemberBeanList().iterator();
            while (rowDetailDy2.hasNext()) {
                PermMemberBean permMemberBean = rowDetailDy2.next();
                DynamicObject rowDetailDy3 = rowDetailDyMap.containsKey(permMemberBean.getSeq()) ? (DynamicObject)rowDetailDyMap.get(permMemberBean.getSeq()) : rowDetailDys.addNew();
                Long memId = IDUtils.toLong((Object)permMemberBean.getMemberid());
                if (memId <= 0L || StringUtils.isEmpty((CharSequence)permMemberBean.getDimnumber()) || StringUtils.isEmpty((CharSequence)permMemberBean.getEntityNumber())) {
                    this.addLog(authData.getAuthType(), authData.getName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6210\u5458\u4e0d\u5b8c\u6574\u3002", (String)"DataRoleSaveOp_4", (String)"epm-epbs-business", (Object[])new Object[0]), i + 1));
                    break;
                }
                rowDetailDy3.set("memberid", (Object)memId);
                rowDetailDy3.set("scope", (Object)permMemberBean.getScope());
                rowDetailDy3.set("dimnumber", (Object)permMemberBean.getDimnumber());
                rowDetailDy3.set("entitynumber", (Object)permMemberBean.getEntityNumber());
                rowDetailDy3.set("seq", (Object)permMemberBean.getSeq());
                sj.add(permMemberBean.getMemberid() + "&" + permMemberBean.getScope());
            }
            if (sampleValidateMap.containsKey(str = sj.toString())) {
                this.addLog(authData.getAuthType(), authData.getName(), String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u548c\u7b2c%2$d\u914d\u7f6e\u6210\u5458\u76f8\u540c\u3002", (String)"DataRoleSaveOp_8", (String)"epm-epbs-business", (Object[])new Object[0]), sampleValidateMap.get(str), i + 1));
                return;
            }
            sampleValidateMap.put(sj.toString(), i + 1);
        }
    }

    protected Collection<DynamicObject> createAssignRecord(DynamicObject role) {
        ModelUserTypeEnum type = ModelUserTypeEnum.indexOfVal((String)role.getString("type"));
        if (this.isNew() && type != null) {
            DynamicObject roleUser = BusinessDataServiceHelper.newDynamicObject((String)"epbs_dataperm_roleuser");
            roleUser.set("role", (Object)this.getRoleId());
            roleUser.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
            roleUser.set("createtime", (Object)TimeServiceHelper.now());
            roleUser.set("user", (Object)IDUtils.toLong((Object)this.view.getFormShowParameter().getCustomParam(AUTH_TYPE_ID)));
            roleUser.set("usertype", (Object)type.name().toLowerCase(Locale.ENGLISH));
            return Collections.singleton(roleUser);
        }
        return Collections.emptyList();
    }

    public boolean save(boolean isExit) {
        Collection<DynamicObject> assignRecords;
        DynamicObject dataRoleDy;
        if (this.validateRoleBaseInfo()) {
            dataRoleDy = this.getOrCreateDataRole();
            assignRecords = this.createAssignRecord(dataRoleDy);
            this.buildDataPermLeftTreeAndRigthRows();
            if (!this.errLogs.isEmpty()) {
                StringJoiner sj = new StringJoiner("\n");
                this.errLogs.forEach((authtype, e) -> {
                    String t = String.format(ResManager.loadKDString((String)"\"%s\"\u4e0b", (String)"DataRoleSaveOp_9", (String)"epm-epbs-business", (Object[])new Object[0]), AuthTypeEnum.indexof((byte)Byte.parseByte(authtype + "")).getDesc().loadKDString());
                    e.forEach((name, list) -> sj.add(ResManager.loadKDString((String)"%1$s\u6388\u6743\u8bbe\u7f6e\"%2$s\"\u7684\u914d\u7f6e", (String)"", (String)"", (Object[])new Object[]{name, list.stream().collect(Collectors.joining(";", "[", "]"))})));
                });
                this.view.showTipNotification(sj.toString());
                return false;
            }
        } else {
            return false;
        }
        TXUtils.required(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRoleDy});
            if (!this.rmDataRolePermTree.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"epbs_dataperm_tree"), (Object[])this.rmDataRolePermTree.toArray(new Object[0]));
                QFilter qFilter = new QFilter("permtree", "in", this.rmDataRolePermTree);
                DeleteServiceHelper.delete((String)"epbs_dataperm_assign", (QFilter[])qFilter.toArray());
            }
            if (!this.rmDataPermRows.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"epbs_dataperm_assign"), (Object[])this.rmDataPermRows.toArray(new Object[0]));
            }
            this.saveOrUpdate(assignRecords, this.newDataRolePermTree, this.updateDataRolePermTree, this.newDataPermPermRows, this.updateDataPermRows);
            ArrayList treeIds = new ArrayList(10);
            this.newDataRolePermTree.forEach(e -> treeIds.add(e.getLong("id")));
            this.updateDataRolePermTree.forEach(e -> treeIds.add(e.getLong("id")));
            this.view.getPageCache().put(LOADING_TREEIDS_CACHE, ObjectSerialUtil.toByteSerialized(treeIds));
            this.view.getPageCache().put(DATAROLE_ID, "" + this.getRoleId());
            DataPermCacheHelper.invalidateDataPermCache(this.getRoleId());
            (isExit ? this.view.getParentView() : this.view).showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataRoleSaveOp_5", (String)"epm-epbs-business", (Object[])new Object[0]));
            this.view.returnDataToParent((Object)new EpbsOperationResult());
            ModelUserTypeEnum type = ModelUserTypeEnum.indexOfVal((String)dataRoleDy.getString("type"));
            if (type == null) {
                OperationLogUtil.writeLog((String)AppTypeEnum.EPBS.getAppNum(), (String)"epbs_dataperm_role", (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6570\u636e\u89d2\u8272\u3010%1$s\u3011\u4fdd\u5b58\u6210\u529f\u3002", "DataRoleSaveOp_6", "epm-epbs-business", new Object[]{dataRoleDy.getString("number")}));
            } else {
                OperationLogUtil.writeLog((String)AppTypeEnum.EPBS.getAppNum(), (String)"epbs_usergroup_user", (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "DataRoleSaveOp_7", "epm-epbs-business"));
            }
            this.view.getPageCache().remove("DATA_CHANGED");
        });
        return true;
    }

    public void saveOrUpdate(Collection<DynamicObject> ... list) {
        for (Collection<DynamicObject> dys : list) {
            if (!CollectionUtils.isNotEmpty(dys)) continue;
            SaveServiceHelper.save((DynamicObject[])dys.toArray(new DynamicObject[0]));
        }
    }
}

