/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data.context;

import com.google.common.collect.Sets;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.epm.epbs.business.permission.data.DataPermServiceHelper;
import kd.epm.epbs.business.permission.data.context.DefaultDataPermHandler;
import kd.epm.epbs.business.permission.data.context.IDimDataPermHandler;
import kd.epm.epbs.business.permission.data.context.IPermContext;
import kd.epm.epbs.business.permission.data.context.RoleVersionBean;
import kd.epm.epbs.business.permission.data.service.IDataPermHandler;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.DataPermTypeEnum;

public abstract class PermContext
implements IPermContext {
    private static final long serialVersionUID = -8360081832756506901L;
    private Long modelId;
    private long viewId;
    private Boolean isAdmin;
    private Collection<Long> bizModelIds;
    protected IDataPermHandler handler;
    private DataPermTypeEnum dataPermType;
    private Collection<Long> roleIds;
    private Collection<RoleVersionBean> roles;

    public PermContext(Long modelId, DataPermTypeEnum dataPermType) {
        this(modelId, modelId, dataPermType);
    }

    public PermContext(Long modelId, Long bizModelId, DataPermTypeEnum dataPermType) {
        this.modelId = modelId;
        this.bizModelIds = Sets.newHashSet((Object[])new Long[]{modelId, bizModelId});
        this.dataPermType = dataPermType;
    }

    @Override
    public long getViewId() {
        return this.viewId;
    }

    @Override
    public void setViewId(long viewId) {
        this.viewId = viewId;
    }

    @Override
    public Long getModelId() {
        return this.modelId;
    }

    @Override
    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public Collection<Long> getBizModelIds() {
        return this.bizModelIds;
    }

    @Override
    public void setBizModelIds(Collection<Long> bizModelIds) {
        this.bizModelIds = bizModelIds;
    }

    @Override
    public Long getUserId() {
        return RequestContext.getOrCreate().getCurrUserId();
    }

    @Override
    public boolean isAdmin() {
        if (this.isAdmin == null) {
            this.isAdmin = ModelPermHelper.getLimitedModelListByUser(new AppTypeEnum[0]).contains(this.getModelId());
        }
        return this.isAdmin;
    }

    @Override
    public IDimDataPermHandler getHandler() {
        DefaultDataPermHandler defaultDataPermHandler = new DefaultDataPermHandler();
        defaultDataPermHandler.setContext(this);
        return defaultDataPermHandler;
    }

    @Override
    public DataPermTypeEnum getDataPermType() {
        return this.dataPermType;
    }

    @Override
    public void setDataPermType(DataPermTypeEnum dataPermType) {
        this.dataPermType = dataPermType;
    }

    public Collection<Long> getRoleIds() {
        if (this.roleIds == null) {
            this.roleIds = DataPermServiceHelper.queryDataPermRoleIds(this);
        }
        return this.roleIds;
    }

    @Override
    public Collection<RoleVersionBean> getRoles() {
        if (this.roles == null) {
            this.roles = DataPermServiceHelper.queryRoleVersions(this);
        }
        return this.roles;
    }
}

