/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.epm.epbs.business.permission.data.context.IBizDataPermHandler;
import kd.epm.epbs.business.permission.data.context.IBizPermContext;
import kd.epm.epbs.business.permission.data.handler.IBizPermLogicHandler;
import kd.epm.epbs.business.permission.data.helper.DataPermCacheHelper;
import kd.epm.epbs.common.cache.permset.bean.DataPermMemItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermValueItem;
import kd.epm.epbs.common.cache.permset.bean.MatchPermSetItem;

public class BizManagerLogicHandler
implements IBizPermLogicHandler {
    @Override
    public Collection<Long> getBizIds(IBizPermContext _ctx, Collection<Long> bizIds) {
        if (_ctx.isAdmin()) {
            return bizIds;
        }
        MatchPermSetItem matchDimItem = DataPermCacheHelper.findAuthSet(_ctx.getModelId()).hitAdmin(_ctx.getBizNum(), false);
        if (matchDimItem == null) {
            return bizIds;
        }
        Collection<Long> newIds = this.getBizIds(_ctx, matchDimItem);
        if (bizIds == null) {
            return newIds;
        }
        return bizIds.stream().filter(e -> newIds.contains(e)).collect(Collectors.toSet());
    }

    protected Collection<Long> getBizIds(IBizPermContext _ctx, MatchPermSetItem matchDimItem) {
        String key = _ctx.getDataPermType().getVal() + "";
        IBizDataPermHandler bizHandler = _ctx.getBizHandler();
        if (bizHandler != null) {
            this.handler(_ctx, matchDimItem, memItem -> bizHandler.beforeCollect(key, (DataPermMemItem)memItem));
            Map<String, Collection<Long>> map = bizHandler.afterCollect();
            return map.getOrDefault(key, Collections.emptySet());
        }
        HashSet<Long> newIds = new HashSet<Long>(16);
        this.handler(_ctx, matchDimItem, memItem -> newIds.add(memItem.getMemId()));
        return newIds;
    }

    protected void handler(IBizPermContext _ctx, MatchPermSetItem matchDimItem, Consumer<DataPermMemItem> consumer) {
        DataPermCacheHelper.hitDataPerm(_ctx, Collections.singleton(matchDimItem), (item, treeItems) -> {
            for (DataPermTreeItem treeItem : treeItems) {
                for (DataPermValueItem dataPermValueItem : treeItem.getManager()) {
                    consumer.accept(dataPermValueItem.getMembs()[0]);
                }
            }
            return false;
        });
    }
}

