/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data.handler.wrn2no.biz;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.permission.data.context.IBizDataPermHandler;
import kd.epm.epbs.business.permission.data.context.IBizPermContext;
import kd.epm.epbs.business.permission.data.context.IDimDataPermHandler;
import kd.epm.epbs.business.permission.data.handler.DataPermResult;
import kd.epm.epbs.business.permission.data.handler.IBizPermLogicHandler;
import kd.epm.epbs.business.permission.data.helper.DataPermCacheHelper;
import kd.epm.epbs.common.cache.permset.AuthSetBeanCache;
import kd.epm.epbs.common.cache.permset.bean.DataPermMemItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermValueItem;
import kd.epm.epbs.common.cache.permset.bean.MatchPermSetItem;
import kd.epm.epbs.common.cache.permset.bean.SinglePermDimItem;
import kd.epm.epbs.common.enums.DataPermValEnum;
import kd.epm.epbs.common.util.IDUtils;

public class BizWriteLogicHanlder
implements IBizPermLogicHandler {
    private IBizDataPermHandler bizHandler;
    private MatchPermSetItem prePermSet;

    protected final void handler(IBizPermContext _ctx, Collection<MatchPermSetItem> permDimItems, Consumer<DataPermMemItem> permHandler, Consumer<DataPermMemItem> exceptHandler) {
        DataPermCacheHelper.hitDataPerm(_ctx, permDimItems, (permDimItem, dataPermTreeItems) -> {
            for (DataPermTreeItem dataPermTreeItem : dataPermTreeItems) {
                this.handlerBiz(dataPermTreeItem, permHandler, exceptHandler);
            }
            return false;
        });
    }

    protected void handlerBiz(DataPermTreeItem dataPermTreeItem, Consumer<DataPermMemItem> permHandler, Consumer<DataPermMemItem> exceptHandler) {
        for (DataPermValueItem dataPermValueItem : dataPermTreeItem.getWrite()) {
            permHandler.accept(dataPermValueItem.getMembs()[0]);
        }
        for (DataPermValueItem dataPermValueItem : dataPermTreeItem.getExcept()) {
            exceptHandler.accept(dataPermValueItem.getMembs()[0]);
        }
    }

    @Override
    public Collection<Long> getBizIds(IBizPermContext _ctx, Collection<Long> bizIds) {
        if (_ctx.isAdmin()) {
            return bizIds;
        }
        List permDimItems = DataPermCacheHelper.findAuthSet(_ctx.getModelId()).hitBiz(_ctx.getBizNum());
        if (CollectionUtils.isEmpty((Collection)permDimItems)) {
            return bizIds;
        }
        IBizDataPermHandler bizHandler = _ctx.getBizHandler();
        if (bizHandler == null) {
            HashSet<Long> cols = new HashSet<Long>(16);
            HashSet<Long> exceptCols = new HashSet<Long>(16);
            this.handler(_ctx, permDimItems, item -> cols.add(item.getMemId()), item -> exceptCols.add(item.getMemId()));
            return this.getResults(new HashSet<Long>(bizIds), cols, exceptCols);
        }
        this.handler(_ctx, permDimItems, item -> bizHandler.beforeCollect(_ctx.getDataPermType().getVal() + "", (DataPermMemItem)item), item -> bizHandler.beforeCollect(DataPermValEnum.EXCEPT.getVal() + "", (DataPermMemItem)item));
        Collection<Long> cols = bizHandler.afterCollect().get(_ctx.getDataPermType().getVal() + "");
        Collection<Long> exceptCols = bizHandler.afterCollect().get(DataPermValEnum.EXCEPT.getVal() + "");
        return this.getResults(new HashSet<Long>(bizIds), cols, exceptCols);
    }

    protected Collection<Long> getResults(Collection<Long> bizIds, Collection<Long> perms, Collection<Long> exceptPerms) {
        if (CollectionUtils.isEmpty(perms)) {
            return perms;
        }
        if (bizIds != null) {
            bizIds = bizIds.stream().filter(e -> perms.contains(e)).collect(Collectors.toSet());
        }
        if (!exceptPerms.isEmpty() && bizIds != null && CollectionUtils.isNotEmpty(bizIds)) {
            bizIds.removeIf(e -> exceptPerms.contains(e));
        }
        return bizIds;
    }

    @Override
    public Collection<String> getMemberIds(IBizPermContext _ctx, Long bizId, String tarDimNum, Map<String, Collection<Long>> dimMemIds) {
        if (_ctx.isAdmin()) {
            return null;
        }
        HashSet<String> dimNums = new HashSet<String>(dimMemIds.keySet());
        dimNums.add(tarDimNum);
        AuthSetBeanCache authSet = DataPermCacheHelper.findAuthSet(_ctx.getModelId());
        List permDimItems = authSet.hit(_ctx.getBizNum(), dimNums);
        if (CollectionUtils.isEmpty((Collection)permDimItems)) {
            return null;
        }
        DataPermResult result = new DataPermResult();
        this.bizHandler = _ctx.getBizHandler();
        IDimDataPermHandler handler = _ctx.getHandler();
        String bizKey = _ctx.getBizNum() + "|0";
        DataPermCacheHelper.hitDataPerm(_ctx, permDimItems, (permSetItem, dataPermTreeItems) -> {
            block10: {
                block9: {
                    if (this.prePermSet != null && this.bizHandler != null && bizId > 0L) {
                        Map<String, Collection<Long>> map = this.bizHandler.afterCollect();
                        map.forEach((key, ids) -> {
                            String[] split = key.split("&");
                            if (split[0].equals("0")) {
                                result.addExceptRecord(IDUtils.toLong((Object)split[1]), split[2], bizKey, ids);
                            }
                            result.addRecord(IDUtils.toLong((Object)split[1]), split[2], bizKey, ids);
                        });
                        this.bizHandler = null;
                    }
                    int index = permSetItem.getIndex();
                    this.prePermSet = permSetItem;
                    if (!permSetItem.isBiz()) break block9;
                    if (bizId <= 0L) break block10;
                    for (DataPermTreeItem dataPermTreeItem : dataPermTreeItems) {
                        for (DataPermValueItem dataPermValueItem : dataPermTreeItem.getWrite()) {
                            if (this.bizHandler != null) {
                                this.bizHandler.beforeCollect("0&" + permSetItem.getItem().getGroupSetId() + "&" + dataPermValueItem.getKey(), dataPermValueItem.getMembs()[index]);
                                continue;
                            }
                            result.addRecord(permSetItem.getItem().getGroupSetId(), dataPermValueItem.getKey(), bizKey, Collections.singleton(dataPermValueItem.getMembs()[index].getMemId()));
                        }
                        for (DataPermValueItem dataPermValueItem : dataPermTreeItem.getExcept()) {
                            if (this.bizHandler != null) {
                                this.bizHandler.beforeCollect("0&" + permSetItem.getItem().getGroupSetId() + "&" + dataPermValueItem.getKey(), dataPermValueItem.getMembs()[index]);
                                continue;
                            }
                            result.addExceptRecord(permSetItem.getItem().getGroupSetId(), dataPermValueItem.getKey(), bizKey, Collections.singleton(dataPermValueItem.getMembs()[index].getMemId()));
                        }
                    }
                    break block10;
                }
                String dimNum = this.prePermSet.getItem().getDimNums()[this.prePermSet.getIndex()];
                SinglePermDimItem singlePermDimItem = authSet.hitSingleDim(dimNum);
                for (DataPermTreeItem dataPermTreeItem : dataPermTreeItems) {
                    Collection<Long> collect;
                    for (DataPermValueItem dataPermValueItem : dataPermTreeItem.getWrite()) {
                        collect = handler.collect(singlePermDimItem, dataPermValueItem.getMembs()[permSetItem.getIndex()]);
                        result.addRecord(permSetItem.getItem().getGroupSetId(), dataPermValueItem.getKey(), dimNum, collect);
                    }
                    for (DataPermValueItem dataPermValueItem : dataPermTreeItem.getExcept()) {
                        collect = handler.collect(singlePermDimItem, dataPermValueItem.getMembs()[permSetItem.getIndex()]);
                        result.addExceptRecord(permSetItem.getItem().getGroupSetId(), dataPermValueItem.getKey(), dimNum, collect);
                    }
                }
            }
            return false;
        });
        Map allExceptRows = result.getAllExceptRows();
        allExceptRows.forEach((preGroupSetId, map) -> map.forEach((k, row) -> row.getRows().forEach((dimNum, ids) -> {
            Collection longs;
            if (!CollectionUtils.isNotEmpty((Collection)ids) || (longs = (Collection)dimMemIds.get(k)) == null || ids.stream().anyMatch(e -> longs.contains(e))) {
                // empty if block
            }
        })));
        return null;
    }
}

