/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.data.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.business.permission.data.DataPermServiceHelper;
import kd.epm.epbs.business.permission.data.context.IPermContext;
import kd.epm.epbs.business.permission.data.context.RoleVersionBean;
import kd.epm.epbs.business.permission.data.handler.DataPermFunction;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.cache.permset.AuthSetBeanCache;
import kd.epm.epbs.common.cache.permset.bean.DataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.EmptyDataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.IDataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.MatchPermSetItem;
import kd.epm.epbs.common.cache.permset.bean.PermDimItem;
import kd.epm.epbs.common.util.SyncCacheUtil;

public class DataPermCacheHelper {
    public static final Log log = LogFactory.getLog(DataPermCacheHelper.class);
    public static final String EXPIRE_TIME_CACHE = "dataperm_cache#";
    public static final int MODEL_MAX_SIZE = 16;
    public static final int MODEL_OVER_TIME = 3;
    public static final int MAX_USER_SIZE = 1000;
    private static ReentrantLock lock = new ReentrantLock();
    public static volatile LoadingCache<String, IDataPermTreeItem> dataPermMap = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(3L, TimeUnit.HOURS).removalListener((RemovalListener)new RemovalListener<String, IDataPermTreeItem>(){

        public void onRemoval(RemovalNotification<String, IDataPermTreeItem> removalNotification) {
        }
    }).build((CacheLoader)new CacheLoader<String, IDataPermTreeItem>(){

        public IDataPermTreeItem load(String key) {
            return null;
        }
    });

    public static AuthSetBeanCache findAuthSet(long modelId) {
        return ModelCacheHelper.get((long)modelId).getAuthSet();
    }

    public static void hitDataPerm(IPermContext _ctx, Collection<MatchPermSetItem> permDimItems, DataPermFunction<List<DataPermTreeItem>> e) {
        HashMap<Long, Tuple<RoleVersionBean, Set<Long>>> expireRole = new HashMap<Long, Tuple<RoleVersionBean, Set<Long>>>(16);
        for (MatchPermSetItem item : permDimItems) {
            ArrayList<DataPermTreeItem> list = new ArrayList<DataPermTreeItem>(_ctx.getRoles().size() * _ctx.getBizModelIds().size());
            for (RoleVersionBean role : _ctx.getRoles()) {
                for (Long bizModelId : _ctx.getBizModelIds()) {
                    IDataPermTreeItem s = (IDataPermTreeItem)dataPermMap.getIfPresent((Object)role.genCacheKey(bizModelId, item.getItem().getGroupSetId()));
                    if (s == null || s.getVersion() < role.getCurVersion()) {
                        ((Set)expireRole.computeIfAbsent((Long)Long.valueOf((long)role.getRoleId()), (Function<Long, Tuple>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$hitDataPerm$1(kd.epm.epbs.business.permission.data.context.RoleVersionBean java.lang.Long ), (Ljava/lang/Long;)Lkd/bos/dataentity/Tuple;)((RoleVersionBean)role)).item2).add(bizModelId);
                        continue;
                    }
                    if (s instanceof EmptyDataPermTreeItem) continue;
                    list.add((DataPermTreeItem)s);
                }
            }
            if (!expireRole.isEmpty()) {
                Map<String, DataPermTreeItem> dataPermTempMap = DataPermServiceHelper.queryDataPerm(expireRole, item.getItem().getGroupSetId());
                PermDimItem finalItem = item.getItem();
                expireRole.forEach((roleId, tup) -> {
                    for (Long bizModelId : (Set)tup.item2) {
                        String key = ((RoleVersionBean)tup.item1).genCacheKey(bizModelId, finalItem.getGroupSetId());
                        DataPermTreeItem orDefault = (DataPermTreeItem)dataPermTempMap.get(key);
                        if (orDefault == null) {
                            orDefault = new EmptyDataPermTreeItem(((RoleVersionBean)tup.item1).getOrCreateVersion());
                        } else {
                            list.add(orDefault);
                        }
                        dataPermMap.put((Object)key, (Object)orDefault);
                    }
                });
            }
            if (!e.accept(item, list)) continue;
            return;
        }
    }

    public static void invalidateDataPermCache(Long roleId) {
        RoleVersionBean roleVersionBean = new RoleVersionBean(roleId, CacheKeyUtil.getAcctId());
        SyncCacheUtil.updateAppCacheTime((String)(EXPIRE_TIME_CACHE + roleVersionBean.getPrefixKey()));
    }

    private static /* synthetic */ Tuple lambda$hitDataPerm$1(RoleVersionBean role, Long k) {
        return Tuple.create((Object)role, new HashSet(2));
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> log.info("\u5b9a\u65f6\u6e05\u7406\u6743\u9650\u8bbe\u7f6e\u7f13\u5b58"), 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u4f53\u7cfb\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

