/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.funcPerm;

import com.google.common.collect.ImmutableMap;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.epbs.business.permission.funcPerm.PermItemHelper;
import kd.epm.epbs.common.apitest.ApiTest;
import kd.epm.epbs.common.apitest.ApiTestMethod;
import kd.epm.epbs.common.apitest.ApiTestParam;
import kd.epm.epbs.common.apitest.enums.ApiTestFeatureEnum;
import kd.epm.epbs.common.bean.IAppType;
import kd.epm.epbs.common.configuration.register.PermItemListRegister;
import kd.epm.epbs.common.configuration.register.PropRegisterFactory;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.TXUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@ApiTest(value="\u529f\u80fd\u6743\u9650\u8f85\u52a9\u7c7b\uff08\u89d2\u8272|\u6743\u9650\u9879\u5347\u7ea7\uff09", feature=ApiTestFeatureEnum.PERMISSION)
public class EpbsFuncPermHelper {
    public static final String DIM_EPBS_MODEL = "DIM_EPBS_MODEL";
    public static final String DIM_EPBS_MODEL_ID = "3Y7TLY6RBS2M";
    public static final String DIM_EPBS_MODEL_MAPPING = "epbs_model";
    public static final String MODEL_ADMIN_ROLE_ID = "3VK4H5=JCWAD";

    public static Boolean isRolePermTableNew() {
        String existSql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_rolepermdetial' AND KSQL_COL_NAME IN ('froleid')";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql, ResultSet::next);
    }

    public static void upgradeModelRolePermItemWithEPBS() {
        EpbsFuncPermHelper.upgradeModelRolePermItem((IAppType)AppTypeEnum.EPBS, MODEL_ADMIN_ROLE_ID);
    }

    @ApiTestMethod(value="\u5347\u7ea7\u89d2\u8272\u6743\u9650\u9879", test=false)
    public static void upgradeModelRolePermItem(@ApiTestParam(value="\u5e94\u7528\u7c7b\u578b") IAppType appTypeEnum, @ApiTestParam(value="\u89d2\u8272ID") String roleId) {
        PermItemListRegister register = (PermItemListRegister)PropRegisterFactory.createInstance(PermItemListRegister.class);
        HashMap map = new HashMap(64);
        ((Map)register.getResult(appTypeEnum.getAppNum())).values().forEach(a -> a.values().forEach(b -> map.put(b.getTarFormId() + "&" + b.getPermItemId(), b)));
        Boolean isNewPlatform = EpbsFuncPermHelper.isRolePermTableNew();
        String appId = appTypeEnum.getId();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = AppMetadataCache.getAppInfo((String)appTypeEnum.getAppNum()).getAppId();
        }
        String selectSql = isNewPlatform != false ? "select DISTINCT fpermitemid, fentitytypeid from t_perm_rolepermdetial where froleid = ? and fbizappid = ?" : "select DISTINCT fpermitemid, fentitytypeid from t_perm_roleperm prp left join t_perm_rolepermdetial prpd on prp.fid = prpd.fid where prp.froleid = ? and fbizappid = ?";
        HashMap<String, List> needRm = new HashMap<String, List>(16);
        try (DataSet ds = DB.queryDataSet((String)PermItemHelper.class.getSimpleName(), (DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{roleId, appId});){
            while (ds.hasNext()) {
                String fentitytypeid;
                Row rs = ds.next();
                String fpermitemid = rs.getString("fpermitemid");
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fpermitemid, fentitytypeid = rs.getString("fentitytypeid")}) || map.remove(fentitytypeid + "&" + fpermitemid) != null) continue;
                needRm.computeIfAbsent(fentitytypeid, k -> new ArrayList(3)).add(fpermitemid);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89d2\u8272\u7ba1\u7406\u5347\u7ea7\u6743\u9650\u9879\u9519\u8bef\uff1a%s", (String)"EpbsFuncPermHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
        if (!needRm.isEmpty()) {
            PermissionServiceHelper.roleAssignFuncPerm((String)roleId, (Map)ImmutableMap.of((Object)appId, needRm), (boolean)false, (StringBuilder)new StringBuilder());
        }
        if (!map.isEmpty()) {
            needRm.clear();
            map.values().forEach(a -> needRm.computeIfAbsent(a.getTarFormId(), k -> new ArrayList(3)).add(a.getPermItemId()));
            PermissionServiceHelper.roleAssignFuncPerm((String)roleId, (Map)ImmutableMap.of((Object)appId, needRm), (boolean)true, (StringBuilder)new StringBuilder());
        }
    }

    @ApiTestMethod(value="\u5206\u914d\u6216\u79fb\u9664\u7528\u6237\u4e8eEPBS\u89d2\u8272", test=false)
    public static void roleAssignUserWithEpbs(@ApiTestParam(value="\u7528\u62372\u4f53\u7cfb") Map<Long, List<Long>> assignInfo, @ApiTestParam(value="\u662f\u5426\u5206\u914d\u8fd8\u662f\u79fb\u9664") boolean isAdd) {
        PermissionServiceHelper.roleAssignUserOrg((String)MODEL_ADMIN_ROLE_ID, (String)DIM_EPBS_MODEL_MAPPING, assignInfo, null, (boolean)isAdd);
        PermissionServiceHelper.roleAssignUserOrg((String)MODEL_ADMIN_ROLE_ID, (String)"bos_org", assignInfo, null, (boolean)isAdd);
    }

    @ApiTestMethod(value="\u5206\u914d\u548c\u79fb\u9664\u7528\u6237\u7ec4\u4e8eEPBS\u89d2\u8272", test=false)
    public static void roleAssignUserGroupWithEpbs(@ApiTestParam(value="\u4f53\u7cfbID") long modelId, @ApiTestParam(value="\u79fb\u9664\u7528\u6237\u7ec4") Collection<Long> oldUserGroupIds, @ApiTestParam(value="\u65b0\u589e\u7528\u6237\u7ec4") Collection<Long> newUserGroupIds) {
        EpbsFuncPermHelper.roleAssignUserGroup(modelId, oldUserGroupIds, newUserGroupIds, MODEL_ADMIN_ROLE_ID, DIM_EPBS_MODEL_MAPPING);
        EpbsFuncPermHelper.roleAssignUserGroup(modelId, oldUserGroupIds, newUserGroupIds, MODEL_ADMIN_ROLE_ID, "bos_org");
    }

    @ApiTestMethod(value="\u5206\u914d\u548c\u79fb\u9664\u7528\u6237\u7ec4\u4e8e\u81ea\u5b9a\u4e49\u89d2\u8272", test=false)
    public static void roleAssignUserGroup(@ApiTestParam(value="\u4f53\u7cfbID") long modelId, @ApiTestParam(value="\u79fb\u9664\u7528\u6237\u7ec4") Collection<Long> oldUserGroupIds, @ApiTestParam(value="\u65b0\u589e\u7528\u6237\u7ec4") Collection<Long> newUserGroupIds, @ApiTestParam(value="\u89d2\u8272ID") String roleId, @ApiTestParam(value="\u9694\u79bb\u7ef4\u5ea6") String dimtype) {
        List<DynamicObject> usrGrpDys;
        Set uGIdDb;
        HashSet<Long> usrGrpOdCp = new HashSet<Long>(oldUserGroupIds);
        usrGrpOdCp.removeAll(newUserGroupIds);
        if (!usrGrpOdCp.isEmpty()) {
            QFilter qFilter = new QFilter("role", "=", (Object)roleId).and("dimid", "=", (Object)modelId).and("usrgrpid", "in", usrGrpOdCp).and("dimtype", "=", (Object)dimtype);
            DeleteServiceHelper.delete((String)"perm_usrgrprole", (QFilter[])qFilter.toArray());
        }
        HashSet<Long> addusrGrpOdCp = new HashSet<Long>(newUserGroupIds);
        addusrGrpOdCp.removeAll(oldUserGroupIds);
        if (!addusrGrpOdCp.isEmpty() && CollectionUtils.isNotEmpty(uGIdDb = QueryServiceHelper.query((String)"perm_usrgrprole", (String)"usrgrpid", (QFilter[])new QFilter("dimid", "=", (Object)modelId).and("usrgrpid", "in", addusrGrpOdCp).and("dimtype", "=", (Object)dimtype).toArray()).stream().map(t -> t.getLong("usrgrpid")).collect(Collectors.toSet()))) {
            addusrGrpOdCp.removeAll(uGIdDb);
        }
        if (!(usrGrpDys = addusrGrpOdCp.stream().map(usrGrpId -> {
            DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrprole");
            saveObj.set("dimtype", (Object)DIM_EPBS_MODEL_MAPPING);
            saveObj.set("dimid", (Object)modelId);
            saveObj.set("includesub", (Object)0);
            saveObj.set("usrgrpid", usrGrpId);
            saveObj.set("role", (Object)roleId);
            return saveObj;
        }).collect(Collectors.toList())).isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])usrGrpDys.toArray(new DynamicObject[0]));
        }
        CacheMrg.clearAllCache();
    }

    public static void removeAllPermOfModel(Collection<Long> modelIds) {
        TXUtils.requiresNew((String)"deleteperm", tag -> {
            QFilter qFilter = new QFilter("dimid", "in", (Object)modelIds).and("dimtype", "=", (Object)DIM_EPBS_MODEL_MAPPING);
            DeleteServiceHelper.delete((String)"perm_usrgrprole", (QFilter[])qFilter.toArray());
            QFilter qf = new QFilter("org", "in", (Object)modelIds).and("dimtype", "=", (Object)DIM_EPBS_MODEL_MAPPING);
            DeleteServiceHelper.delete((String)"perm_userrole", (QFilter[])qf.toArray());
            QFilter qcf = new QFilter("org", "in", (Object)modelIds);
            qcf.and("dimtype", "=", (Object)DIM_EPBS_MODEL);
            DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])qcf.toArray());
            CacheMrg.clearAllCache();
        });
    }

    public static boolean isModelDimType(IFormView view) {
        String formId;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
            formId = parameter.getBillFormId();
        } else {
            formId = view.getFormShowParameter().getFormId();
        }
        return EpbsFuncPermHelper.isModelDimType(formId);
    }

    public static boolean isModelDimType(String formId) {
        return DIM_EPBS_MODEL.equals(EntityMetadataCache.getPermissionControlType((String)formId).getDimension());
    }
}

