/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.funcPerm;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.permission.funcPerm.PermItemHelper;
import kd.epm.epbs.common.bean.PermItemBean;
import kd.epm.epbs.common.configuration.register.PermItemListRegister;
import kd.epm.epbs.common.configuration.register.PropRegisterFactory;
import org.jetbrains.annotations.NotNull;

public class FuncPermItemService {
    private PermItemListRegister register = (PermItemListRegister)PropRegisterFactory.createInstance(PermItemListRegister.class);

    protected PermItemBean findBean(String formId, String appId, String btnKey) {
        Map map = (Map)((Map)this.register.getResult(appId)).get(formId);
        if (map != null) {
            return (PermItemBean)map.get(btnKey);
        }
        return null;
    }

    public PermItemBean getPermItemBean(IFormView formView, String btnKey) {
        String appId = formView.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        PermItemBean bean = null;
        if (formView.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)formView.getFormShowParameter();
            bean = this.findBean(parameter.getBillFormId(), appId, btnKey);
        }
        if (bean == null) {
            bean = this.findBean(formView.getEntityId(), appId, btnKey);
        }
        return bean;
    }

    public boolean check(IFormView formView, String btnKey, long modelId) {
        PermItemBean bean = this.getPermItemBean(formView, btnKey);
        if (bean == null) {
            return true;
        }
        return this.check(bean, formView.getFormShowParameter().getAppId(), modelId);
    }

    private boolean isModelManager(long modelId) {
        return false;
    }

    protected boolean check(PermItemBean bean, String curAppId, long modelId) {
        int is;
        List publishApps;
        if (this.isModelManager(modelId)) {
            return true;
        }
        PermissionControlType pct = EntityMetadataCache.getPermissionControlType((String)bean.getTarFormId());
        if (pct != null && (publishApps = pct.getPublishApps()) != null) {
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)bean.getTarFormId());
            String currAppId = AppMetadataCache.getAppInfo((String)curAppId).getId();
            if (!currAppId.equals(appId) && !publishApps.contains(currAppId)) {
                return true;
            }
        }
        return (is = this.checkPermission(modelId, AppMetadataCache.getAppInfo((String)curAppId).getId(), bean)) != 0;
    }

    protected int checkPermission(long modelId, String appId, PermItemBean bean) {
        int is;
        if (PermItemHelper.isGalaxySystem()) {
            is = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"bos_org", (long)0L, (String)appId, (String)bean.getTarFormId(), (String)bean.getPermItemId());
        } else {
            String permIsoDimType = modelId == 0L ? "DIM_NULL" : "epbs_model";
            is = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)permIsoDimType, (long)modelId, (String)appId, (String)bean.getTarFormId(), (String)bean.getPermItemId());
        }
        return is;
    }

    public boolean check(@NotNull String formId, @NotNull String btnKey, @NotNull long modelId, @NotNull String appId) {
        if (StringUtils.isEmpty((String)btnKey) || StringUtils.isEmpty((String)formId) || StringUtils.isEmpty((String)appId)) {
            return true;
        }
        PermItemBean bean = this.findBean(formId, appId, btnKey);
        if (bean == null) {
            return true;
        }
        return this.check(bean, appId, modelId);
    }
}

