/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.upgrade;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.apitest.ApiTest;
import kd.epm.epbs.common.apitest.ApiTestMethod;
import kd.epm.epbs.common.apitest.ApiTestParam;
import kd.epm.epbs.common.apitest.enums.ApiTestFeatureEnum;
import kd.epm.epbs.common.enums.AppDBRouteEnum;

@ApiTest(value="\u5386\u53f2\u6743\u9650\u9879\u5347\u7ea7", feature=ApiTestFeatureEnum.PERMISSION)
public class AppendPermBySureAppEntPermItemUtil {
    private static final Log logger = LogFactory.getLog(AppendPermBySureAppEntPermItemUtil.class);
    private static final String T_PERM_USERPERMDETAIL = "t_perm_userpermdetail";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiTestMethod(value="\u5347\u7ea7\u63d2\u4ef6\u6267\u884c\u65b9\u6cd5")
    public static PermResult upgrade(@ApiTestParam(value="\u65e7\u6743\u9650\u5230\u65b0\u6743\u9650\u7684\u6620\u5c04\u5173\u7cfb", example="[\u65e7\u6743\u9650('11H66HLOX4IC','bcm_role_list','47150e89000000ac'),\u65b0\u6743\u9650('3J6GZ00WTQPR','epbs_perm_role','47150e89000000ac')]") List<Object[]> old2NewPermMapList, @ApiTestParam(value="\u9519\u8bef\u4fe1\u606f\u6536\u96c6\u5668\uff0c\u53ef\u4f20\u7a7a") StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermBySureAppEntPermItemUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == old2NewPermMapList || old2NewPermMapList.isEmpty()) {
                logger.info("AppendPermBySureAppEntPermItemUtil.upgrade, old2NewPermMapList is empty.");
                PermResult permResult = PermResult.ok();
                return permResult;
            }
            for (int i = 0; i < old2NewPermMapList.size(); ++i) {
                Object[] oldEntPerItem2NewMap = old2NewPermMapList.get(i);
                if (null == oldEntPerItem2NewMap || Objects.equals(0, oldEntPerItem2NewMap.length)) {
                    logger.info("AppendPermBySureAppEntPermItemUtil.upgrade, oldEntPerItem2NewMap is empty, i:{}", (Object)i);
                    continue;
                }
                Object oldAppIdObj = oldEntPerItem2NewMap[0];
                Object oldEntNumObj = oldEntPerItem2NewMap[1];
                Object oldPermItemIdObj = oldEntPerItem2NewMap[2];
                Object newAppIdObj = oldEntPerItem2NewMap[3];
                Object newEntNumObj = oldEntPerItem2NewMap[4];
                Object newPermItemIdObj = oldEntPerItem2NewMap[5];
                if (Objects.isNull(newAppIdObj) || Objects.isNull(newEntNumObj) || Objects.isNull(newPermItemIdObj)) {
                    logger.info("AppendPermBySureAppEntPermItemUtil.upgrade, oldAppIdObj:{}, oldEntNumObj:{}, oldPermItemIdObj:{}, newAppIdObj:{}, newEntNumObj:{}, newPermItemIdObj:{}, i:{}", new Object[]{oldAppIdObj, oldEntNumObj, oldPermItemIdObj, newAppIdObj, newEntNumObj, newPermItemIdObj, i});
                    continue;
                }
                String newAppId = (String)newAppIdObj;
                String newEntNum = (String)newEntNumObj;
                String newPermItemId = (String)newPermItemIdObj;
                if (StringUtils.isEmpty((String)newAppId) || StringUtils.isEmpty((String)newEntNum) || StringUtils.isEmpty((String)newPermItemId)) {
                    logger.info("AppendPermBySureAppEntPermItemUtil.upgrade, newAppId or newEntNum or newPermItemId is empty, oldAppIdObj:{}, oldEntNumObj:{}, oldPermItemIdObj:{}, newAppIdObj:{}, newEntNumObj:{}, newPermItemIdObj:{}, i:{}", new Object[]{oldAppIdObj, oldEntNumObj, oldPermItemIdObj, newAppIdObj, newEntNumObj, newPermItemIdObj, i});
                    continue;
                }
                Object threeStrategyEntryIdObj = Objects.equals(6, oldEntPerItem2NewMap.length) ? null : oldEntPerItem2NewMap[6];
                Object[] threeStrategyEntryIdArr = Objects.isNull(threeStrategyEntryIdObj) ? new Long[]{} : (Long[])threeStrategyEntryIdObj;
                String oldAppId = Objects.isNull(oldAppIdObj) ? "" : (String)oldAppIdObj;
                String oldEntNum = Objects.isNull(oldEntNumObj) ? "" : (String)oldEntNumObj;
                String oldPermItemId = Objects.isNull(oldPermItemIdObj) ? "" : (String)oldPermItemIdObj;
                try (TXHandle h = TX.requiresNew();){
                    try {
                        if (threeStrategyEntryIdArr != null && threeStrategyEntryIdArr.length > 0 && StringUtils.isNotEmpty((String)newAppId) && StringUtils.isNotEmpty((String)newEntNum) && StringUtils.isNotEmpty((String)newPermItemId)) {
                            AppendPermBySureAppEntPermItemUtil.appendAdminSchemeDetail((Long[])threeStrategyEntryIdArr, newAppId, newEntNum, newPermItemId);
                        }
                        if (!StringUtils.isNotEmpty((String)oldAppId) || !StringUtils.isNotEmpty((String)oldEntNum) || !StringUtils.isNotEmpty((String)oldPermItemId) || !StringUtils.isNotEmpty((String)newAppId) || !StringUtils.isNotEmpty((String)newEntNum) || !StringUtils.isNotEmpty((String)newPermItemId)) continue;
                        AppendPermBySureAppEntPermItemUtil.copyPermForAdmingroupFunperm(oldAppId, newAppId, oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermBySureAppEntPermItemUtil.copyPermForUserPermDetail(oldAppId, newAppId, oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermBySureAppEntPermItemUtil.copyPermForDisFunPerm(oldAppId, newAppId, oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermBySureAppEntPermItemUtil.copyPermForRolePermDetail(oldAppId, newAppId, oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermBySureAppEntPermItemUtil.copyPermForBizRolePerm(oldAppId, newAppId, oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermBySureAppEntPermItemUtil.copyPermForBizRoleDisPerm(oldAppId, newAppId, oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermBySureAppEntPermItemUtil.copySpecialPerm(oldAppId, newAppId, oldEntNum, newEntNum);
                        AppendPermBySureAppEntPermItemUtil.copyDataRulePerm(oldAppId, newAppId, oldEntNum, newEntNum);
                        AppendPermBySureAppEntPermItemUtil.copyFieldPerm(oldAppId, newAppId, oldEntNum, newEntNum);
                        continue;
                    }
                    catch (Exception e) {
                        String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u786e\u5b9a\u524d\u540e\u5e94\u7528\u8868\u5355\u6743\u9650\u9879\u3011\u5347\u7ea7\u5f02\u5e38\uff0coldAppId\uff1a%1$s\uff0coldEntNum\uff1a%2$s\uff0coldPermItemId\uff1a%3$s\uff0cnewAppId\uff1a%4$s\uff0cnewEntNum\uff1a%5$s\uff0cnewPermItemId\uff1a%6$s\uff0cthreeStrategyEntryIdArr\uff1a%7$s\uff0c%8$s", (String)"AppendPermBySureAppEntPermItemUtil_1", (String)"epm-epbs-business", (Object[])new Object[0]), oldAppId, oldEntNum, oldPermItemId, newAppId, newEntNum, newPermItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage());
                        logger.error(errInfo, (Throwable)e);
                        h.markRollback();
                        pProcessInfo.append(errInfo);
                        AppendPermBySureAppEntPermItemUtil.addOperLog(errInfo);
                        throw e;
                    }
                }
            }
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            if (null != lock) {
                lock.unlock();
            }
        }
        return PermResult.ok();
    }

    private static void copyFieldPerm(String oldAppId, String newAppId, String oldEntNum, String newEntNum) {
        String updateSql = "update t_perm_fieldscheme set fentnum='%s',fappid='%s' where fentnum='%s' and fappid='%s'";
        DB.execute((DBRoute)AppDBRouteEnum.SYS.getDbRoute(), (String)String.format(updateSql, newEntNum, newAppId, oldEntNum, oldAppId));
    }

    private static void copyDataRulePerm(String oldAppId, String newAppId, String oldEntNum, String newEntNum) {
        String updateSql = "update t_perm_datarule set fentitynum='%s',fbizappid='%s' where fentitynum='%s' and fbizappid='%s'";
        DB.execute((DBRoute)AppDBRouteEnum.SYS.getDbRoute(), (String)String.format(updateSql, newEntNum, newAppId, oldEntNum, oldAppId));
    }

    private static void copySpecialPerm(String oldAppId, String newAppId, String oldEntNum, String newEntNum) {
        String updateSql = "update t_perm_operationrule set fentitytypeid='%s',fbizappid='%s' where fentitytypeid='%s' and fbizappid='%s'";
        DB.execute((DBRoute)AppDBRouteEnum.SYS.getDbRoute(), (String)String.format(updateSql, newEntNum, newAppId, oldEntNum, oldAppId));
    }

    private static void appendAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String newAppId, String newEntNum, String ... newPermItemIds) {
        final HashMap<String, String> appEntMap = new HashMap<String, String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fnumber, a.fbizappid");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" inner join t_meta_bizapp b on a.fbizappid = b.fid");
        HashSet cloudSet = Sets.newHashSet((Object[])new String[]{"0QLCSO6KKZC9", "83bfebc800000bac"});
        String cloudSetStr = String.join((CharSequence)"','", cloudSet);
        sb.append(" where b.fbizcloudid in ('").append(cloudSetStr).append("')");
        sb.append(" and a.fbizappid = ? ");
        sb.append(" and a.fnumber = ? ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{newAppId, newEntNum}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fnumber = rs.getString("fnumber");
                    if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fnumber)) continue;
                    appEntMap.put(fbizappid, fnumber);
                }
                return null;
            }
        });
        final List<String> allSysAppIds = AppendPermBySureAppEntPermItemUtil.queryAllSysApp(false, true, true);
        DB.query((DBRoute)DBRoute.basedata, (String)"select fbizappid , fbizobjid from t_perm_bizobjapp where fbizappid = ? and fbizobjid = ? ", (Object[])new Object[]{newAppId, newEntNum}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fnumber = rs.getString("fbizobjid");
                    if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fnumber) || !allSysAppIds.contains(fbizappid)) continue;
                    appEntMap.put(fbizappid, fnumber);
                }
                return null;
            }
        });
        if (null == appEntMap || appEntMap.isEmpty()) {
            return;
        }
        Set<String> exist = AppendPermBySureAppEntPermItemUtil.queryForAdminSchemeDetail(threeStrategyEntryIdArr, appEntMap, newPermItemIds);
        int size = threeStrategyEntryIdArr.length * appEntMap.size() * newPermItemIds.length - exist.size();
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int idx = 0;
        for (Long threeStrategyEntryId : threeStrategyEntryIdArr) {
            for (String newPermItemId : newPermItemIds) {
                for (Map.Entry appEnt : appEntMap.entrySet()) {
                    String appId = (String)appEnt.getKey();
                    String entNum = (String)appEnt.getValue();
                    String unique = threeStrategyEntryId + "_" + appId + "_" + entNum + "_" + newPermItemId;
                    if (exist.contains(unique)) continue;
                    paramList.add(new Object[]{threeStrategyEntryId, detailIds[idx], 0, appId, entNum, newPermItemId});
                    ++idx;
                }
            }
        }
        if (null == paramList || paramList.isEmpty()) {
            return;
        }
        String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
        SqlUtil.syncInsert(paramList, (String)sql, (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.base, (boolean)true);
    }

    private static Set<String> queryForAdminSchemeDetail(Long[] threeStrategyEntryIdArr, Map<String, String> appEntMap, String[] newPermItemIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail where 1=1 ", new Object[0]);
        sqlBuilder.appendIn(" and fentryid", (Object[])threeStrategyEntryIdArr);
        sqlBuilder.appendIn(" and fbizappid", (Object[])appEntMap.keySet().toArray(new String[appEntMap.size()]));
        sqlBuilder.appendIn(" and fentitynum", (Object[])appEntMap.values().toArray(new String[appEntMap.size()]));
        sqlBuilder.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> exist = new HashSet<String>(8);
                while (rs.next()) {
                    exist.add(rs.getObject("fentryid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
    }

    private static void copyPermForBizRoleDisPerm(String oldAppId, String newAppId, String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermBySureAppEntPermItemUtil.queryForBizRoleDisPerm(oldAppId, oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermBySureAppEntPermItemUtil.existForBizRoleDisPerm(exist, dataSet.copy(), newAppId, newEntityTypeId, newPermItemIds);
        AppendPermBySureAppEntPermItemUtil.insertForBizRoleDisPerm(exist, dataSet, count, newAppId, newEntityTypeId, newPermItemIds);
    }

    private static void insertForBizRoleDisPerm(Set<String> exist, DataSet dataSet, int count, String newAppId, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroledisperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroledisperm", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(count * newPermItemIds.length);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + newAppId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, newAppId};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static int existForBizRoleDisPerm(final Set<String> exist, DataSet dataSet, String newAppId, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm", new Object[0]);
        existSql.append(" where fbizappid = ?", new Object[]{newAppId});
        existSql.append(" and fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static DataSet queryForBizRoleDisPerm(String oldAppId, String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm ");
        querySql.append(" where fbizappid = ?");
        querySql.append(" and fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldAppId, oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermBySureAppEntPermItemUtil#queryForBizRoleDisPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static void copyPermForBizRolePerm(String oldAppId, String newAppId, String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermBySureAppEntPermItemUtil.queryForBizRolePerm(oldAppId, oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermBySureAppEntPermItemUtil.existForBizRolePerm(exist, dataSet.copy(), newAppId, newEntityTypeId, newPermItemIds);
        AppendPermBySureAppEntPermItemUtil.insertForBizRolePerm(exist, dataSet, count, newAppId, newEntityTypeId, newPermItemIds);
    }

    private static void insertForBizRolePerm(Set<String> exist, DataSet dataSet, int count, String newAppId, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroleperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroleperm", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + newAppId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, newAppId};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static int existForBizRolePerm(final Set<String> exist, DataSet dataSet, String newAppId, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm", new Object[0]);
        existSql.append(" where fbizappid = ?", new Object[]{newAppId});
        existSql.append(" and fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static DataSet queryForBizRolePerm(String oldAppId, String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm ");
        querySql.append(" where fbizappid = ?");
        querySql.append(" and fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldAppId, oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static void copyPermForDisFunPerm(String oldAppId, String newAppId, String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermBySureAppEntPermItemUtil.queryForDisFunPerm(oldAppId, oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermBySureAppEntPermItemUtil.existForDisFunPerm(exist, dataSet.copy(), newAppId, newEntityTypeId, newPermItemIds);
        AppendPermBySureAppEntPermItemUtil.insertForUserRoleDisFunPerm(exist, dataSet, count, newAppId, newEntityTypeId, newPermItemIds);
    }

    private static void insertForUserRoleDisFunPerm(Set<String> exist, DataSet copy, int count, String newAppId, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_disfunperm");
        insertSql.append(" (fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_disfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : copy) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("forgid") + "_" + newAppId + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("fdimtype") + "_" + row.get("fisincludesuborg");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{ids[index++], row.get("fuserid"), row.get("forgid"), newPermItemId, newEntityTypeId, row.get("fentryid"), row.get("ffrom"), newAppId, row.get("fsource"), row.get("fbizroleid"), row.get("fdimtype"), row.get("fisincludesuborg")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static DataSet queryForDisFunPerm(String oldAppId, String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm ");
        querySql.append(" where fbizappid = ?");
        querySql.append(" and fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldAppId, oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermBySureAppEntPermItemUtil#queryForDisFunPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForDisFunPerm(final Set<String> exist, DataSet dataSet, String newAppId, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> orgIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            orgIds.add(row.get("forgid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,forgid,fbizappid,fentitytypeid,fpermitemid,fdimtype,fisincludesuborg from t_perm_disfunperm", new Object[0]);
        existSql.append(" where fbizappid = ?", new Object[]{newAppId});
        existSql.append(" and fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            existSql.appendIn(" and forgid ", orgIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("forgid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesuborg"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void copyPermForRolePermDetail(String oldAppId, String newAppId, String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermBySureAppEntPermItemUtil.queryForRolePermDetail(oldAppId, oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermBySureAppEntPermItemUtil.existForRolePermDetail(exist, dataSet.copy(), newAppId, newEntityTypeId, newPermItemIds);
        AppendPermBySureAppEntPermItemUtil.insertForUserRolePermDetail(exist, dataSet, count, newAppId, newEntityTypeId, newPermItemIds);
    }

    private static DataSet queryForRolePermDetail(String oldAppId, String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial ");
        querySql.append(" where fbizappid = ?");
        querySql.append(" and fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldAppId, oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermBySureAppEntPermItemUtil#queryForRolePermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForRolePermDetail(final Set<String> exist, DataSet dataSet, String newAppId, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> roleIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            roleIds.add(row.get("froleid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fbizappid,fentitytypeid,fpermitemid,froleid from t_perm_rolepermdetial", new Object[0]);
        existSql.append(" where fbizappid = ?", new Object[]{newAppId});
        existSql.append(" and fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(roleIds)) {
            existSql.appendIn(" and froleid", roleIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("froleid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForUserRolePermDetail(Set<String> exist, DataSet dataSet, int count, String newAppId, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_rolepermdetial");
        insertSql.append(" (fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?);");
        String[] entryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = newAppId + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("froleid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), entryIds[index++], row.get("fseq"), row.get("fcontrolmode"), newPermItemId, row.get("finheritmode"), newEntityTypeId, newAppId, row.get("froleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void copyPermForUserPermDetail(String oldAppId, String newAppId, String oldEntNum, String newEntNum, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermBySureAppEntPermItemUtil.queryForUserPermDetail(oldAppId, oldEntNum, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermBySureAppEntPermItemUtil.existForUserPermDetail(exist, dataSet.copy(), newAppId, newEntNum, newPermItemIds);
        AppendPermBySureAppEntPermItemUtil.insertForUserPermDetail(exist, dataSet, count, newAppId, newEntNum, newPermItemIds);
    }

    private static DataSet queryForUserPermDetail(String oldAppId, String oldEntNum, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail ");
        querySql.append(" where fbizappid = ?");
        querySql.append(" and fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldAppId, oldEntNum, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermBySureAppEntPermItemUtil#queryForUserPermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForUserPermDetail(final Set<String> exist, DataSet dataSet, String newAppId, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> dimIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            dimIds.add(row.get("fdimid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,fbizappid,fentitytypeid,fpermitemid,fdimid,fdimtype,fisincludesub from t_perm_userpermdetail", new Object[0]);
        existSql.append(" where fbizappid = ?", new Object[]{newAppId});
        existSql.append(" and fentitytypeid = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and  fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(dimIds)) {
            existSql.appendIn(" and fdimid ", dimIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesub"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForUserPermDetail(Set<String> exist, DataSet dataSet, int count, String newAppId, String newEntNum, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_userpermdetail");
        insertSql.append(" (fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)T_PERM_USERPERMDETAIL, (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + newAppId + "_" + newEntNum + "_" + newPermItemId + "_" + row.get("fdimid") + "_" + row.get("fdimtype") + "_" + row.get("fisincludesub");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), row.get("fuserid"), row.get("fdimtype"), row.get("fdimid"), row.get("fisincludesub"), String.valueOf(entryIds[index++]), row.get("fseq"), row.get("fcontrolmode"), newPermItemId, newEntNum, newAppId, row.get("fsource"), row.get("fbizroleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void copyPermForAdmingroupFunperm(String oldAppId, String newAppId, String oldEntNum, String newEntNum, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermBySureAppEntPermItemUtil.queryForAdmingroupFunperm(oldAppId, oldEntNum, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermBySureAppEntPermItemUtil.existForAdmingroupFunperm(exist, dataSet.copy(), newAppId, newEntNum, newPermItemIds);
        AppendPermBySureAppEntPermItemUtil.insertForAdmingroupFunperm(exist, dataSet, count, newAppId, newEntNum, newPermItemIds);
    }

    private static DataSet queryForAdmingroupFunperm(String oldAppId, String oldEntNum, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm ");
        querySql.append(" where fappid = ?");
        querySql.append(" and fentitynum = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldAppId, oldEntNum, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermBySureAppEntPermItemUtil#queryForAdmingroupFunperm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForAdmingroupFunperm(final Set<String> exist, DataSet dataSet, String newAppId, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> usrgrpIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            usrgrpIds.add(row.get("fusergroupid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm", new Object[0]);
        existSql.append(" where fappid = ?", new Object[]{newAppId});
        existSql.append(" and fentitynum = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(usrgrpIds)) {
            existSql.appendIn(" and  fusergroupid ", usrgrpIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fusergroupid") + "_" + rs.getObject("fappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForAdmingroupFunperm(Set<String> exist, DataSet dataSet, int count, String newAppId, String newEntNum, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_admingroupfunperm");
        insertSql.append(" (fid, fusergroupid, fappid, fpermitemid, fentitynum)");
        insertSql.append(" VALUES(?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_admingroupfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fusergroupid") + "_" + newAppId + "_" + newEntNum + "_" + newPermItemId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fusergroupid"), newAppId, newPermItemId, newEntNum};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void addOperLog(String procInfo) {
        AppLogInfo appLogInfo = new AppLogInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOpName(ResManager.loadKDString((String)"\u3010\u786e\u5b9a\u524d\u540e\u5e94\u7528\u8868\u5355\u6743\u9650\u9879\u3011\u5347\u7ea7", (String)"AppendPermBySureAppEntPermItemUtil_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        appLogInfo.setOpDescription(procInfo);
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private static List<String> queryAllSysApp(boolean returnNum, boolean includeSpecificApp) {
        ArrayList<String> finalList = new ArrayList<String>(8);
        ArrayList<String> appInSysServCloud = new ArrayList<String>(8);
        try {
            Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("bizcloud", "=", (Object)"83bfebc800000bac"), new QFilter("type", "=", (Object)"0")});
            if (appMap != null && !appMap.isEmpty()) {
                for (DynamicObject appObj : appMap.values()) {
                    if (returnNum) {
                        appInSysServCloud.add(appObj.getString("number"));
                        continue;
                    }
                    appInSysServCloud.add(appObj.getString("id"));
                }
            }
        }
        catch (Exception var7) {
            logger.error((Throwable)var7);
            return finalList;
        }
        finalList.addAll(appInSysServCloud);
        List<String> appInBaseServCloud = AppendPermBySureAppEntPermItemUtil.getSysAppInBaseServCloud(returnNum, includeSpecificApp);
        finalList.addAll(appInBaseServCloud);
        return finalList;
    }

    private static List<String> getSysAppInBaseServCloud(boolean returnNum, boolean includeSpecificApp) {
        ArrayList<String> list = new ArrayList<String>();
        if (returnNum) {
            list.add("base");
            list.add("secm");
            list.add("cts");
            list.add("customize");
            if (includeSpecificApp) {
                list.add("basedata");
            }
        } else {
            list.add("83bfebc8000037ac");
            list.add("0XWTKVOQW+ML");
            list.add("18XR3MJ0W0ET");
            list.add("3CB4=UTSOT52");
            if (includeSpecificApp) {
                list.add("0efa1992000000ac");
            }
        }
        return list;
    }

    private static Map<String, Set<String>> getOri2ExtAppIdMap(Set<String> appIdSet) {
        StringBuilder sql = new StringBuilder("select fid, fmasterid from t_meta_bizapp where 1=1 ");
        if (null != appIdSet && !appIdSet.isEmpty()) {
            String appIdStr = String.join((CharSequence)"','", appIdSet);
            sql.append(" and (fid in ('").append(appIdStr).append("')");
            sql.append(" or fmasterid in ('").append(appIdStr).append("'))");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            HashMap<String, Set> result = new HashMap<String, Set>(100);
            while (rs.next()) {
                String id = rs.getString("fid");
                String masterid = rs.getString("fmasterid");
                String key = StringUtils.isEmpty((String)masterid) ? id : masterid;
                result.computeIfAbsent(key, k -> new HashSet(8)).add(id);
            }
            return result;
        });
    }

    private static List<String> queryAllSysApp(boolean returnNum, boolean includeSpecificApp, boolean includeExt) {
        List<String> finalList = AppendPermBySureAppEntPermItemUtil.queryAllSysApp(returnNum, includeSpecificApp);
        if (!returnNum && includeExt && finalList != null && !finalList.isEmpty()) {
            Map<String, Set<String>> ori2ExtAppIdMap = AppendPermBySureAppEntPermItemUtil.getOri2ExtAppIdMap(new HashSet<String>(finalList));
            HashSet<String> finalSet = new HashSet<String>(finalList);
            if (ori2ExtAppIdMap != null && !ori2ExtAppIdMap.isEmpty()) {
                for (String appId : finalList) {
                    Set<String> extAppIds;
                    if (StringUtils.isEmpty((String)appId) || (extAppIds = ori2ExtAppIdMap.get(appId)) == null || extAppIds.isEmpty()) continue;
                    finalSet.addAll(extAppIds);
                }
                finalList = new ArrayList<String>(finalSet);
            }
        }
        return finalList;
    }
}

