/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.permission.data.AuthBizBean;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeTabEnum;
import kd.epm.epbs.common.util.ModelUtil;

public class AuthSetUtils {
    public static final String AUTH_TYPE = "authtype";
    public static final String FROM_SOURCE = "fromSource";

    public static void openF7(IFormView formView, CloseCallBack closeCallBack, AuthTypeEnum authTypeEnum) {
        AuthSetUtils.openF7(formView, closeCallBack, authTypeEnum, e -> {});
    }

    public static void openF7(IFormView formView, CloseCallBack closeCallBack, AuthTypeEnum authTypeEnum, Consumer<FormShowParameter> consumer) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epbs_auth_set_form");
        formShowParameter.setCaption(authTypeEnum.getDesc().loadKDString());
        consumer.accept(formShowParameter);
        formShowParameter.setCustomParam(AUTH_TYPE, (Object)(authTypeEnum.getType() + ""));
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formView.showForm(formShowParameter);
    }

    public static void copyDefaultAuthSet2Model(Long modelId) {
        String appNum = ModelUtil.getAppType((Long)modelId).getAppNum();
        QFilter qf = new QFilter("appnum", "=", (Object)appNum);
        if (QueryServiceHelper.exists((String)"epbs_auth_set", (QFilter[])new QFilter[]{qf, new QFilter("model_id", "=", (Object)modelId)})) {
            return;
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        qf.and("model_id", "=", (Object)0L);
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"epbs_auth_set", (QFilter[])qf.toArray(), null, (int)-1);
        if (!objects.isEmpty()) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epbs_auth_set");
            long currUserId = RequestContext.getOrCreate().getCurrUserId();
            Date time = TimeServiceHelper.now();
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects.toArray(), (DynamicObjectType)dataEntityType);
            DynamicObject[] arr = new DynamicObject[load.length];
            for (int i = 0; i < load.length; ++i) {
                arr[i] = (DynamicObject)cloneUtils.clone((IDataEntityType)dataEntityType, (Object)load[i]);
                arr[i].set("model_id", (Object)modelId);
                arr[i].set("creator", (Object)currUserId);
                arr[i].set("createtime", (Object)time);
                arr[i].set("modifier", (Object)currUserId);
                arr[i].set("modifytime", (Object)time);
            }
            SaveServiceHelper.save((DynamicObject[])arr);
        }
    }

    private static AuthBizBean createBizBean(AuthTypeTabEnum authTypeTab, String entityNumber, String type) {
        AuthBizBean bizBean = new AuthBizBean(authTypeTab.getBizId(), authTypeTab.name().toLowerCase(), authTypeTab.getDesc().loadKDString(), entityNumber);
        bizBean.setAuthType(authTypeTab.getTypeEnum().getType());
        bizBean.setType(type);
        return bizBean;
    }

    public static List<AuthBizBean> queryAuthSets(AuthTypeEnum authTypeEnum, long modelId, int sourceType, QFilter authSetFilter) {
        String dimEntityNumber = null;
        LinkedHashMap<Long, AuthBizBean> biztype2Map = new LinkedHashMap<Long, AuthBizBean>(16);
        ArrayList<AuthBizBean> list = new ArrayList<AuthBizBean>(10);
        if (modelId > 0L) {
            String appNum = ModelUtil.getAppType((Long)modelId).getAppNum();
            QFilter qf = new QFilter("appnum", "=", (Object)appNum);
            if (AuthTypeEnum.DIM == authTypeEnum) {
                qf.and("biztype", "=", (Object)"0");
            }
            DynamicObjectCollection bizs = QueryServiceHelper.query((String)"epbs_auth_bizset", (String)"biztype,id,entitynumber,number,name,type", (QFilter[])qf.toArray());
            LinkedHashMap<String, String> bizname = new LinkedHashMap<String, String>(16);
            for (DynamicObject biz : bizs) {
                String type = biz.getString("type");
                if (biz.getString("number").equalsIgnoreCase(AuthTypeEnum.DIM.name())) {
                    dimEntityNumber = biz.getString("entitynumber");
                    if (AuthTypeEnum.DIM == authTypeEnum) {
                        if (type.contains(",1,")) {
                            list.add(AuthSetUtils.createBizBean(AuthTypeTabEnum.SINGLE_DIM, dimEntityNumber, type));
                        }
                        if (type.contains(",4,")) {
                            list.add(AuthSetUtils.createBizBean(AuthTypeTabEnum.Multi_DIM, dimEntityNumber, type));
                        }
                    } else if (AuthTypeEnum.ADMIN == authTypeEnum && type.contains(",3,")) {
                        list.add(AuthSetUtils.createBizBean(AuthTypeTabEnum.ADMIN_DIM, dimEntityNumber, type));
                    }
                } else if (authTypeEnum == AuthTypeEnum.ADMIN && type.contains(",3,") && list.size() < 2 && !list.stream().anyMatch(e -> e.getAuthbiz() == AuthTypeTabEnum.ADMIN_BIZ.getBizId())) {
                    list.add(AuthSetUtils.createBizBean(AuthTypeTabEnum.ADMIN_BIZ, "epbs_auth_bizset", type));
                }
                bizname.put(biz.getString("number"), biz.getString("name"));
            }
            HashMap dimMap = new HashMap(16);
            if (StringUtils.isNotEmpty(dimEntityNumber)) {
                QueryServiceHelper.query((String)dimEntityNumber, (String)"number,name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray()).forEach(dy -> dimMap.put(dy.getString("number"), dy.getString("name")));
            }
            QFilter qFilter = new QFilter("appnum", "=", (Object)appNum);
            qFilter.and(AUTH_TYPE, "=", (Object)(authTypeEnum.getType() + ""));
            qFilter.and(authSetFilter);
            QFilter qFilter2 = new QFilter("model_id", "=", (Object)(sourceType != 0 ? modelId : 0L));
            DynamicObject[] sets = BusinessDataServiceHelper.load((String)"epbs_auth_set", (String)"id,authbiz_id,model_id,authtype,entryentity.entitynumber,entryentity.dimnumber,entryentity.seq,entryentity.group,entryentity.hasperm", (QFilter[])new QFilter[]{qFilter, qFilter2}, (String)"dseq,entryentity.group,entryentity.seq");
            Map<Long, DynamicObject> bizMap = bizs.stream().collect(Collectors.toMap(k -> k.getLong("id"), k -> k));
            String finalDimEntityNumber = dimEntityNumber;
            list.forEach(e -> biztype2Map.put(e.getAuthbiz(), (AuthBizBean)e));
            for (DynamicObject dy2 : sets) {
                long authbiz = dy2.getLong("authbiz_id");
                AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)authbiz);
                AuthBizBean bizBean = biztype2Map.computeIfAbsent(authbiz, a -> {
                    DynamicObject bizDy = (DynamicObject)bizMap.get(authbiz);
                    AuthBizBean authBizBean = new AuthBizBean(authbiz, bizDy.getString("number"), bizDy.getString("name"), finalDimEntityNumber);
                    authBizBean.setType(bizDy.getString("type"));
                    authBizBean.setAuthType(tabEnum.getTypeEnum().getType());
                    list.add(authBizBean);
                    return authBizBean;
                });
                dy2.getDynamicObjectCollection("entryentity").forEach(e -> {
                    String name = null;
                    if (authbiz == AuthTypeTabEnum.SINGLE_DIM.getBizId() || authbiz == AuthTypeTabEnum.Multi_DIM.getBizId() || authbiz == AuthTypeTabEnum.ADMIN_DIM.getBizId()) {
                        name = (String)dimMap.get(e.getString("dimnumber"));
                    } else if (authbiz == AuthTypeTabEnum.ADMIN_BIZ.getBizId() || e.getInt("seq") == 0 || !bizBean.getDatas().containsKey(e.getLong("group"))) {
                        name = (String)bizname.get(e.getString("dimnumber"));
                    }
                    if (name == null) {
                        name = (String)dimMap.get(e.getString("dimnumber"));
                    }
                    bizBean.addData(e.getLong("group"), new AuthSetDetailBean(e.getString("entitynumber"), e.getString("dimnumber"), name), e.getBoolean("hasperm"));
                });
            }
        }
        return list;
    }

    public static boolean groupCheck(long modelId, Collection<Object> groupids) {
        QFilter qFilter = new QFilter("groupset", "in", groupids);
        if (modelId > 0L) {
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"epbs_dataperm_tree", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, null, (int)-1);
            if (!ids.isEmpty()) {
                qFilter.and("permtree", "in", AuthSetUtils.getDataPermTreeId(modelId));
            } else {
                qFilter.and("permtree", "=", (Object)0L);
            }
        }
        return QueryServiceHelper.exists((String)"epbs_dataperm_assign", (QFilter[])qFilter.toArray());
    }

    public static Collection<Object> getDataPermTreeId(long modelId) {
        ArrayList<Object> list = new ArrayList<Object>(10);
        AuthSetUtils.queryDataPermTree(Collections.singleton(modelId), new QFilter("model", "=", (Object)modelId), list);
        return list;
    }

    private static void queryDataPermTree(Collection<Long> parentIds, QFilter qFilter, Collection<Object> list) {
        if (!CollectionUtils.isEmpty(parentIds)) {
            QFilter qf = new QFilter("parent", "in", parentIds);
            qf.or(qFilter);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_dataperm_tree", (String)"id,model,parent", (QFilter[])qf.toArray());
            HashSet<Long> parentModels = new HashSet<Long>(10);
            dys.stream().forEach(dy -> {
                list.add(dy.getLong("id"));
                if (dy.getLong("parent") != 0L) {
                    parentModels.add(dy.getLong("model"));
                }
            });
            AuthSetUtils.queryDataPermTree(parentModels, null, list);
        }
    }
}

