/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.permission.bean.PermMemberBean;
import kd.epm.epbs.business.permission.bean.TabManagerBean;
import kd.epm.epbs.business.permission.bean.TabRowBean;
import kd.epm.epbs.business.permission.data.AuthBizBean;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.business.permission.data.AuthSetRowBean;
import kd.epm.epbs.business.permission.util.AuthSetUtils;
import kd.epm.epbs.business.permission.util.TabManagerHelper;
import kd.epm.epbs.common.bean.tab.TabInfo;
import kd.epm.epbs.common.bean.tab.TabManager;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.DataPermValEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DataRoleUtils {
    public static final String RANGE_DIM = "range_dim";
    public static final String NUMBER_DIM = "number_dim";
    public static final String NAME_DIM = "name_dim";
    public static final String VIEW_DIM = "view_dim";
    public static final String INFO_DIM = "info_dim";
    public static final Log LOG = LogFactory.getLog(DataRoleUtils.class);
    public static final String FOCUS_NODE_DATA = "focusNodeData";
    public static final String FOCUS_NODE_ID = "focusNodeId";
    public static final String TAB_DIMENSION = "tab_dimension";
    public static final String TAB_BUSINESS = "tab_business";
    public static final String TAB_MANGE = "tab_mange";
    public static final String TAB_PERMISSIONENTITY = "tab_permissionentity";
    public static final String SECOND_LEVEL_TABAP = "tabap1";
    public static final String FIRST_LEVEL_TABAP = "tabap";
    public static final String[] FIRST_LEVEL_TABS = new String[]{"tab_dimension", "tab_business", "tab_mange"};
    public static final String AUTH_BIZ_BEANS = "authBizBeans";
    public static final String SELECT_BIZMODEL_ID = "leftTreeBizModelId";
    public static final String DELETE_BIZMODEL_ID = "deleteLeftTreeBizModelId";
    public static final String SELECT_BIZMODEL_ENTITYNUMBER = "leftTreeEntityNumber";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String USERGROUP = "usergroup";
    public static final String PAGE_ID_LIST = "pageIdList";
    public static final String USER = "user";
    public static final String DATA_CHANGED = "DATA_CHANGED";

    public static AuthTypeEnum getAuthType(String firstLevelTab) {
        switch (firstLevelTab) {
            case "tab_dimension": {
                return AuthTypeEnum.DIM;
            }
            case "tab_business": {
                return AuthTypeEnum.BIZ;
            }
            case "tab_mange": {
                return AuthTypeEnum.ADMIN;
            }
        }
        return null;
    }

    public static TreeNode getFocusTreeNode(TreeView treeView) {
        TreeNode rootWithCache = AbstractTreeBuilder.getRootWithCache((TreeView)treeView);
        return rootWithCache.getTreeNode(treeView.getTreeState().getFocusNodeId());
    }

    public static TabManager<TabInfo<DynamicObjectCollection>> getTabManager(String serializedStr) {
        return StringUtils.isNotEmpty((CharSequence)serializedStr) ? (TabManager)ObjectSerialUtil.deSerializedBytes((String)serializedStr) : new TabManager();
    }

    @NotNull
    public static String genCacheModelFirstLevelTabManagers(long entityPrimaryId) {
        return String.format("modelFirstLevelTabManagers#%d", entityPrimaryId);
    }

    public static void createModelTabManagerCache(long roleId, IPageCache pageCache) {
        DynamicObjectCollection leftTreeDys = QueryServiceHelper.query((String)"epbs_dataperm_tree", (String)"id,model,entryentity.groupset,entryentity.authtype", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        LinkedHashMap<String, List<DynamicObject>> permTreeDys = new LinkedHashMap<String, List<DynamicObject>>();
        QFBuilder qFilter = new QFBuilder();
        ArrayList permTreeIds = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)leftTreeDys)) {
            return;
        }
        leftTreeDys.forEach(dy -> {
            permTreeDys.computeIfAbsent(dy.getString("model") + "_" + dy.getInt("entryentity.authtype"), k -> new ArrayList()).add(dy);
            permTreeIds.add(dy.getLong("id"));
        });
        LinkedHashMap<Long, Map<Long, List<TabRowBean>>> modelGroupId2Rows = new LinkedHashMap<Long, Map<Long, List<TabRowBean>>>();
        LinkedHashMap<Long, List<DynamicObject>> modelId2AssignDys = new LinkedHashMap<Long, List<DynamicObject>>();
        DynamicObjectCollection rowDetails = QueryServiceHelper.query((String)"epbs_dataperm_assign", (String)"id,groupset,permtree.id,permtree.model,permval,entryentity.id,entryentity.memberid,entryentity.scope,entryentity.dimnumber,entryentity.entitynumber,entryentity.seq", (QFilter[])qFilter.add("permtree", "in", permTreeIds).toArray(), (String)"permtree.model,dseq,entryentity.seq");
        rowDetails.forEach(rowDetail -> modelId2AssignDys.computeIfAbsent(rowDetail.getLong("permtree.model"), k -> new ArrayList()).add(rowDetail));
        DataRoleUtils.createTabRowBean(modelId2AssignDys, modelGroupId2Rows);
        DataRoleUtils.createTabManagerBean(pageCache, permTreeDys, modelGroupId2Rows);
    }

    private static void createTabRowBean(Map<Long, List<DynamicObject>> modelId2AssignDys, Map<Long, Map<Long, List<TabRowBean>>> modelGroupId2Rows) {
        modelId2AssignDys.forEach((modelId, dys) -> {
            if (CollectionUtils.isEmpty((Collection)dys)) {
                return;
            }
            for (DynamicObject dynamicObject : dys) {
                long id = dynamicObject.getLong("id");
                modelGroupId2Rows.putIfAbsent((Long)modelId, new LinkedHashMap());
                long groupId = dynamicObject.getLong("groupset");
                TabRowBean tabRowBean = new TabRowBean(groupId, id);
                Map groupId2Row = (Map)modelGroupId2Rows.get(modelId);
                groupId2Row.putIfAbsent(tabRowBean.getGroupId(), new ArrayList());
                int index = ((List)groupId2Row.get(tabRowBean.getGroupId())).indexOf(tabRowBean);
                if (index > -1) {
                    tabRowBean = (TabRowBean)((List)groupId2Row.get(groupId)).get(index);
                } else {
                    ((List)groupId2Row.get(tabRowBean.getGroupId())).add(tabRowBean);
                    tabRowBean.setPermVal(dynamicObject.getInt("permval"));
                }
                PermMemberBean permMemberBean = new PermMemberBean(dynamicObject.getLong("entryentity.id"));
                permMemberBean.setMemberid(dynamicObject.getString("entryentity.memberid"));
                permMemberBean.setScope(dynamicObject.getInt("entryentity.scope"));
                permMemberBean.setDimnumber(dynamicObject.getString("entryentity.dimnumber"));
                permMemberBean.setEntityNumber(dynamicObject.getString("entryentity.entitynumber"));
                permMemberBean.setSeq(dynamicObject.getInt("entryentity.seq"));
                tabRowBean.addPermMemberBean(permMemberBean);
            }
        });
    }

    private static void createTabManagerBean(IPageCache pageCache, Map<String, List<DynamicObject>> permTreeDys, Map<Long, Map<Long, List<TabRowBean>>> modelGroupId2Rows) {
        permTreeDys.forEach((k, v) -> {
            String[] split = k.split("_");
            String modelId = split[0];
            AuthTypeEnum authTypeEnum = AuthTypeEnum.indexof((byte)Byte.parseByte(split[1]));
            long modelIdLong = Long.parseLong(modelId);
            Map<Long, Long> groupId2Id = v.stream().filter(dy -> dy.getLong("entryentity.groupset") > 0L).collect(Collectors.toMap(dy -> dy.getLong("entryentity.groupset"), dy -> dy.getLong("id")));
            List<AuthBizBean> authBizBeans = AuthSetUtils.queryAuthSets(authTypeEnum, modelIdLong, 1, new QFilter("entryentity.group", "in", groupId2Id.keySet()));
            List<TabManagerBean> tabManagerBeans = DataRoleUtils.processAuthBizBean(authBizBeans, modelIdLong);
            TabManagerHelper tabManagerHelper = TabManagerHelper.getInstance(pageCache, modelId);
            tabManagerBeans.forEach(tabManagerBean -> {
                List<TabRowBean> tabRowBeans;
                if (groupId2Id.containsKey(tabManagerBean.getGroupId())) {
                    tabManagerBean.setPermTreeId((Long)groupId2Id.get(tabManagerBean.getGroupId()));
                }
                if (CollectionUtils.isNotEmpty(tabRowBeans = modelGroupId2Rows.getOrDefault(modelIdLong, Collections.emptyMap()).getOrDefault(tabManagerBean.getGroupId(), Collections.emptyList()))) {
                    tabManagerBean.setTabRowBeans(tabRowBeans);
                    tabManagerHelper.addTab(pageCache, DataRoleUtils.authTypeEnum2FirstLevelTab(authTypeEnum), false, tabManagerBean);
                }
            });
        });
    }

    private static String authTypeEnum2FirstLevelTab(AuthTypeEnum authType) {
        switch (authType) {
            case DIM: {
                return TAB_DIMENSION;
            }
            case BIZ: {
                return TAB_BUSINESS;
            }
            case ADMIN: {
                return TAB_MANGE;
            }
        }
        return "";
    }

    public static AuthTypeEnum firstLevelTab2AuthTypeEnum(String firstLevelTab) {
        switch (firstLevelTab) {
            case "tab_dimension": {
                return AuthTypeEnum.DIM;
            }
            case "tab_business": {
                return AuthTypeEnum.BIZ;
            }
            case "tab_mange": {
                return AuthTypeEnum.ADMIN;
            }
        }
        return null;
    }

    public static List<TabManagerBean> processAuthBizBean(List<AuthBizBean> authBizBeanList, long selectleftTreeModelId) {
        ArrayList<TabManagerBean> tabManagerBeans = new ArrayList<TabManagerBean>();
        authBizBeanList.forEach(authBizBean -> authBizBean.getDatas().forEach((k, rowBean) -> {
            TabManagerBean tabManagerBean = DataRoleUtils.createTabManagerBean(rowBean, AuthTypeEnum.indexof((byte)authBizBean.getAuthType()), selectleftTreeModelId, authBizBean.getAuthbiz());
            tabManagerBeans.add(tabManagerBean);
        }));
        return tabManagerBeans;
    }

    @NotNull
    private static TabManagerBean createTabManagerBean(AuthSetRowBean rowBean, AuthTypeEnum type, long selectleftTreeModelId, long bizId) {
        StringJoiner authNameBuilder = new StringJoiner("-");
        StringJoiner authNumberBuilder = new StringJoiner("|");
        rowBean.getDetails().forEach(detail -> {
            authNameBuilder.add(detail.getName());
            authNumberBuilder.add(detail.getDimNumber().toLowerCase(Locale.ENGLISH));
        });
        TabManagerBean tabManagerBean = new TabManagerBean(rowBean.getGroupId());
        tabManagerBean.setNumber(authNumberBuilder.toString());
        tabManagerBean.setName(authNameBuilder.toString());
        tabManagerBean.setAuthType(type.getType());
        tabManagerBean.setParentTabKey(DataRoleUtils.authTypeEnum2FirstLevelTab(type));
        tabManagerBean.setModelId(selectleftTreeModelId);
        tabManagerBean.setBizId(bizId);
        tabManagerBean.setAuthSetRowBean(rowBean);
        return tabManagerBean;
    }

    public static TabManagerBean createTabManagerBean(AuthTypeEnum authTypeEnum, long modelId, long selectBizModelId, long groupSetId) {
        List<AuthBizBean> authBizBeans = AuthSetUtils.queryAuthSets(authTypeEnum, modelId, 1, new QFilter("entryentity.group", "=", (Object)groupSetId));
        if (CollectionUtils.isNotEmpty(authBizBeans)) {
            for (AuthBizBean authBizBean : authBizBeans) {
                Map<Long, AuthSetRowBean> dataMap = authBizBean.getDatas();
                if (!dataMap.containsKey(groupSetId)) continue;
                AuthSetRowBean authSetRowBean = dataMap.get(groupSetId);
                TabManagerBean tabManagerBean = DataRoleUtils.createTabManagerBean(authSetRowBean, authTypeEnum, selectBizModelId, authBizBean.getAuthbiz());
                return tabManagerBean;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u5408\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6388\u6743\u8bbe\u7f6e\u3002", (String)"DataRoleUtils_1", (String)"epm-epbs-business", (Object[])new Object[0]));
    }

    public static TabRowBean transfer2TabRowBean(TabManagerBean data, DynamicObject entry, int dseq) {
        TabRowBean tabRowBean = new TabRowBean(data.getGroupId(), entry.getLong("id"));
        tabRowBean.setDseq(dseq);
        boolean hasGivePerm = entry.getBoolean(DataPermValEnum.GIVE.name().toLowerCase(Locale.ENGLISH));
        int permVal = 0;
        if (hasGivePerm) {
            permVal = DataPermValEnum.GIVE.getVal();
        }
        if (entry.getBoolean(DataPermValEnum.WRITE.name().toLowerCase(Locale.ENGLISH))) {
            permVal += DataPermValEnum.WRITE.getVal();
        } else if (entry.getBoolean(DataPermValEnum.READ.name().toLowerCase(Locale.ENGLISH))) {
            permVal += DataPermValEnum.READ.getVal();
        } else if (entry.getBoolean(DataPermValEnum.NOT_PERM.name().toLowerCase(Locale.ENGLISH))) {
            permVal += DataPermValEnum.NOT_PERM.getVal();
        } else if (entry.getBoolean(DataPermValEnum.EXCEPT.name().toLowerCase(Locale.ENGLISH))) {
            permVal = DataPermValEnum.EXCEPT.getVal();
        } else if (entry.getBoolean(DataPermValEnum.MANAGE.name().toLowerCase(Locale.ENGLISH))) {
            permVal = DataPermValEnum.MANAGE.getVal();
        }
        tabRowBean.setPermVal(permVal);
        List<AuthSetDetailBean> details = data.getAuthSetRowBean().getDetails();
        for (int i = 0; i < details.size(); ++i) {
            tabRowBean.addPermMemberBean(DataRoleUtils.transformMemberBean(entry, i));
        }
        return tabRowBean;
    }

    public static PermMemberBean transformMemberBean(DynamicObject entry, int i) {
        PermMemberBean permMemberBean = new PermMemberBean();
        permMemberBean.setInfoDim(entry.getString(INFO_DIM + i));
        permMemberBean.setScope(entry.getInt(RANGE_DIM + i));
        permMemberBean.setDimnumber(entry.getString(NUMBER_DIM + i));
        permMemberBean.setViewName(entry.getString(VIEW_DIM + i));
        permMemberBean.setSeq(i);
        return permMemberBean;
    }

    public static String genTreeNodeData(long treeId, String entityNumber) {
        return treeId + "&" + entityNumber;
    }

    public static Pair<String, String> genTreeNodeData(TreeNode node) {
        String text = (String)node.getData();
        String[] split = text.split("&");
        return Pair.onePair((Object)split[0], (Object)split[1]);
    }

    public static Optional<TreeNode> matchAndInsertTreeNode(TreeNode insertNode, TreeNode root) {
        Optional<Object> focusNode = Optional.empty();
        TreeNode treeNode = root.getTreeNode(insertNode.getId());
        if (treeNode == null) {
            root.addChild(insertNode);
            ArrayList list = new ArrayList(1);
            insertNode.iterate(4, e -> {
                if (CollectionUtils.isEmpty((Collection)e.getChildren())) {
                    list.add(e);
                }
            });
            focusNode = Optional.of(list.get(0));
        } else if (CollectionUtils.isNotEmpty((Collection)insertNode.getChildren())) {
            for (TreeNode child : insertNode.getChildren()) {
                Optional<TreeNode> s = DataRoleUtils.matchAndInsertTreeNode(child, treeNode);
                if (!s.isPresent() || focusNode.isPresent()) continue;
                focusNode = s;
            }
        }
        return focusNode;
    }

    public static Optional<TreeNode> replaceAndInsertTreeNode(TreeNode insertNode, TreeNode root) {
        Optional<Object> focusNode = Optional.empty();
        TreeNode treeNode = root.getTreeNode(insertNode.getId());
        if (treeNode == null) {
            root.addChild(insertNode);
            ArrayList list = new ArrayList(1);
            insertNode.iterate(4, e -> {
                if (CollectionUtils.isEmpty((Collection)e.getChildren())) {
                    list.add(e);
                }
            });
            focusNode = Optional.of(list.get(0));
        } else {
            treeNode.setText(insertNode.getText());
            if (!CollectionUtils.isEmpty((Collection)insertNode.getChildren())) {
                for (TreeNode child : insertNode.getChildren()) {
                    Optional<TreeNode> s = DataRoleUtils.replaceAndInsertTreeNode(child, treeNode);
                    if (!s.isPresent() || focusNode.isPresent()) continue;
                    focusNode = s;
                }
            }
        }
        return focusNode;
    }

    public static long getEpbsModelId(TreeNode root, TreeNode selectNode) {
        if (selectNode.getData() != null && "epbs_model".equals(DataRoleUtils.genTreeNodeData((TreeNode)selectNode).p2)) {
            return IDUtils.toLong((Object)selectNode.getId());
        }
        TreeNode treeNode = root.getTreeNode(selectNode.getParentid());
        if (treeNode != null) {
            return DataRoleUtils.getEpbsModelId(root, treeNode);
        }
        return 0L;
    }
}

