/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.epm.epbs.business.permission.util.DmpLoginModel;

public class DmpServiceHelper {
    protected static final Log log = LogFactory.getLog(DmpServiceHelper.class);
    private DmpLoginModel dmpLogin;
    private boolean isLogin = false;
    private String accessToken = null;
    private Map<String, String> queryParaMap = new HashMap<String, String>(16);

    public DmpServiceHelper(DmpLoginModel dmpLogin) {
        this.dmpLogin = dmpLogin;
    }

    public String getAppToken() {
        try {
            HashMap<String, String> bodyMap = new HashMap<String, String>(8);
            bodyMap.put("appId", this.dmpLogin.getAppId());
            bodyMap.put("appSecret", this.dmpLogin.getAppSecret());
            bodyMap.put("accountId", this.dmpLogin.getAccountId());
            bodyMap.put("tenantid", this.dmpLogin.getTenantId());
            String bodyStr = JSONObject.toJSONString(bodyMap);
            String appTokenURL = this.dmpLogin.getPostUrl() + "/api/getAppToken.do";
            String resultObj = this.doPostByHttpClient(appTokenURL, bodyStr);
            Map res = (Map)SerializationUtils.fromJsonString((String)resultObj, Map.class);
            Object data = res.get("data");
            String appToken = null;
            if (null != data) {
                if ("success".equalsIgnoreCase(res.get("state").toString())) {
                    if (data instanceof Map) {
                        appToken = ((Map)data).get("app_token").toString();
                    } else if (data instanceof JSONObject) {
                        appToken = ((JSONObject)data).getString("app_token");
                    }
                } else {
                    throw new KDException("url " + appTokenURL + " login fail " + resultObj);
                }
            }
            return appToken;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private String doPostByHttpClient(String url, String data) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-Type", "application/json; charset=UTF-8");
        return HttpClientUtils.postjson((String)url, header, (String)data);
    }

    public String apiLogin(String appToken) {
        try {
            HashMap<String, String> accessMap = new HashMap<String, String>(8);
            accessMap.put("user", this.dmpLogin.getUserId());
            accessMap.put("usertype", "Mobile");
            accessMap.put("accountId", this.dmpLogin.getAccountId());
            accessMap.put("tenantid", this.dmpLogin.getTenantId());
            accessMap.put("apptoken", appToken);
            String accessString = JSONObject.toJSONString(accessMap);
            String accessTokenURL = this.dmpLogin.getPostUrl() + "/api/login.do";
            String resultObj = this.doPostByHttpClient(accessTokenURL, accessString);
            Map res = (Map)SerializationUtils.fromJsonString((String)resultObj, Map.class);
            String accessToken = null;
            if ("success".equalsIgnoreCase(res.get("state").toString())) {
                Object data = res.get("data");
                if (data instanceof Map) {
                    accessToken = ((Map)data).get("access_token").toString();
                } else if (data instanceof JSONObject) {
                    accessToken = ((JSONObject)data).getString("access_token");
                }
            } else {
                throw new KDException(resultObj);
            }
            return accessToken;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public void sendBugData(Consumer<Map<String, String>> consumer) {
        if (!this.isLogin) {
            this.accessToken = this.apiLogin(this.getAppToken());
            this.isLogin = true;
            this.queryParaMap.put("product", ResManager.loadKDString((String)"\u8d22\u52a1\u4e91\u6570\u636e\u68c0\u67e5\u670d\u52a1", (String)"DmpServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            this.queryParaMap.put("bugtitle", ResManager.loadKDString((String)"\u7528\u4f8b\u8def\u5f84\uff1a\u82cd\u7a79&\u661f\u701a/\u8d22\u52a1\u4e91", (String)"DmpServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            this.queryParaMap.put("route", "667288590585171968");
            String dataenv = String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u540d\u79f0\uff1a%s", (String)"DmpServiceHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), RequestContext.get().getTenantCode());
            this.queryParaMap.put("dataenv", dataenv);
            String name = String.format(ResManager.loadKDString((String)"\u4e8c\u5f00\u5143\u6570\u636e\u9694\u79bb\u7ef4\u5ea6\u626b\u63cf\u6570\u636e\uff1a%1$s %2$s", (String)"DmpServiceHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), RequestContext.getOrCreate().getTenantId(), RequestContext.get().getAccountId());
            this.queryParaMap.put("name", name);
            this.queryParaMap.put("bugdes", "");
            this.queryParaMap.put("pic", this.dmpLogin.getPic());
            this.queryParaMap.put("uid", this.dmpLogin.getPic());
        }
        try {
            Map map;
            String isSuccess;
            consumer.accept(this.queryParaMap);
            String bodyStr = JSONObject.toJSONString(this.queryParaMap);
            String importData = "{\"data\":[\r\n" + bodyStr + "],\r\n\"action\":\"insert\"}";
            System.out.println(importData);
            String url = this.dmpLogin.getPostUrl() + "/kapi/app/dmp/DmpBugApi?access_token=" + this.accessToken;
            String msg = this.doPostByHttpClient(url, importData);
            if (StringUtils.isNotBlank((CharSequence)msg) && !"true".equals(isSuccess = (String)(map = (Map)SerializationUtils.fromJsonString((String)msg, Map.class)).get("success"))) {
                throw new KDException("fail to send dmp bug:" + url);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public Map<String, String> getParams() {
        return this.queryParaMap;
    }
}

