/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.ProjectConstant;

public class MetaDataCheckUtils {
    public static Map<String, Map<String, List<String>>> scanData() {
        HashMap<String, Map<String, List<String>>> resMap = new HashMap<String, Map<String, List<String>>>();
        String sql = "select d.fnumber as entitynumber,app.fnumber as appnum,f.fisv as isv from t_meta_entitydesign d \njoin t_meta_bizapp app on d.fbizappid = app.fid \ninner join t_meta_formdesign f on f.fid=d.fid\nwhere (f.fisv !='kingdee' or app.fnumber not in('cm','eb','bg','di','far','bgm','bgmd','rpt','bgbd','bgc','fidm')) and (d.fdata like '%<DimensionControl>DIM_BCM_MODEL</DimensionControl>%' or d.fdata like '%<DimensionControl>DIM_EPM_MODEL</DimensionControl>%' or d.fdata like '%<DimensionControl>DIM_DM_MODEL</DimensionControl>%')";
        try (DataSet dataSet = DB.queryDataSet((String)"query2devMetadataPage", (DBRoute)DBRoute.meta, (String)sql);){
            while (dataSet.hasNext()) {
                Row rowdata = dataSet.next();
                resMap.computeIfAbsent(rowdata.getString("appnum"), k -> new HashMap(10)).computeIfAbsent(rowdata.getString("isv"), k1 -> new ArrayList(10)).add(rowdata.getString("entitynumber"));
            }
        }
        return resMap;
    }

    public static void syncDB(Map<String, Map<String, List<String>>> data) {
        DB.execute((DBRoute)ProjectConstant.DB_ROUTE, (String)"delete from t_epbs_metadata_check where fappnum !='error'");
        if (!data.isEmpty()) {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "INSERT INTO t_epbs_metadata_check(fid, fappnum, fisv, fentitynums, fcreatetime)VALUES(?,?,?,?,?)";
            ArrayList<Object[]> params = new ArrayList<Object[]>(30);
            for (Map.Entry<String, Map<String, List<String>>> entry : data.entrySet()) {
                String appnum = entry.getKey();
                Map<String, List<String>> v = entry.getValue();
                for (Map.Entry<String, List<String>> e : v.entrySet()) {
                    String isv = e.getKey();
                    List<String> v1 = e.getValue();
                    params.add(new Object[]{GlobalIdUtil.genGlobalLongId(), appnum, isv, String.join((CharSequence)",", v1), now});
                }
            }
            DB.executeBatch((DBRoute)ProjectConstant.DB_ROUTE, (String)sql, params);
        }
    }
}

