/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.permission.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.Consumer;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.epm.epbs.business.permission.bean.TabBaseBean;
import kd.epm.epbs.common.bean.tab.TabInfo;
import kd.epm.epbs.common.bean.tab.TabManager;
import kd.epm.epbs.common.enums.DataRoleTabEnum;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TabManagerHelper<T extends TabBaseBean>
implements Serializable {
    private static final long serialVersionUID = 7637144069642291822L;
    private String modelId;

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public static <T extends TabBaseBean> TabManagerHelper<T> getInstance(IPageCache pageCache, String selectBizModelId) {
        String serial = pageCache.get(TabManagerHelper.class.getName());
        if (StringUtils.isEmpty((String)serial)) {
            HashMap<String, TabManagerHelper<T>> modelTabManager = new HashMap<String, TabManagerHelper<T>>();
            TabManagerHelper<T> tabManagerHelper = new TabManagerHelper<T>();
            tabManagerHelper.setModelId(selectBizModelId);
            modelTabManager.put(selectBizModelId, tabManagerHelper);
            pageCache.put(TabManagerHelper.class.getName(), ObjectSerialUtil.toByteSerialized(modelTabManager));
            return tabManagerHelper;
        }
        Map modelTabManager = (Map)ObjectSerialUtil.deSerializedBytes((String)serial);
        TabManagerHelper<T> tabManagerHelper = (TabManagerHelper<T>)modelTabManager.get(selectBizModelId);
        if (tabManagerHelper == null) {
            tabManagerHelper = new TabManagerHelper<T>();
            tabManagerHelper.setModelId(selectBizModelId);
        }
        return tabManagerHelper;
    }

    public static <T extends TabBaseBean> Map<String, TabManagerHelper<T>> getInstance(IPageCache pageCache) {
        String serial = pageCache.get(TabManagerHelper.class.getName());
        if (StringUtils.isEmpty((String)serial)) {
            HashMap<String, TabManagerHelper<T>> modelTabManager = new HashMap<String, TabManagerHelper<T>>();
            pageCache.put(TabManagerHelper.class.getName(), ObjectSerialUtil.toByteSerialized(modelTabManager));
            return modelTabManager;
        }
        return (Map)ObjectSerialUtil.deSerializedBytes((String)serial);
    }

    public void cacheByTabGroupKey(IPageCache pageCache, String tabGroupKey, T data) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        TabInfo selectedTabInfo = tabManager.getSelectedTabInfo();
        if (selectedTabInfo != null) {
            selectedTabInfo.setData(data);
        }
        tabManager.cacheTabManager(pageCache, this.transGroupKey(tabGroupKey));
    }

    public void cacheByTabGroupKey(IPageCache pageCache, String tabGroupKey, Consumer<T> consumer) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        TabInfo selectedTabInfo = tabManager.getSelectedTabInfo();
        if (selectedTabInfo != null) {
            consumer.accept(selectedTabInfo.getData());
        }
        tabManager.cacheTabManager(pageCache, this.transGroupKey(tabGroupKey));
    }

    public T getData(IPageCache pageCache, String tabGroupKey) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        TabInfo selectedTabInfo = tabManager.getSelectedTabInfo();
        if (selectedTabInfo != null) {
            return (T)((TabBaseBean)selectedTabInfo.getData());
        }
        return null;
    }

    public T getSelectedTabData(IPageCache pageCache, String tabGroupKey) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        TabInfo selectedTabInfo = tabManager.getSelectedTabInfo();
        if (selectedTabInfo != null) {
            return (T)((TabBaseBean)selectedTabInfo.getData());
        }
        return null;
    }

    @NotNull
    private String transGroupKey(String tabGroupKey) {
        return this.modelId + tabGroupKey;
    }

    public TabManager<TabInfo<T>> getTabManager(IPageCache pageCache, String tabGroupKey) {
        String serializedStr = pageCache.get(this.transGroupKey(tabGroupKey));
        return StringUtils.isNotEmpty((String)serializedStr) ? (TabManager)ObjectSerialUtil.deSerializedBytes((String)serializedStr) : new TabManager();
    }

    public void clear(IPageCache pageCache, String tabGroupKey) {
        this.clear(pageCache, tabGroupKey, null);
    }

    public void clear(IPageCache pageCache, String tabGroupKey, String tabKey) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        if (StringUtils.isNotEmpty((String)tabKey)) {
            tabManager.releaseByKey(tabKey);
        } else {
            tabManager.releaseAll();
        }
        tabManager.cacheTabManager(pageCache, this.transGroupKey(tabGroupKey));
    }

    public void addTab(IPageCache pageCache, String tabGroupKey, boolean selectTab, T data) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        TabInfo tabInfo = new TabInfo();
        tabInfo.setTabKey(((TabBaseBean)data).getNumber());
        tabInfo.setName(((TabBaseBean)data).getNameLocaleString());
        tabInfo.setData(data);
        tabManager.addTabInfo(tabInfo);
        if (selectTab) {
            tabManager.selectTabInfo(((TabBaseBean)data).getNumber());
        }
        tabManager.cacheTabManager(pageCache, this.transGroupKey(tabGroupKey));
    }

    public void selectTab(IPageCache pageCache, String tabGroupKey, Consumer<T> consumer, Supplier<Tab> tabSupplier) {
        this.selectTab(pageCache, tabGroupKey, null, consumer, tabSupplier);
    }

    public void selectTab(IPageCache pageCache, String tabGroupKey, String tabKey, Consumer<T> consumer, Supplier<Tab> tabSupplier) {
        TabManager<TabInfo<T>> tabManager = this.getTabManager(pageCache, tabGroupKey);
        if (StringUtils.isEmpty((String)tabKey)) {
            TabInfo selectedTabInfo = tabManager.getSelectedTabInfo();
            if (selectedTabInfo != null) {
                tabKey = selectedTabInfo.getTabKey();
            } else if (CollectionUtils.isNotEmpty((Collection)tabManager.getTabs())) {
                tabKey = ((TabInfo)tabManager.getTabs().get(0)).getTabKey();
                tabManager.selectTabInfo(tabKey);
            }
        } else {
            tabManager.selectTabInfo(tabKey);
        }
        Tab tab = tabSupplier.get();
        if (tab != null) {
            tabManager.activeTab(tab);
        }
        if (StringUtils.isNotEmpty((String)tabKey)) {
            consumer.accept(tabManager.getTabInfo(tabKey).getData());
        }
        tabManager.cacheTabManager(pageCache, this.transGroupKey(tabGroupKey));
    }

    public static void remove(IPageCache pageCache, String modelId) {
        Map modelTabManager;
        TabManagerHelper helper;
        String serial = pageCache.get(TabManagerHelper.class.getName());
        if (StringUtils.isNotEmpty((String)serial) && (helper = (TabManagerHelper)(modelTabManager = (Map)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(TabManagerHelper.class.getName()))).remove(modelId)) != null) {
            for (DataRoleTabEnum firstLevelTab : DataRoleTabEnum.values()) {
                helper.clear(pageCache, firstLevelTab.getTabKey());
            }
        }
    }

    public void release(IPageCache pageCache, String modelId) {
        String serial = pageCache.get(TabManagerHelper.class.getName());
        if (StringUtils.isNotEmpty((String)serial)) {
            Map modelTabManager = (Map)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(TabManagerHelper.class.getName()));
            modelTabManager.remove(modelId);
        }
    }
}

