/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.relation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.business.mservice.DataModelMsHelper;
import kd.epm.epbs.business.mservice.EPDMDataRequest;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.business.mservice.EPDMFilter;
import kd.epm.epbs.business.mservice.EPDMOrder;
import kd.epm.epbs.business.relation.IRdQueryService;
import kd.epm.epbs.business.relation.model.RdColumn;
import kd.epm.epbs.business.relation.model.RdQueryComInfo;
import kd.epm.epbs.business.relation.model.RdResultSet;
import kd.epm.epbs.business.relation.model.RdResultSetMetaData;
import kd.epm.epbs.business.relation.model.RdRow;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.enums.ErTableColEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RdQueryService
implements IRdQueryService {
    protected RdResultSetMetaData metaData;
    protected static final WatchLogger LOG = EpbsLogFactory.getWatchLogInstance(RdQueryService.class);

    public void setMetaData(RdResultSetMetaData metaData) {
        this.metaData = metaData;
    }

    public RdRow[] populate(RdQueryComInfo queryComInfo, List<Map<String, Object>> dblist, RdResultSetMetaData metaData) {
        if (CollectionUtils.isEmpty(dblist)) {
            return new RdRow[0];
        }
        if (null != metaData) {
            this.setMetaData(metaData);
        }
        RdRow[] rows = new RdRow[dblist.size()];
        boolean needSum = false;
        for (int i = 0; i < dblist.size(); ++i) {
            Map<String, Object> dbrow = dblist.get(i);
            RdRow row = this.getEdRow(queryComInfo, dbrow, null);
            if (!needSum) {
                row.setPkId(IDUtils.toLong((Object)dbrow.get(queryComInfo.convertNumber(ID_FIELD))));
            }
            rows[i] = row;
        }
        return rows;
    }

    @Override
    public RdResultSet queryData(RdQueryComInfo queryComInfo, int startIndex, int bizPageSize) {
        try {
            EPDMDataResponse<Map<String, Object>> result = new DataModelMsHelper().queryData(this.buildQueryRequest(queryComInfo, startIndex, bizPageSize));
            return this.buildQueryResult(result, queryComInfo);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            String errorMsg = ResManager.loadKDString((String)"\u5173\u7cfb\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"RdQueryService_1", (String)"epm-epbs-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(errorMsg, e.getMessage()));
        }
    }

    protected RdRow getEdRow(RdQueryComInfo queryComInfo, Map<String, Object> dbrow, BiPredicate<RdRow, String> defaultValue) {
        RdRow row = new RdRow(this.metaData);
        for (RdColumn edColumn : this.metaData.getColMetaDatas()) {
            row.addValue(dbrow.get(queryComInfo.convertNumber(edColumn.getMdName())));
        }
        return row;
    }

    protected EPDMDataRequest buildQueryRequest(RdQueryComInfo queryComInfo, int startIndex, int bizPageSize) {
        EPDMDataRequest request = new EPDMDataRequest();
        request.setApp(queryComInfo.getAppId());
        request.setModel(IDUtils.toString((Object)queryComInfo.getDataModelId()));
        if (bizPageSize > 0) {
            request.setSize(bizPageSize);
        }
        request.setFilters(this.buildQueryFilter(queryComInfo));
        request.setOrds(this.buildQueryOrder(queryComInfo));
        request.setCache(queryComInfo.isCache() ? "Y" : "N");
        return request;
    }

    protected RdResultSet buildQueryResult(EPDMDataResponse<Map<String, Object>> result, RdQueryComInfo queryComInfo) {
        RdResultSet re = new RdResultSet();
        re.setMetaData(queryComInfo);
        re.setRows(this.populate(queryComInfo, (List)((Object)result.getData()), re.getMetaData()));
        return re;
    }

    protected List<EPDMFilter> buildQueryFilter(RdQueryComInfo queryComInfo) {
        ArrayList filters = Lists.newArrayList();
        Map<String, Object[]> queryFilters = queryComInfo.getFilter();
        if (MapUtils.isNotEmpty(queryFilters)) {
            for (Map.Entry<String, Object[]> e : queryFilters.entrySet()) {
                if (ArrayUtils.isEmpty((Object[])e.getValue())) continue;
                EPDMFilter filter = new EPDMFilter(queryComInfo.convertNumber(e.getKey()), "in", e.getValue());
                FieldBean fieldBean = queryComInfo.getFieldBean(e.getKey());
                if (fieldBean == null) continue;
                BizModelErTypeEnum type = queryComInfo.getFieldType(fieldBean);
                if (queryComInfo.isNeedDefValueData() && (null == queryComInfo.getMustInputFields() || !queryComInfo.getMustInputFields().contains(e.getKey()))) {
                    if (null != type.getDefValue()) {
                        filter.or(new EPDMFilter(queryComInfo.convertNumber(e.getKey()), "=", type.getDefValue()));
                    } else {
                        filter.or(new EPDMFilter(queryComInfo.convertNumber(e.getKey()), "is null", null));
                    }
                }
                if (!fieldBean.isConnect() && fieldBean.getDimension() != null && StringUtils.isNotEmpty((CharSequence)queryComInfo.getTemplateaAreaInfo())) {
                    filter.or(new EPDMFilter(queryComInfo.convertNumber(e.getKey()), "like", queryComInfo.getTemplateaAreaInfo() + "%"));
                }
                filters.add(filter);
            }
        }
        if (null != queryComInfo.getCustomFilter()) {
            filters.add(queryComInfo.toEPDMFilter(queryComInfo.getCustomFilter()));
        }
        return filters;
    }

    protected List<EPDMOrder> buildQueryOrder(RdQueryComInfo queryComInfo) {
        return Lists.newArrayList((Object[])new EPDMOrder[]{new EPDMOrder(ErTableColEnum.ID.getCode(), "asc")});
    }
}

