/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.relation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.epbs.business.model.bizmodel.er.BizModelErInitHelper;
import kd.epm.epbs.business.mservice.DataModelMsHelper;
import kd.epm.epbs.business.mservice.EPDMCUDRequest;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.business.mservice.EPDMFilter;
import kd.epm.epbs.business.relation.IRdQueryService;
import kd.epm.epbs.business.relation.IRdSaveService;
import kd.epm.epbs.business.relation.model.RdResultBean;
import kd.epm.epbs.business.relation.model.RdResultSave;
import kd.epm.epbs.business.relation.model.RdRow;
import kd.epm.epbs.business.relation.model.RdSaveComInfo;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.enums.ErTableColEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.Tuple;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class RdSaveService
implements IRdSaveService {
    protected static final WatchLogger LOG = EpbsLogFactory.getWatchLogInstance(RdSaveService.class);

    @Override
    public RdResultSave saveDataMult(RdSaveComInfo saveComInfo) {
        try {
            return this.saveCore(saveComInfo);
        }
        catch (Exception e) {
            this.cleanCreateId(saveComInfo);
            LOG.error((Throwable)e);
            String errorMsg = ResManager.loadKDString((String)"\u5173\u7cfb\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"RdSaveService_1", (String)"epm-epbs-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(errorMsg, e.getMessage()));
        }
    }

    protected RdResultSave saveCore(RdSaveComInfo saveComInfo) {
        EPDMCUDRequest request;
        RdResultSave result = new RdResultSave();
        if (CollectionUtils.isEmpty(saveComInfo.getRdRows())) {
            return result;
        }
        Tuple<List<RdRow>, List<RdRow>, List<RdRow>> tuple = this.splitRows(saveComInfo.getRdRows());
        ArrayList requests = Lists.newArrayList();
        HashMap requestRows = Maps.newHashMap();
        HashMap requestActions = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tuple.p1))) {
            request = this.buildSaveRequest(saveComInfo, "C");
            request.setPkey(DBServiceHelper.genStringId());
            requests.add(request);
            requestRows.put(request.getPkey(), this.buildCreateRows((List)tuple.p1, saveComInfo));
            requestActions.put(request.getPkey(), request.getAction());
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tuple.p2))) {
            for (RdRow row : (List)tuple.p2) {
                request = this.buildSaveRequest(saveComInfo, "U");
                request.setPkey(DBServiceHelper.genStringId());
                request.setFilters(this.buildUpdateFilter(row));
                if (null != saveComInfo.getCustomFilter()) {
                    request.getFilters().add(saveComInfo.toEPDMFilter(saveComInfo.getCustomFilter()));
                }
                requests.add(request);
                requestRows.put(request.getPkey(), this.buildUpdateRow(row, saveComInfo));
                requestActions.put(request.getPkey(), request.getAction());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tuple.p3))) {
            request = this.buildSaveRequest(saveComInfo, "D");
            request.setPkey(DBServiceHelper.genStringId());
            request.setFilters(this.buildDeleteFilter((List)tuple.p3));
            requests.add(request);
            requestActions.put(request.getPkey(), request.getAction());
        }
        EPDMDataResponse<Map<String, Object>> resultEpdm = new DataModelMsHelper().actionMult(requests, requestRows);
        HashMap<String, RdResultBean> uniqueAction = new HashMap<String, RdResultBean>(3);
        if (resultEpdm.getData() instanceof List) {
            for (Map map : (List)((Object)resultEpdm.getData())) {
                if (MapUtils.isEmpty((Map)map)) continue;
                int count = (Integer)map.get("count");
                String pkey = (String)map.get("pkey");
                String action = (String)requestActions.get(pkey);
                RdResultBean bean = (RdResultBean)uniqueAction.get(action);
                if (null == bean) {
                    bean = new RdResultBean(action, resultEpdm.getCode(), null, count);
                    result.getBeans().add(bean);
                    uniqueAction.put(action, bean);
                    continue;
                }
                bean.inc(count);
            }
        }
        result.setCode(resultEpdm.getCode());
        result.setMessage(resultEpdm.getMessage());
        return result;
    }

    protected EPDMCUDRequest buildSaveRequest(RdSaveComInfo saveComInfo, String action) {
        EPDMCUDRequest request = new EPDMCUDRequest();
        request.setApp(saveComInfo.getAppId());
        request.setModel(IDUtils.toString((Object)saveComInfo.getDataModelId()));
        request.setAction(action);
        return request;
    }

    protected Tuple<List<RdRow>, List<RdRow>, List<RdRow>> splitRows(List<RdRow> rows) {
        ArrayList createRows = Lists.newArrayList();
        ArrayList updateRows = Lists.newArrayList();
        ArrayList deleteRows = Lists.newArrayList();
        for (RdRow row : rows) {
            if (this.isCreateRow(row)) {
                createRows.add(row);
                continue;
            }
            if (!row.isDelete()) {
                updateRows.add(row);
                continue;
            }
            deleteRows.add(row);
        }
        return Tuple.create((Object)createRows, (Object)updateRows, (Object)deleteRows);
    }

    protected boolean isCreateRow(RdRow row) {
        return IDUtils.isNull((long)row.getPkId());
    }

    protected <T> List<Map<String, Object>> buildCreateRows(List<RdRow> createRows, RdSaveComInfo saveComInfo) {
        if (CollectionUtils.isEmpty(createRows)) {
            return Lists.newArrayList();
        }
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(createRows.size());
        long[] ids = DB.genGlobalLongIds((int)createRows.size());
        int i = 0;
        for (RdRow row : createRows) {
            row.setPkId(ids[i++]);
            rows.add(this.rowToMap(row, saveComInfo, true));
        }
        this.buildDefaultFieldByCreate(rows);
        Arrays.stream(ids).forEach(e -> saveComInfo.getCreateIds().add(e));
        return rows;
    }

    protected Map<String, Object> rowToMap(RdRow row, RdSaveComInfo saveComInfo, boolean create) {
        HashMap<String, Object> map = new HashMap<String, Object>(row.getValues().size());
        HashSet existCols = Sets.newHashSet();
        for (int i = 0; i < row.getValues().size(); ++i) {
            String colName2 = row.getMetaData().getColMetaDatas().get(i).getMdName();
            map.put(saveComInfo.convertNumber(colName2), this.getValueByDefault(row.getValues().get(i), saveComInfo.getFieldType(colName2)));
            if (null == saveComInfo.getInsertColumns() || !saveComInfo.getInsertColumns().contains(colName2)) continue;
            existCols.add(colName2);
        }
        if (create && CollectionUtils.isNotEmpty((Collection)existCols)) {
            saveComInfo.getInsertColumns().stream().filter(e -> !existCols.contains(e)).forEach(colName -> map.put(saveComInfo.convertNumber((String)colName), this.getValueByDefault(null, saveComInfo.getFieldType((String)colName))));
        }
        if (create) {
            map.put(ErTableColEnum.ID.getCode(), row.getPkId());
        } else {
            map.remove(ErTableColEnum.ID.getCode());
        }
        return map;
    }

    protected Object getValueByDefault(Object value, BizModelErTypeEnum type) {
        if (null != value || null == type) {
            return value;
        }
        return type.getDefValue();
    }

    protected Map<String, Object> buildUpdateRow(RdRow updateRow, RdSaveComInfo saveComInfo) {
        Map<String, Object> row = this.rowToMap(updateRow, saveComInfo, false);
        this.buildDefaultFieldByUpdate(row);
        return row;
    }

    protected void buildDefaultFieldByCreate(List<Map<String, Object>> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        for (int i = 0; i < rows.size(); ++i) {
            rows.get(i).put(ErTableColEnum.CREATOR.getCode(), userId);
            rows.get(i).put(ErTableColEnum.CREATETIME.getCode(), now);
            rows.get(i).put(ErTableColEnum.MODIFIER.getCode(), userId);
            rows.get(i).put(ErTableColEnum.MODIFYTIME.getCode(), now);
        }
    }

    protected void buildDefaultFieldByUpdate(Map<String, Object> row) {
        if (MapUtils.isEmpty(row)) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        row.put(ErTableColEnum.MODIFIER.getCode(), userId);
        row.put(ErTableColEnum.MODIFYTIME.getCode(), now);
    }

    protected List<EPDMFilter> buildUpdateFilter(RdRow row) {
        Long id = row.getPkId();
        EPDMFilter filter = new EPDMFilter(BizModelErInitHelper.convertFieldName(IRdQueryService.ID_FIELD), "=", id);
        return Lists.newArrayList((Object[])new EPDMFilter[]{filter});
    }

    protected <T> List<EPDMFilter> buildDeleteFilter(List<RdRow> deleteRows) {
        if (CollectionUtils.isEmpty(deleteRows)) {
            return null;
        }
        Set ids = deleteRows.stream().map(e -> e.getPkId()).collect(Collectors.toSet());
        EPDMFilter filter = new EPDMFilter(BizModelErInitHelper.convertFieldName(IRdQueryService.ID_FIELD), "in", ids);
        return Lists.newArrayList((Object[])new EPDMFilter[]{filter});
    }

    protected void cleanCreateId(RdSaveComInfo saveComInfo) {
        List<RdRow> list = saveComInfo.getRdRows();
        list.forEach(row -> {
            Long id = row.getPkId();
            if (saveComInfo.getCreateIds().contains(id)) {
                row.setPkId(0L);
            }
        });
        saveComInfo.getCreateIds().clear();
    }
}

