/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.relation.model;

import java.util.List;
import java.util.Locale;
import kd.epm.epbs.business.model.bizmodel.er.BizModelErInitHelper;
import kd.epm.epbs.business.mservice.EPDMFilter;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBeanProvider;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class RdComInfo {
    private Long modelId;
    private String bizModelNumber;
    private Long bizModelId;
    private RelationModelBean relationModelBean;
    private EPDMFilter customFilter;

    public RdComInfo(Long modelId, String bizModelNumber) {
        this.modelId = modelId;
        this.bizModelNumber = bizModelNumber;
    }

    public RdComInfo(Long modelId, Long bizModelId) {
        this.modelId = modelId;
        this.bizModelId = bizModelId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public String getAppId() {
        return ModelCacheHelper.getModel((long)this.modelId).getSrcAppNum().toLowerCase(Locale.ENGLISH);
    }

    public RelationModelBean getRelationModelBean() {
        if (this.relationModelBean == null) {
            if (IDUtils.isNotNull((Long)this.bizModelId)) {
                this.relationModelBean = RelationModelBeanProvider.getRelationModelBeanById((long)this.getModelId(), (long)this.bizModelId);
            } else if (StringUtils.isNotEmpty((CharSequence)this.bizModelNumber)) {
                this.relationModelBean = RelationModelBeanProvider.getRelationModelBeanByNum((long)this.getModelId(), (String)this.bizModelNumber);
            }
        }
        return this.relationModelBean;
    }

    public Long getDataModelId() {
        RelationModelBean relaBean = this.getRelationModelBean();
        return null != relaBean ? relaBean.getBizDataModelId() : 0L;
    }

    public FieldBean getFieldBean(String fieldNumber) {
        RelationModelBean relaBean = this.getRelationModelBean();
        return null != relaBean ? (FieldBean)relaBean.getFieldBeanMap().get(fieldNumber) : null;
    }

    public BizModelErTypeEnum getFieldType(String fieldNumber) {
        return this.getFieldType(this.getFieldBean(fieldNumber));
    }

    public BizModelErTypeEnum getFieldType(FieldBean fieldBean) {
        if (null == fieldBean) {
            return null;
        }
        BizModelErTypeEnum typeEnum = RelationTypeEnum.MODEL == fieldBean.getTypeEnum() || RelationTypeEnum.DIMLIB == fieldBean.getTypeEnum() ? BizModelErTypeEnum.STRING : BizModelErTypeEnum.getBizModelErTypeEnum((String)fieldBean.getDataType());
        return typeEnum;
    }

    public List<String> getMustInputFields() {
        RelationModelBean relaBean = this.getRelationModelBean();
        return null != relaBean ? relaBean.getMustInputFields() : null;
    }

    public void setCustomFilter(EPDMFilter customFilter) {
        this.customFilter = customFilter;
    }

    public EPDMFilter getCustomFilter() {
        return this.customFilter;
    }

    public EPDMFilter toEPDMFilter(EPDMFilter epf) {
        String field = this.convertNumber(epf.getField());
        EPDMFilter filter = new EPDMFilter(field, epf.getQcp(), epf.getValue());
        if (null != epf.getAnd() && !epf.getAnd().isEmpty()) {
            for (EPDMFilter f : epf.getAnd()) {
                filter.and(this.toEPDMFilter(f));
            }
        }
        if (null != epf.getOr() && !epf.getOr().isEmpty()) {
            for (EPDMFilter f : epf.getOr()) {
                filter.or(this.toEPDMFilter(f));
            }
        }
        return filter;
    }

    public String convertNumber(String number) {
        return BizModelErInitHelper.convertFieldName(number);
    }
}

