/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.relation.model;

import java.math.BigDecimal;
import java.util.Date;
import java.util.function.Consumer;
import kd.epm.epbs.business.relation.exception.RdQueryException;
import kd.epm.epbs.business.relation.model.IRdResultSet;
import kd.epm.epbs.business.relation.model.RdQueryComInfo;
import kd.epm.epbs.business.relation.model.RdResultSetMetaData;
import kd.epm.epbs.business.relation.model.RdRow;

public class RdResultSet
implements IRdResultSet {
    private int cursorPos = 0;
    private int numRows = 0;
    private RdRow[] rows;
    private RdResultSetMetaData metaData;

    @Override
    public boolean next() {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new RdQueryException("Invalid Cursor position");
        }
        return this.internalNext();
    }

    private boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        return flag;
    }

    @Override
    public void beforeFirst() {
        this.cursorPos = 0;
    }

    @Override
    public int getFetchSize() {
        return this.rows == null ? 0 : this.rows.length;
    }

    protected void checkCursor() {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new RdQueryException("Invalid cursor position");
        }
    }

    private boolean isAfterLast() {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    private boolean isBeforeFirst() {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public String getString(String colName) {
        this.checkCursor();
        return this.getRow().getString(colName);
    }

    @Override
    public Date getDate(String colName) {
        this.checkCursor();
        return this.getRow().getDate(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        this.checkCursor();
        return this.getRow().getBigDecimal(colName);
    }

    @Override
    public Object getOriginalValue(String colName) {
        this.checkCursor();
        return this.getRow().getOriginalValue(colName);
    }

    @Override
    public RdRow getRow() {
        return this.rows[this.cursorPos - 1];
    }

    public RdRow[] getRows() {
        return this.rows;
    }

    public void setRows(RdRow[] rows) {
        this.rows = rows;
        if (null != rows) {
            this.numRows = rows.length;
        }
    }

    @Override
    public void close() {
        this.rows = null;
    }

    @Override
    public RdResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == null || this.rows.length == 0;
    }

    @Override
    public void populate(RdQueryComInfo queryComInfo) {
        this.setMetaData(queryComInfo);
        this.numRows = this.rows.length;
    }

    public void iteratorRows(Consumer<RdRow> consumer) {
        this.beforeFirst();
        while (this.next()) {
            consumer.accept(this.getRow());
        }
        this.beforeFirst();
    }

    public void setMetaData(RdQueryComInfo queryComInfo) {
        this.metaData = new RdResultSetMetaData();
        RdRow.setMetaData(this.metaData, queryComInfo.getSelects());
        this.metaData.setQueryComInfo(queryComInfo);
    }
}

