/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.relation.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.epbs.business.relation.IRdQueryService;
import kd.epm.epbs.business.relation.model.RdColumn;
import kd.epm.epbs.business.relation.model.RdQueryComInfo;
import kd.epm.epbs.business.relation.model.RdResultSetMetaData;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.util.DateTimeUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.TypeConversionUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RdRow {
    protected long pkId;
    protected String spkId;
    protected List<Object> values;
    protected RdResultSetMetaData metaData;
    protected int index;

    public RdRow(RdResultSetMetaData metaData) {
        this.metaData = metaData;
        int count = null != metaData ? metaData.getColumCount() : 0;
        this.values = new ArrayList<Object>(count);
    }

    public boolean addValue(Object val) {
        return this.values.add(val);
    }

    public String getString(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToString((Object)obj);
    }

    public Date getDate(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToDate((Object)obj);
    }

    public BigDecimal getBigDecimal(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToBigDecimal((Object)obj);
    }

    public Object getOriginalValue(String colName) {
        return this.getValue(this.metaData.getColIndex(colName));
    }

    public Object getValueByType(String colName) {
        BizModelErTypeEnum type;
        Object val = null;
        RdQueryComInfo queryComInfo = this.metaData.getQueryComInfo();
        BizModelErTypeEnum bizModelErTypeEnum = type = null != queryComInfo ? queryComInfo.getFieldType(colName) : null;
        if (null == type) {
            return this.getOriginalValue(colName);
        }
        switch (type) {
            case NUMBER: {
                val = this.getBigDecimal(colName);
                break;
            }
            case STRING: {
                val = this.getString(colName);
                break;
            }
            case DATETIME: {
                val = this.getDate(colName);
                if (!queryComInfo.isTransDate() || null == val) break;
                val = DateTimeUtils.convertToOADate((Date)((Date)val));
                break;
            }
        }
        return val;
    }

    public Object getValue(int index) {
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    public long getPkId() {
        return this.pkId;
    }

    public void setPkId(long pkId) {
        this.pkId = pkId;
    }

    public String getSpkId() {
        return this.spkId;
    }

    public void setSpkId(String spkId) {
        this.spkId = spkId;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public RdResultSetMetaData getMetaData() {
        return this.metaData;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static RdResultSetMetaData buildMetaData(List<String> columns) {
        RdResultSetMetaData metaData = new RdResultSetMetaData();
        RdRow.setMetaData(metaData, columns);
        return metaData;
    }

    public static void setMetaData(RdResultSetMetaData metaData, List<String> columns) {
        if (null != metaData && null != columns) {
            columns.forEach(colName -> metaData.addColumnMeta((String)colName));
        }
    }

    public static RdRow buildRow(Long id, int index) {
        RdRow row = new RdRow(null);
        row.setPkId(id);
        row.setIndex(index);
        return row;
    }

    public static RdRow buildRow(Long id) {
        return RdRow.buildRow(id, 0);
    }

    public static RdRow buildRow(Map<String, Object> map, int index) {
        Long id = IDUtils.toLong((Object)((Long)map.remove(IRdQueryService.ID_FIELD)));
        RdRow row = new RdRow(RdRow.buildMetaData(map.keySet().stream().collect(Collectors.toList())));
        for (RdColumn edColumn : row.getMetaData().getColMetaDatas()) {
            row.addValue(map.get(edColumn.getMdName()));
        }
        row.setPkId(id);
        row.setIndex(index);
        return row;
    }

    public static RdRow buildRow(Map<String, Object> map) {
        return RdRow.buildRow(map, 0);
    }

    public boolean isDelete() {
        return CollectionUtils.isEmpty(this.values);
    }
}

