/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.api;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.script.ScriptConfig;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.mate.KContextEnv;
import kd.bos.script.util.SimpleScriptInfo;
import kd.epm.epbs.business.rules.api.IOutline;
import kd.epm.epbs.business.rules.api.RulesEngine;
import kd.epm.epbs.business.rules.core.ComputingContext;
import kd.epm.epbs.business.rules.core.RuleVarProvider;
import kd.epm.epbs.business.rules.exception.RuleException;
import kd.epm.epbs.business.rules.support.JavaScriptLoader;
import kd.epm.epbs.business.rules.support.PlatFormVersionUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;

public abstract class AbstractRulesEngine
implements RulesEngine {
    private static final Log LOG = LogFactory.getLog(AbstractRulesEngine.class);
    private static final String MIN_PLATFORM_VERSION = "5.0.014.0";
    private final OlapConnection olapConnection;
    protected final IOutline outline;

    public AbstractRulesEngine(OlapConnection olapConnection, IOutline outline) {
        this.olapConnection = olapConnection;
        this.outline = outline;
    }

    @Override
    public ComputingContext getRulesEngineContext() {
        return this.outline.getComputingContext();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T execute(String script) {
        Object object;
        ScriptExecutor executor = ScriptExecutor.create();
        RuleVarProvider varProvider = new RuleVarProvider(this.olapConnection, this.outline);
        this.outline.setScriptExecutor(executor);
        ArrayList<Object> scriptInfos = new ArrayList<Object>();
        scriptInfos.add(JavaScriptLoader.getInstance().getBizRuleScript());
        if (PlatFormVersionUtil.getVersionInfos().compareToIgnoreCase(MIN_PLATFORM_VERSION) >= 0) {
            scriptInfos.add(new SimpleScriptInfo("biz_scale.js", "beginBigDecimalScale(15,'half_up');"));
        }
        scriptInfos.add(new SimpleScriptInfo(String.valueOf(this.getRulesEngineContext().getScriptName()), script));
        executor.init(ctx -> {
            ctx.setVarProvider(varProvider);
            ((KContext)ctx).setLimit(ScriptConfig.getTimeOut(), ScriptConfig.getDebugTimeOut(), -1L, 100000);
        });
        try {
            if (KContext.get() != null) {
                throw new RuleException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c", (String)"AbstractRulesEngine_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            executor.begin();
            ((Context)executor.getContext()).getWrapFactory().setJavaPrimitiveWrap(false);
            object = executor.exec(scriptInfos.toArray(new ScriptInfo[0]));
        }
        catch (RhinoException re) {
            try {
                LOG.error(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u811a\u672c\u6267\u884c\u5f02\u5e38\u3002", (String)"AbstractRulesEngine_2", (String)"epm-epbs-business", (Object[])new Object[0]), (Throwable)re);
                throw re;
                catch (ClassCastException e1) {
                    LOG.error((Throwable)e1);
                    throw new RuntimeException(ResManager.loadKDString((String)"\u811a\u672c\u6216\u8005\u4f20\u53c2\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u76f8\u5173\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"AbstractRulesEngine_3", (String)"epm-epbs-business", (Object[])new Object[0]), e1);
                }
                catch (ArrayIndexOutOfBoundsException e5) {
                    LOG.error((Throwable)e5);
                    if (e5.getStackTrace() != null && e5.getStackTrace().length > 1 && e5.getStackTrace()[1].getMethodName().equals("matchMethodInfo")) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u6216\u65b9\u6cd5\u7f3a\u5c11\u53c2\u6570", (String)"AbstractRulesEngine_4", (String)"epm-epbs-business", (Object[])new Object[0]));
                    }
                    throw new RuntimeException(e5);
                }
                catch (Exception e4) {
                    LOG.error((Throwable)e4);
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"OLAP \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"AbstractRulesEngine_5", (String)"epm-epbs-business", (Object[])new Object[0]), e4.getMessage()), e4);
                }
            }
            catch (Throwable throwable) {
                executor.end();
                KContextEnv.exit();
                String script2 = this.getRulesEngineContext().getRule().getContent();
                LOG.info(String.format("\u6267\u884c\u89c4\u5219\u903b\u8f91[%s]\u5b8c\u6210", script2));
                throw throwable;
            }
        }
        executor.end();
        KContextEnv.exit();
        String script2 = this.getRulesEngineContext().getRule().getContent();
        LOG.info(String.format("\u6267\u884c\u89c4\u5219\u903b\u8f91[%s]\u5b8c\u6210", script2));
        return (T)object;
    }
}

