/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.rules.api.Rule;
import kd.epm.epbs.business.rules.api.RuleExecutor;
import kd.epm.epbs.business.rules.api.Rules;
import kd.epm.epbs.business.rules.core.ComputingContext;
import kd.epm.epbs.business.rules.core.DefaultRulesEngine;
import kd.epm.epbs.business.rules.core.Outline;
import kd.epm.epbs.business.rules.trace.TraceLogCache;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptStackElement;

public class DefaultRuleExecutor
implements RuleExecutor {
    private static final Log LOG = LogFactory.getLog(DefaultRuleExecutor.class);

    @Override
    public void execute(Rules rules, Map<String, Object> args) {
        Long modelId = rules.getModelId();
        for (Rule rule : rules) {
            OlapConnection olapConnection = rule.getOlapConnection(modelId);
            Outline outline = new Outline(olapConnection);
            ComputingContext ctx = ComputingContext.create(olapConnection, outline, rules.getModelId(), rules.getDomainId(), rule);
            ctx.setScriptName(rules.getNumber());
            outline.setComputingContext(ctx);
            DefaultRulesEngine defaultRulesEngine = new DefaultRulesEngine(olapConnection, outline);
            try {
                Map ruleSegment = (Map)TraceLogCache.get(rules.getId(), () -> new LinkedHashMap());
                if (olapConnection != null) {
                    olapConnection.Open();
                }
                defaultRulesEngine.execute(rule.getContent());
                ruleSegment.put(rule.getBizModelId(), new ArrayList());
            }
            catch (Exception e) {
                LOG.error("olap operator: excute script(" + rule.getContent() + "), result: failure, spendtime ", (Throwable)e);
                Map ruleSegment = (Map)TraceLogCache.get(rules.getId(), () -> new LinkedHashMap());
                ArrayList<String> messages = new ArrayList<String>();
                ruleSegment.put(rule.getBizModelId(), messages);
                messages.add(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u903b\u8f91[%1$s],%2$s", (String)"DefaultRuleExecutor_1", (String)"epm-epbs-business", (Object[])new Object[0]), rule.getName(), DefaultRuleExecutor.getErrMsg(e, rules.isDebug())));
                throw e;
            }
            finally {
                if (olapConnection == null) continue;
                olapConnection.close();
            }
        }
    }

    private static String getErrMsg(Throwable e) {
        Throwable bottomEx = DefaultRuleExecutor.getBottomEx(e);
        return StringUtils.isEmpty((String)bottomEx.getMessage()) ? Objects.toString(bottomEx) : bottomEx.getMessage();
    }

    private static String getErrMsg(Throwable e, boolean isDebug) {
        Throwable ex;
        StringBuilder sb = new StringBuilder();
        if (ex == null) {
            return sb.toString();
        }
        Throwable bottomEx = DefaultRuleExecutor.getBottomEx(e);
        for (ex = e; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof RhinoException)) continue;
            RhinoException exception = (RhinoException)ex;
            ScriptStackElement scriptStackElement = null;
            String bottomMessage = DefaultRuleExecutor.getBottomMessage(bottomEx);
            if (StringUtils.isNotEmpty((String)bottomMessage) && bottomMessage.contains("#DragonEngineException1000")) {
                bottomMessage = bottomMessage + ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801\u4e2d\u5b58\u5728\u8fd0\u7b97\u7b26\u53f7\u7684\uff0c\u8bf7\u4f7f\u7528\u5e26v\u51fd\u6570\u7684\u5199\u6cd5\u3002", (String)"DefaultRuleExecutor_2", (String)"epm-epbs-business", (Object[])new Object[0]);
            }
            if (exception.getScriptStack() != null && exception.getScriptStack().length > 0) {
                if (StringUtils.isNotEmpty((String)exception.getScriptStack()[0].functionName)) {
                    sb.append(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u6267\u884c\u5931\u8d25", (String)"DefaultRuleExecutor_3", (String)"epm-epbs-business", (Object[])new Object[0]), exception.getScriptStack()[0].functionName)).append(",");
                }
                scriptStackElement = exception.getScriptStack()[exception.getScriptStack().length - 1];
                sb.append(String.format("at %s:%s", scriptStackElement.fileName, scriptStackElement.lineNumber)).append(System.lineSeparator()).append(bottomMessage);
            } else {
                sb.append(String.format("at %s:%s", ((RhinoException)ex).sourceName(), ((RhinoException)ex).lineNumber())).append(System.lineSeparator()).append(bottomMessage);
            }
            if (!isDebug) {
                sb.append(System.lineSeparator()).append(ThrowableHelper.toString((Throwable)e));
            }
            return sb.toString();
        }
        if (isDebug) {
            return sb.append(DefaultRuleExecutor.getBottomMessage(bottomEx)).toString();
        }
        return sb.append(e.getMessage()).append(System.lineSeparator()).append(ThrowableHelper.toString((Throwable)e)).toString();
    }

    private static String getBottomMessage(Throwable bottomEx) {
        return StringUtils.isEmpty((String)bottomEx.getMessage()) ? ThrowableHelper.toString((Throwable)bottomEx) : bottomEx.getMessage();
    }

    private static Throwable getBottomEx(Throwable e) {
        for (Throwable bottomEx = e.getCause(); bottomEx != null; bottomEx = bottomEx.getCause()) {
            if (bottomEx.getCause() != null) continue;
            return bottomEx;
        }
        return e;
    }
}

