/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.rules.api.Rule;
import kd.epm.epbs.business.rules.core.RuleSegment;
import kd.epm.epbs.common.enums.RuleStatusEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Rules
implements Iterable<Rule>,
Comparable<Rules> {
    public static final Log LOG = LogFactory.getLog(Rules.class);
    private final Set<Rule> rules = new TreeSet<Rule>();
    private final long id;
    private Long modelId;
    private Long domainId;
    private String number;
    private int seq;
    private boolean debug;

    public Rules(long modelId, long id) {
        this(modelId, id, false);
    }

    public Rules(long modelId, long id, boolean isDebug) {
        this.modelId = modelId;
        this.id = id;
        this.debug = isDebug;
        DynamicObject rule = null;
        try {
            rule = BusinessDataServiceHelper.loadSingle((String)Rules.getMetaDataEntity(modelId), (String)"number,model,domain,sequence,entryentity.segment_name,entryentity.segment_jsexpr,entryentity.segment_commitjsexpr,entryentity.segment_ownermodel_id,entryentity.seq,entryentity.segment_isenable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u89c4\u5219\u5f02\u5e38\u3002", (Throwable)e);
        }
        if (rule != null) {
            this.domainId = rule.getLong("domain_id");
            this.seq = rule.getInt("sequence");
            this.number = rule.getString("number");
            DynamicObjectCollection ruleSegments = rule.getDynamicObjectCollection("entryentity");
            ruleSegments.forEach(ruleSegment -> {
                if (!RuleStatusEnum.RuleLogicStatusEnum.DisEnabled.getValue().equals(ruleSegment.getString("segment_isenable"))) {
                    String jsexpr = isDebug ? ruleSegment.getString("segment_jsexpr") : ruleSegment.getString("segment_commitjsexpr");
                    this.register(new RuleSegment(ruleSegment.getString("segment_name"), jsexpr, ruleSegment.getLong("segment_ownermodel_id"), ruleSegment.getInt("seq")));
                }
            });
        }
    }

    private static String getMetaDataEntity(long modelId) {
        return EpbsModelCacheHelper.get((long)modelId).getMetaDataEntity("epbs_rule_entity");
    }

    public Rules(long id, Long modelId, Long domainId, String number, int seq) {
        this.id = id;
        this.modelId = modelId;
        this.domainId = domainId;
        this.number = number;
        this.seq = seq;
    }

    public void register(Rule rule) {
        this.rules.add(rule);
    }

    public void register(Collection<Rule> rules) {
        this.rules.addAll(rules);
    }

    @Override
    @NotNull
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    public void clear() {
        this.rules.clear();
    }

    public String getNumber() {
        if (StringUtils.isEmpty((CharSequence)this.number)) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)Rules.getMetaDataEntity(this.modelId), (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.id)});
            Objects.requireNonNull(dynamicObject, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219[%d]\u5df2\u88ab\u5220\u9664\u3002", (String)"Rules_1", (String)"epm-epbs-business", (Object[])new Object[0]), this.id));
            this.number = dynamicObject.getString("number");
        }
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getDomainId() {
        return this.domainId;
    }

    public void setDomainId(Long domainId) {
        this.domainId = domainId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public int getSeq() {
        return this.seq;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rules rules = (Rules)o;
        return this.id == rules.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(@NotNull Rules rules) {
        return Integer.compare(this.getSeq(), rules.getSeq());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

