/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.core;

import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.script.VarProvider;
import kd.epm.epbs.business.rules.api.IOutline;
import kd.epm.epbs.business.rules.api.Rule;
import kd.epm.epbs.business.rules.core.BizRuleExecParam;
import kd.epm.epbs.business.rules.exception.RuleException;
import kd.epm.epbs.business.rules.function.ScopeInfo;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.model.bean.BizModelBean;
import org.apache.commons.collections4.CollectionUtils;

public class ComputingContext {
    public static final Log LOG = LogFactory.getLog(ComputingContext.class);
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private VarProvider varProvider;
    private final Long modelId;
    private final Long domainId;
    private final Rule rule;
    private final boolean isRuntimeBizModelMulti;
    private final BizModelBean bizModelBean;
    private String scriptName;
    private boolean isIgnoreVerify = false;
    private final Stack<ScopeInfo> scopeStack = new Stack();
    private final BizRuleExecParam.BizRuleExecCommonParam commParam;

    public ComputingContext(OlapConnection olapConnection, IOutline outline, Long modelId, Long domainId, Rule rule, BizRuleExecParam.BizRuleExecCommonParam commParam) {
        this.olapConnection = olapConnection;
        this.outline = outline;
        this.modelId = modelId;
        this.domainId = domainId;
        this.rule = rule;
        this.commParam = commParam;
        this.bizModelBean = rule.getBizModel(modelId);
        this.isRuntimeBizModelMulti = this.isMultiOrRelation();
    }

    public static ComputingContext create(OlapConnection olapConnection, IOutline outline, Long modelId, Long domainId, Rule rule) {
        return new ComputingContext(olapConnection, outline, modelId, domainId, rule, null);
    }

    public Long getModelId() {
        return this.modelId;
    }

    public Long getDomainId() {
        return this.domainId;
    }

    public VarProvider getVarProvider() {
        return this.varProvider;
    }

    public void setVarProvider(VarProvider varProvider) {
        this.varProvider = varProvider;
    }

    public Stack<ScopeInfo> getScopeStack() {
        return this.scopeStack;
    }

    public void ignoreVerify(boolean v) {
        this.isIgnoreVerify = v;
    }

    public boolean isIgnoreVerify() {
        return this.isIgnoreVerify;
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public ScopeInfo getRuntimeScope() {
        if (CollectionUtils.isEmpty(this.scopeStack)) {
            return new ScopeInfo();
        }
        return this.scopeStack.peek();
    }

    public Rule getRule() {
        return this.rule;
    }

    public BizModelBean getBizModelBean() {
        return this.bizModelBean;
    }

    public boolean isRuntimeBizModelMulti() {
        return this.isRuntimeBizModelMulti;
    }

    private boolean isMultiOrRelation() {
        if (this.bizModelBean.getBizModelType() == BizModelTypeEnum.MUITL) {
            return true;
        }
        if (this.bizModelBean.getBizModelType() == BizModelTypeEnum.RELATION) {
            return false;
        }
        throw new RuleException(String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u548c\u5173\u7cfb\u6a21\u578b\uff0c\u5f53\u524d\u6a21\u578b[%s]", (String)"ComputingContext_1", (String)"epm-epbs-business", (Object[])new Object[0]), this.bizModelBean.getNumber()));
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public Set<String> getExtendNumbers() {
        return null;
    }
}

