/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.core;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.BatchCommandInfo;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.Level;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.script.annotations.KSMethod;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.epm.epbs.business.model.bizmodel.er.BizModelErInitHelper;
import kd.epm.epbs.business.mservice.EPDMFilter;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.business.relation.RdQueryService;
import kd.epm.epbs.business.relation.RdRuleSaveService;
import kd.epm.epbs.business.relation.model.RdQueryComInfo;
import kd.epm.epbs.business.relation.model.RdResultSave;
import kd.epm.epbs.business.relation.model.RdResultSet;
import kd.epm.epbs.business.relation.model.RdRow;
import kd.epm.epbs.business.relation.model.RdSaveComInfo;
import kd.epm.epbs.business.rules.api.IOutline;
import kd.epm.epbs.business.rules.api.RuleFunction;
import kd.epm.epbs.business.rules.core.ComputingContext;
import kd.epm.epbs.business.rules.enums.FieldConditionEnum;
import kd.epm.epbs.business.rules.enums.ScopeMemberTypeEnum;
import kd.epm.epbs.business.rules.exception.RuleException;
import kd.epm.epbs.business.rules.function.DimMember;
import kd.epm.epbs.business.rules.function.RelationDimensionFilterItem;
import kd.epm.epbs.business.rules.function.RelationScopeInfo;
import kd.epm.epbs.business.rules.function.ScopeInfo;
import kd.epm.epbs.business.rules.support.RuleUtil;
import kd.epm.epbs.business.rules.support.log.ScriptDebugLogInfoUtil;
import kd.epm.epbs.business.rules.support.vo.MemberParam;
import kd.epm.epbs.business.rules.trace.OlapComTraceUtil;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.enums.model.FacTabFieldDefEnum;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.RelationFieldBean;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import org.apache.commons.collections.comparators.BooleanComparator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class RuleFunctionManager
implements RuleFunction {
    private static final Log LOG = LogFactory.getLog(RuleFunctionManager.class);
    private ComputingContext computingContext;
    public static final String tracer_type = "olap";
    public static final String tracer_type_compute = "olap-compute";
    public static final String audit_name = "olap_cost";
    public static final String tracer_dbroutekey = "route";
    public static final String tracer_parameter = "parameter";
    public static final String tracer_sql = "sql";
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private final BatchCommandInfo batchCommands = new BatchCommandInfo();

    public RuleFunctionManager(OlapConnection olapConnection, IOutline outline) {
        this.olapConnection = olapConnection;
        this.outline = outline;
        this.computingContext = outline.getComputingContext();
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public IOutline getOutline() {
        return this.outline;
    }

    public void setRulesEngineContext(ComputingContext computingContext) {
        this.computingContext = computingContext;
    }

    @Override
    public ComputingContext getRulesEngineContext() {
        return this.computingContext;
    }

    @Override
    @KSMethod
    public String log(Object args) {
        if (args == null) {
            return "";
        }
        ScriptDebugLogInfoUtil.log(String.valueOf(this.getRulesEngineContext().getRule().getBizModelId()), args);
        return args.toString();
    }

    @Override
    @KSMethod
    public Object dget(String bizModelNumber, String expression) {
        BizModelBean bizModelBean;
        if (StringUtils.isEmpty((CharSequence)expression)) {
            throw new RuleException(ResManager.loadKDString((String)"DGE\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u4e24\u4e2a\u53c2\u6570\uff0c\u5982\u679c\u4f7f\u7528\u9ed8\u8ba4\u6a21\u578b\uff0c\u8bf7\u6307\u5b9a\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a\"\"", (String)"RuleFunctionManager_22", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        String scopeExpr = expression;
        if (expression.startsWith("cube(")) {
            scopeExpr = StringUtils.substringBetween((String)expression.split(",", 2)[1], (String)"'");
        }
        ScopeInfo scopeInfo = ScopeInfo.parserScopeExpr(this.getRulesEngineContext().getModelId(), scopeExpr);
        Collection<DimensionFilterItem> targetFilters = scopeInfo.getFilters();
        Map<String, List> map = targetFilters.stream().collect(Collectors.toMap(DimensionFilterItem::getName, DimensionFilterItem::getValues));
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        ScopeInfo contextScope = this.getRulesEngineContext().getRuntimeScope();
        Map<String, List> map1 = contextScope.getFilters().stream().collect(Collectors.toMap(DimensionFilterItem::getName, DimensionFilterItem::getValues));
        map.forEach((k, v) -> {
            selectCommandInfo.addDims(new String[]{k});
            selectCommandInfo.addFilter(k, v.toArray(new String[0]));
        });
        map1.forEach((k1, v1) -> {
            if (!map.containsKey(k1)) {
                selectCommandInfo.addDims(new String[]{k1});
                selectCommandInfo.addFilter(k1, v1.toArray(new String[0]));
            }
        });
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        selectCommandInfo.setTop(2);
        if (StringUtils.isEmpty((CharSequence)bizModelNumber)) {
            bizModelBean = this.getRulesEngineContext().getBizModelBean();
        } else {
            bizModelBean = this.getBizModelBeanByBizModelNumber(bizModelNumber);
            if (bizModelBean == null) {
                throw new RuleException(String.format(ResManager.loadKDString((String)"\u6a21\u578b[%s]\u4e0d\u5b58\u5728", (String)"RuleFunctionManager_18", (String)"epm-epbs-business", (Object[])new Object[0]), bizModelNumber));
            }
        }
        Object measure = null;
        if (bizModelBean.getBizModelType() == BizModelTypeEnum.MUITL) {
            String cube = bizModelBean.getCube();
            List<Map<String, Object>> result = OlapServiceHelper.queryData(selectCommandInfo, OlapServiceHelper.getOlapConnection(cube, this.getRulesEngineContext().getModelId()));
            if (result.size() > 1) {
                throw new RuleException(String.format(ResManager.loadKDString((String)"\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u8c03\u6574\u67e5\u8be2\u8303\u56f4%s\u3002", (String)"RuleFunctionManager_1", (String)"epm-epbs-business", (Object[])new Object[0]), scopeInfo));
            }
            if (result.isEmpty()) {
                return BigDecimal.ZERO;
            }
            measure = result.get(0).get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            return RuleFunctionManager.getValue(measure);
        }
        if (bizModelBean.getBizModelType() == BizModelTypeEnum.RELATION) {
            try (RdResultSet rdResultSet = this.queryRelationData(bizModelNumber, ((RelationScopeInfo)scopeInfo).getRelationFilters());){
                RdRow[] rows = rdResultSet.getRows();
                if (rows.length > 1) {
                    throw new RuleException(String.format(ResManager.loadKDString((String)"\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u8c03\u6574\u67e5\u8be2\u8303\u56f4%s\u3002", (String)"RuleFunctionManager_1", (String)"epm-epbs-business", (Object[])new Object[0]), scopeInfo));
                }
                if (rows.length == 0) {
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    return bigDecimal;
                }
                measure = rows[0];
                Object object = RuleFunctionManager.getValue(measure);
                return object;
            }
        }
        throw new RuleException(String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u548c\u5173\u7cfb\u6a21\u578b\uff0c\u5f53\u524d\u6a21\u578b[%s]", (String)"RuleFunctionManager_2", (String)"epm-epbs-business", (Object[])new Object[0]), bizModelNumber));
    }

    @NotNull
    private static Object getValue(Object measure) {
        if (measure == null) {
            return BigDecimal.ZERO;
        }
        if (measure instanceof BigDecimal) {
            return measure;
        }
        return measure instanceof Number ? new BigDecimal(measure.toString()) : measure;
    }

    private RdResultSet queryRelationData(String number, Collection<RelationDimensionFilterItem> relationFilters) {
        RdQueryComInfo queryComInfo = new RdQueryComInfo(this.getRulesEngineContext().getModelId(), number);
        relationFilters.forEach(filter -> queryComInfo.addFilter(filter.getName(), filter.getValues()));
        return new RdQueryService().queryData(queryComInfo, 0, 0);
    }

    @Override
    public ScopeInfo include(String dimNumber, DimMember[] dimMembers) {
        HashSet allMembers = new HashSet();
        boolean isMulti = this.getRulesEngineContext().isRuntimeBizModelMulti();
        ScopeInfo scopeInfo = isMulti ? new ScopeInfo() : new RelationScopeInfo();
        Arrays.stream(dimMembers).forEach(dimMember -> {
            MemberParam memberParam = new MemberParam(dimNumber, dimMember.getViewNumber(), dimMember.getMemberNumber(), dimMember.getRange(), this.getRulesEngineContext().getModelId(), dimMember.getType());
            if (isMulti) {
                allMembers.addAll(RuleUtil.findAllMembers(memberParam));
            } else {
                Map relationFieldMap = this.getRulesEngineContext().getBizModelBean().getRelationFieldMap();
                long dimensionId = 0L;
                for (Map.Entry entry : relationFieldMap.entrySet()) {
                    RelationFieldBean v = (RelationFieldBean)entry.getValue();
                    if (!dimNumber.equals(v.getNumber())) continue;
                    dimensionId = v.getDimensionId();
                    break;
                }
                if (dimensionId == 0L || ScopeMemberTypeEnum.FIELD.getType().equals(dimMember.getType())) {
                    FieldConditionEnum fieldConditionEnum = FieldConditionEnum.getEnumFromCode(memberParam.getMemberNumber());
                    RelationDimensionFilterItem relationDimensionFilterItem = new RelationDimensionFilterItem(memberParam.getDimNumber(), fieldConditionEnum.getCondition(), FieldConditionEnum.getFormatCondition(fieldConditionEnum, memberParam.getRangeNumber()));
                    ((RelationScopeInfo)scopeInfo).getRelationFilters().add(relationDimensionFilterItem);
                } else {
                    allMembers.addAll(RuleUtil.findAllMembers(memberParam, dimensionId));
                }
            }
            scopeInfo.getFilters().add(new DimensionFilterItem(memberParam.getDimNumber(), (List)Lists.newArrayList((Iterable)allMembers)));
        });
        return scopeInfo;
    }

    @Override
    public ScopeInfo exclude(String dimNumber, DimMember[] dimMembers) {
        HashSet allMembers = new HashSet();
        Arrays.stream(dimMembers).forEach(dimMember -> {
            MemberParam memberParam = new MemberParam(dimNumber, dimMember.getViewNumber(), dimMember.getMemberNumber(), dimMember.getRange(), this.getRulesEngineContext().getModelId(), dimMember.getType());
            allMembers.addAll(RuleUtil.findAllMembers(memberParam));
        });
        return new ScopeInfo(new DimensionFilterItem(dimNumber, (List)Lists.newArrayList(allMembers)), false);
    }

    @Override
    @KSMethod
    public DimMember rangeMember(String viewNumber, String memberNumber, String range, String type) {
        return new DimMember(viewNumber, memberNumber, range, type);
    }

    @Override
    @KSMethod
    public void runs(String[] expressions) {
        ComputingContext rulesEngineContext = this.getRulesEngineContext();
        BizModelBean bizModelBean = rulesEngineContext.getBizModelBean();
        if (rulesEngineContext.isRuntimeBizModelMulti()) {
            Objects.requireNonNull(expressions);
            BatchCommandInfo commands = new BatchCommandInfo();
            for (String expression : expressions) {
                ComputingCommandInfo command = new ComputingCommandInfo();
                if (CollectionUtils.isNotEmpty(rulesEngineContext.getScopeStack())) {
                    command.setFilter((List)rulesEngineContext.getScopeStack().peek().getFilters());
                }
                command.setMainMeaName("FMONEY");
                FelLambdaExpressionItem item = new FelLambdaExpressionItem();
                String[] split = expression.split("=", 2);
                item.setExpressLeft(split[0].trim());
                item.setExpression(split[1].trim());
                command.getExpressionItems().add(item);
                Level level = new Level();
                level.addCommand((CommandInfo)command);
                commands.addLevel(level);
            }
            this.executeOlapCommand((CommandInfo)commands);
        } else {
            String message = this.checkExpression(expressions, bizModelBean.getRelationFieldMap());
            ArrayList relationFields = new ArrayList();
            HashMap num2DataType = new HashMap();
            bizModelBean.getRelationFieldMap().forEach((k, v) -> {
                relationFields.add(v.getNumber());
                num2DataType.put(v.getNumber(), v.getDataTye());
            });
            relationFields.sort((s1, s2) -> s2.compareToIgnoreCase((String)s1));
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                throw new RuleException(message);
            }
            RdRuleSaveService saveService = new RdRuleSaveService();
            RdSaveComInfo rdSaveComInfo = new RdSaveComInfo(rulesEngineContext.getModelId(), bizModelBean.getNumber());
            for (String expression : expressions) {
                this.addCustomFilter(rdSaveComInfo);
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                String[] split = expression.split("=", 2);
                String value = split[1];
                String dataType = (String)num2DataType.get(split[0]);
                BizModelErTypeEnum bizModelErTypeEnum = BizModelErTypeEnum.getBizModelErTypeEnum((String)dataType);
                for (String relationField : relationFields) {
                    value = value.replace(relationField, BizModelErInitHelper.convertFieldName(relationField));
                }
                if (bizModelErTypeEnum == BizModelErTypeEnum.NUMBER) {
                    rowMap.put(split[0], RuleFunctionManager.createBigDecimal(value));
                } else {
                    rowMap.put(split[0], value);
                }
                RdRow rdRow = RdRow.buildRow(rowMap);
                rdRow.setPkId(1L);
                rdSaveComInfo.setRdRows(Collections.singletonList(rdRow));
                RdResultSave resultSave = saveService.saveDataMult(rdSaveComInfo);
                if (resultSave.isOk()) continue;
                throw new RuleException(resultSave.getMessage());
            }
        }
    }

    @NotNull
    private static Object createBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            return String.format("`%s`", value);
        }
    }

    private void addCustomFilter(RdSaveComInfo rdSaveComInfo) {
        ScopeInfo scope = this.getRulesEngineContext().getRuntimeScope();
        if (scope instanceof RelationScopeInfo) {
            RelationScopeInfo runtimeScope = (RelationScopeInfo)scope;
            EPDMFilter customFilter = null;
            for (DimensionFilterItem dimensionFilterItem : runtimeScope.getFilters()) {
                if (customFilter == null) {
                    customFilter = new EPDMFilter(dimensionFilterItem.getName(), "in", dimensionFilterItem.getValues());
                    continue;
                }
                customFilter.and(new EPDMFilter(dimensionFilterItem.getName(), "in", dimensionFilterItem.getValues()));
            }
            for (RelationDimensionFilterItem filter : runtimeScope.getRelationFilters()) {
                if (customFilter == null) {
                    customFilter = new EPDMFilter(filter.getName(), filter.getCondition(), filter.getValues());
                    continue;
                }
                customFilter.and(new EPDMFilter(filter.getName(), filter.getCondition(), filter.getValues()));
            }
            rdSaveComInfo.setCustomFilter(customFilter);
        }
    }

    private String checkExpression(String[] expressions, Map<Long, RelationFieldBean> relationFieldBeanMap) {
        String message = "";
        for (String expression : expressions) {
            if (!expression.contains("=")) {
                return ResManager.loadKDString((String)"\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5b9a\u4e49\u9519\u8bef\u3002", (String)"RuleFunctionManager_17", (String)"epm-epbs-business", (Object[])new Object[0]);
            }
            String targetNum = expression.split("=", 2)[0];
            Optional<RelationFieldBean> first = relationFieldBeanMap.values().stream().filter(bean -> targetNum.equals(bean.getNumber())).findFirst();
            if (first.isPresent()) continue;
            message = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e2d%s\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleFunctionManager_4", (String)"epm-epbs-business", (Object[])new Object[0]), targetNum);
            break;
        }
        return message;
    }

    @Override
    @KSMethod
    public String data(String bizModelNumber, String expression) {
        String contextBizModelNumber;
        BizModelBean bizModelBean = this.getBizModelBeanByBizModelNumber(bizModelNumber);
        if (this.getRulesEngineContext().isRuntimeBizModelMulti()) {
            return String.format("cube('%s','%s')", bizModelBean.getCube(), expression);
        }
        if (expression.contains("@ALL")) {
            expression = expression.replace("@ALL", "");
        }
        if (!StringUtils.equals((CharSequence)(contextBizModelNumber = this.getRulesEngineContext().getBizModelBean().getNumber()), (CharSequence)bizModelNumber)) {
            throw new RuleException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8de8\u5173\u7cfb\u6a21\u578b[%1$s]\uff0c\u5f53\u524d\u5173\u7cfb\u6a21\u578b[%2$s]", (String)"RuleFunctionManager_5", (String)"epm-epbs-business", (Object[])new Object[0]), bizModelNumber, contextBizModelNumber));
        }
        return expression;
    }

    @Override
    @KSMethod
    public String data(String expression) {
        if (expression.contains("@ALL")) {
            return expression.replace("@ALL", "");
        }
        return expression;
    }

    @Override
    @KSMethod
    public Object currMember(String dimNumber, int offset) {
        if (StringUtils.isEmpty((CharSequence)dimNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u586b\u3002", (String)"RuleFunctionManager_6", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        ScopeInfo runtimeScope = this.getRulesEngineContext().getRuntimeScope();
        if (this.getRulesEngineContext().isRuntimeBizModelMulti()) {
            if (runtimeScope instanceof RelationScopeInfo) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9002\u7528\u8303\u56f4\u4e0e\u6a21\u578b\u4e0d\u5339\u914d", (String)"RuleFunctionManager_7", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            Optional<DimensionFilterItem> filterItem = runtimeScope.getFilters().stream().filter(dimensionFilterItem -> dimensionFilterItem.getName().equals(dimNumber)).findFirst();
            if (!filterItem.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b\u5b57\u6bb5\u7f3a\u5931\u3002", (String)"RuleFunctionManager_8", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            return filterItem.get();
        }
        if (!(runtimeScope instanceof RelationScopeInfo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9002\u7528\u8303\u56f4\u4e0e\u6a21\u578b\u4e0d\u5339\u914d", (String)"RuleFunctionManager_7", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        Optional<RelationDimensionFilterItem> filterItem = ((RelationScopeInfo)runtimeScope).getRelationFilters().stream().filter(dimensionFilterItem -> dimensionFilterItem.getName().equals(dimNumber)).findFirst();
        if (!filterItem.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u7cfb\u6a21\u578b\u5b57\u6bb5\u7f3a\u5931\u3002", (String)"RuleFunctionManager_9", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        return filterItem.get();
    }

    private BizModelBean getBizModelBeanByBizModelNumber(String bizModelNumber) {
        BizModelBean bizModelByNum = EpbsModelCacheHelper.get((long)this.getRulesEngineContext().getModelId()).getBizModelByNum(bizModelNumber);
        if (bizModelByNum == null) {
            return this.getBizModelBeanByBizModelId(bizModelNumber);
        }
        return bizModelByNum;
    }

    private BizModelBean getBizModelBeanByBizModelId(String bizModelId) {
        return EpbsModelCacheHelper.get((long)this.getRulesEngineContext().getModelId()).getBizModelById(NumberUtils.toLong((String)bizModelId));
    }

    private void executeOlapCommand(CommandInfo command) {
        try (TraceSpan ts = Tracer.create((String)tracer_type_compute, (String)tracer_type_compute);){
            OlapCommand cmd = new OlapCommand(this.computingContext.getOlapConnection(), command);
            OlapComTraceUtil.setTraceId(command);
            cmd.executeNonQuery();
        }
    }

    @Override
    @KSMethod
    public ScopeInfo scope(ScopeInfo ... scopeInfo) {
        ScopeInfo scope;
        ScopeInfo newScopeInfo = new ScopeInfo();
        BizModelBean bizModelBean = this.computingContext.getBizModelBean();
        newScopeInfo.setModelId(this.computingContext.getModelId());
        newScopeInfo.setBizmodelId(bizModelBean.getId());
        List<ScopeInfo> scopeInfos = Arrays.asList(scopeInfo);
        scopeInfos.sort((s1, s2) -> BooleanComparator.getTrueFirstComparator().compare(Boolean.valueOf(s1.isInclude()), Boolean.valueOf(s2.isInclude())));
        if (this.computingContext.isRuntimeBizModelMulti()) {
            scope = newScopeInfo.scope(scopeInfos);
        } else {
            scope = new RelationScopeInfo();
            scope.scope(scopeInfos);
        }
        Stack<ScopeInfo> scopeStack = this.computingContext.getScopeStack();
        if (!scopeStack.isEmpty()) {
            scopeStack.pop();
        }
        if (scope != null) {
            scopeStack.push(scope);
        }
        return scope;
    }

    @Override
    @KSMethod
    public boolean and(Boolean ... condition) {
        boolean result = true;
        for (Boolean one : condition) {
            result = result && one != false;
        }
        return result;
    }

    @Override
    @KSMethod
    public boolean or(Boolean ... condition) {
        boolean result = false;
        for (Boolean one : condition) {
            result = result || one != false;
        }
        return result;
    }

    @Override
    public String abs(Object ... objects) {
        if (objects.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"ABS\u51fd\u6570\u5fc5\u987b\u4f20\u5165\u53c2\u6570", (String)"RuleFunctionManager_19", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (Object object : objects) {
            paramBuilder.append(object);
        }
        return String.format("abs(%s)", paramBuilder);
    }

    @Override
    public String mid(Object ... paramMap) {
        if (paramMap.length != 3) {
            throw new KDBizException(ResManager.loadKDString((String)"MID\u51fd\u6570\u53ea\u80fd\u4f20\u5165\u4e09\u4e2a\u53c2\u6570", (String)"RuleFunctionManager_11", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        try {
            String text = paramMap[0].toString();
            int cutPos = Integer.parseInt(paramMap[1].toString());
            int cutLength = Integer.parseInt(paramMap[2].toString());
            if (cutPos < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u622a\u53d6\u4f4d\u7f6e\u4e0d\u80fd\u5c0f\u4e8e1\u3002", (String)"RuleFunctionManager_12", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            if (cutLength < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u622a\u53d6\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"RuleFunctionManager_13", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            if (cutPos > text.length()) {
                return "";
            }
            int beginIndex = cutPos - 1;
            return text.substring(beginIndex, Math.min(text.length(), beginIndex + cutLength));
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    @Override
    public Object round(Object ... objects) {
        if (objects.length < 2) {
            throw new RuleException(String.format(ResManager.loadKDString((String)"round\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u4f46\u5f53\u524d\u8bbe\u7f6e\u4ec5\u63d0\u4f9b\u4e86%d\u4e2a\u3002", (String)"RuleFunctionManager_14", (String)"epm-epbs-business", (Object[])new Object[0]), objects.length));
        }
        StringBuilder firstParamBuilder = new StringBuilder();
        boolean hasFactor = false;
        if (objects.length > 2) {
            for (int i = 0; i < objects.length - 1; ++i) {
                firstParamBuilder.append(objects[i]);
                if (hasFactor || !objects[i].toString().startsWith("cube(")) continue;
                hasFactor = true;
            }
        } else {
            firstParamBuilder.append(objects[0].toString());
        }
        String firstParam = firstParamBuilder.toString();
        if (StringUtils.isEmpty((CharSequence)firstParam)) {
            throw new RuleException(ResManager.loadKDString((String)"round\u51fd\u6570\u7684\u7b2c1\u4e2a\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleFunctionManager_15", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        try {
            Integer.parseInt(objects[objects.length - 1].toString());
        }
        catch (Exception e) {
            throw new RuleException(ResManager.loadKDString((String)"round\u51fd\u6570\u7684\u7b2c2\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u6574\u6570\u3002", (String)"RuleFunctionManager_16", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        return String.format("round(%s,%s)", firstParam, objects[objects.length - 1]);
    }

    @Override
    public Object like(Object ... objects) {
        return Joiner.on((String)"").join(objects);
    }
}

