/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.epm.epbs.business.rules.function.RelationDimensionFilterItem;
import kd.epm.epbs.business.rules.function.ScopeInfo;

public class RelationScopeInfo
extends ScopeInfo {
    public static final String IN = "in";
    public static final String LIKE = "like";
    public static final String NOTLIKE = "not like";
    public static final String NOTIN = "not in";
    private Collection<RelationDimensionFilterItem> relationFilters;

    public RelationScopeInfo() {
        this.relationFilters = new ArrayList<RelationDimensionFilterItem>();
    }

    public RelationScopeInfo(Collection<RelationDimensionFilterItem> relationFilters) {
        this.relationFilters = relationFilters;
    }

    public RelationScopeInfo(RelationDimensionFilterItem filter) {
        this.relationFilters = Collections.singletonList(filter);
    }

    public Collection<RelationDimensionFilterItem> getRelationFilters() {
        return this.relationFilters;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RelationScopeInfo{");
        StringJoiner sj = new StringJoiner(",");
        if (this.relationFilters != null) {
            this.relationFilters.forEach(f -> sj.add(String.format("%s.%s:%s", f.getName(), f.getCondition(), String.join((CharSequence)",", f.getValues().toString()))));
        }
        sb.append(sj).append('}');
        return sb.toString();
    }

    @Override
    public ScopeInfo scope(List<ScopeInfo> scopeInfos) {
        this.getFilters().addAll(super.scope(scopeInfos).getFilters());
        for (ScopeInfo scopeInfo : scopeInfos) {
            if (!(scopeInfo instanceof RelationScopeInfo)) continue;
            this.getRelationFilters().addAll(((RelationScopeInfo)scopeInfo).getRelationFilters());
        }
        return this;
    }

    private void creatRelationFilter(String condition, Map<String, Set<Object>> tempMap, List<RelationDimensionFilterItem> tempFilter) {
        for (Map.Entry<String, Set<Object>> entry : tempMap.entrySet()) {
            String key = entry.getKey();
            tempFilter.add(new RelationDimensionFilterItem(key, condition, entry.getValue() == null ? null : new ArrayList(entry.getValue())));
        }
    }

    private void merge(Object[] anys, Map<String, Set<Object>> tempInMap, Map<String, Set<Object>> tempLikeMap, Map<String, Set<Object>> tempDimMap, List<RelationDimensionFilterItem> tempFilter, Boolean isExceptFlag, String datamodelNum, Set<String> extendNumbers) {
    }

    @Override
    public ScopeInfo except(Object ... anys) {
        HashMap<String, Set<Object>> tempInMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> tempLikeMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> tempDimMap = new HashMap<String, Set<Object>>(16);
        ArrayList tempFilter = new ArrayList(10);
        this.creatExceptFilter(NOTIN, tempInMap);
        this.creatExceptFilter(NOTIN, tempDimMap);
        this.creatExceptFilter(NOTLIKE, tempLikeMap);
        this.relationFilters.addAll(tempFilter);
        RelationScopeInfo relationScopeInfo = new RelationScopeInfo(this.relationFilters);
        return relationScopeInfo;
    }

    private void creatExceptFilter(String condition, Map<String, Set<Object>> tempMap) {
        for (Map.Entry<String, Set<Object>> filter : tempMap.entrySet()) {
            RelationDimensionFilterItem inFilter = null;
            if (filter.getValue() == null) {
                RelationDimensionFilterItem item = new RelationDimensionFilterItem(filter.getKey(), condition, null);
                this.relationFilters.add(item);
                continue;
            }
            LinkedHashSet src = new LinkedHashSet(filter.getValue());
            for (RelationDimensionFilterItem in : this.getRelationFilters()) {
                if (!in.getName().equals(filter.getKey()) || !NOTIN.equals(condition) || !IN.equals(in.getCondition())) continue;
                inFilter = in;
                LinkedHashSet<Object> tar = new LinkedHashSet<Object>(Collections.singleton(in.getValues()));
                tar.removeAll(src);
                inFilter.setValues(new ArrayList<Object>(tar));
                in.setValues(new ArrayList<Object>(tar));
                break;
            }
            if (inFilter != null) continue;
            String key = filter.getKey();
            RelationDimensionFilterItem item = new RelationDimensionFilterItem(key, condition, new ArrayList(src));
            this.relationFilters.add(item);
        }
    }
}

