/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.epm.epbs.business.rules.exception.RuleException;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ScopeInfo {
    private static final Log LOG = LogFactory.getLog(ScopeInfo.class);
    private final Collection<DimensionFilterItem> filters;
    private long modelId;
    private long bizmodelId;
    private boolean isInclude = true;

    public ScopeInfo() {
        this.filters = new ArrayList<DimensionFilterItem>();
        this.isInclude = true;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public long getBizmodelId() {
        return this.bizmodelId;
    }

    public void setBizmodelId(long bizmodelId) {
        this.bizmodelId = bizmodelId;
    }

    public ScopeInfo(Collection<DimensionFilterItem> filters) {
        this.filters = filters;
    }

    public ScopeInfo(DimensionFilterItem filter) {
        this.filters = Collections.singleton(filter);
    }

    public ScopeInfo(DimensionFilterItem filter, boolean isInclude) {
        this(filter);
        this.isInclude = isInclude;
    }

    public ScopeInfo(Collection<DimensionFilterItem> filters, boolean isInclude) {
        this(filters);
        this.isInclude = isInclude;
    }

    public final Collection<DimensionFilterItem> getFilters() {
        return this.filters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopeInfo{");
        StringJoiner sj = new StringJoiner(",");
        if (this.filters != null) {
            this.filters.forEach(f -> sj.add(String.format("%s:[%s]", f.getName(), String.join((CharSequence)",", f.getValues()))));
        }
        sb.append(sj).append('}');
        return sb.toString();
    }

    private void mergeScope(ScopeInfo[] scopes, Map<String, Set<String>> tempMap) {
        for (ScopeInfo scope : scopes) {
            for (DimensionFilterItem filter : scope.getFilters()) {
                String dimName = filter.getName();
                Set<String> filterValues = tempMap.get(dimName);
                if (filterValues == null) {
                    filterValues = new HashSet<String>();
                }
                filterValues.addAll(filter.getValues());
                tempMap.put(dimName, filterValues);
            }
        }
    }

    public ScopeInfo and(Object ... anys) {
        return this.scope(anys);
    }

    public ScopeInfo scope(List<ScopeInfo> scopeInfos) {
        LinkedHashMap<String, List> dim2Values = new LinkedHashMap<String, List>();
        scopeInfos.forEach(scopeInfo -> scopeInfo.getFilters().forEach(dimensionFilterItem -> {
            if (scopeInfo.isInclude) {
                if (CollectionUtils.isNotEmpty((Collection)dimensionFilterItem.getValues())) {
                    dim2Values.computeIfAbsent(dimensionFilterItem.getName(), k -> new ArrayList()).addAll(dimensionFilterItem.getValues());
                }
            } else {
                dim2Values.computeIfAbsent(dimensionFilterItem.getName(), k -> {
                    EpbsModelCache emrModelCache = EpbsModelCacheHelper.get((long)this.modelId);
                    Set bizModelAllDimMembers = emrModelCache.getBizModelAllDimMembers(this.bizmodelId, dimensionFilterItem.getName());
                    Set allMembers = bizModelAllDimMembers.stream().map(memberBean -> memberBean.getNumber()).collect(Collectors.toSet());
                    return new ArrayList(allMembers);
                }).removeAll(dimensionFilterItem.getValues());
            }
        }));
        ArrayList<DimensionFilterItem> scopeFilters = new ArrayList<DimensionFilterItem>();
        dim2Values.forEach((k, v) -> scopeFilters.add(new DimensionFilterItem(k, v)));
        return new ScopeInfo(scopeFilters);
    }

    public ScopeInfo scope(Object ... anys) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>(16);
        if (anys.length == 1 && anys[0] instanceof Object[]) {
            Object items = anys[0];
            ScopeInfo.merge(new Object[]{items}, tempMap);
        } else {
            ScopeInfo.merge(anys, tempMap);
        }
        ArrayList<DimensionFilterItem> tempFilter = new ArrayList<DimensionFilterItem>(tempMap.size());
        for (DimensionFilterItem dimensionFilterItem : this.filters) {
            DimensionFilterItem filterItem;
            Set otherFilter = (Set)tempMap.get(dimensionFilterItem.getName());
            if (otherFilter == null) {
                filterItem = new DimensionFilterItem(dimensionFilterItem.getName(), new ArrayList(dimensionFilterItem.getValues()));
            } else {
                otherFilter.addAll(dimensionFilterItem.getValues());
                filterItem = new DimensionFilterItem(dimensionFilterItem.getName(), new ArrayList(otherFilter));
                tempMap.remove(filterItem.getName());
            }
            tempFilter.add(filterItem);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            tempFilter.add(new DimensionFilterItem((String)entry.getKey(), new ArrayList((Collection)entry.getValue())));
        }
        return new ScopeInfo(tempFilter);
    }

    public ScopeInfo except(Object ... anys) {
        HashMap<String, Set<String>> exceptMap = new HashMap<String, Set<String>>(16);
        if (anys.length == 1 && anys[0] instanceof Object[]) {
            Object items = anys[0];
            ScopeInfo.merge(new Object[]{items}, exceptMap);
        } else {
            ScopeInfo.merge(anys, exceptMap);
        }
        block0: for (Map.Entry filter : exceptMap.entrySet()) {
            DimensionFilterItem inFilter = null;
            HashSet src = new HashSet((Collection)filter.getValue());
            for (DimensionFilterItem in : this.getFilters()) {
                if (!in.getName().equals(filter.getKey())) continue;
                inFilter = in;
                HashSet tar = new HashSet(in.getValues());
                tar.removeAll(src);
                inFilter.setValues(new ArrayList(tar));
                in.setValues(new ArrayList(tar));
                continue block0;
            }
        }
        return this;
    }

    private static void merge(Object[] anys, Map<String, Set<String>> tempMap) {
        for (Object any : anys) {
            if (!(any instanceof ScopeInfo)) {
                throw new RuleException(String.format(ResManager.loadKDString((String)"\u6784\u9020\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u65f6\uff0c\u4f7f\u7528\u4e86\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b\uff1a%s", (String)"ScopeInfo_2", (String)"epm-epbs-business", (Object[])new Object[0]), any == null ? null : any.getClass()));
            }
            ScopeInfo.mergeWithScopeInfo(tempMap, any);
        }
    }

    private static void mergeWithScopeInfo(Map<String, Set<String>> tempMap, Object any) {
        ScopeInfo scopeInfo = (ScopeInfo)any;
        for (DimensionFilterItem filter : scopeInfo.getFilters()) {
            List values = filter.getValues();
            String dimName = filter.getName();
            Set<String> members = tempMap.get(dimName);
            if (members == null) {
                tempMap.put(dimName, new HashSet(values));
                continue;
            }
            members.addAll(values);
        }
    }

    private static void mergeWithString(Map<String, Set<String>> tempMap, Object any) {
        int beforeIndex = ((String)any).indexOf(91);
        int afterIndex = ((String)any).indexOf(93);
        if (beforeIndex < 0 || afterIndex < 0) {
            throw new RuntimeException("the format of string: " + any + " is unSupport");
        }
        String dimName = ((String)any).substring(0, beforeIndex).trim();
        String subStr = ((String)any).substring(beforeIndex + 1, afterIndex).trim();
        String[] array = subStr.split(",");
        Set members = tempMap.computeIfAbsent(dimName, k -> new HashSet(16));
        members.addAll(Arrays.asList(array));
    }

    public static boolean instance(Object arg) {
        return arg instanceof ScopeInfo;
    }

    public static ScopeInfo create(Object ... scopeInfo) {
        ScopeInfo newScopeInfo = new ScopeInfo();
        newScopeInfo = newScopeInfo.scope(scopeInfo);
        return newScopeInfo;
    }

    public boolean isInclude() {
        return this.isInclude;
    }

    public static ScopeInfo parserScopeExpr(long modelId, String scopeExpr) {
        Map<String, String> map = ScopeInfo.parseDimStr(modelId, scopeExpr);
        ScopeInfo scope = new ScopeInfo();
        map.forEach((key, val) -> scope.getFilters().add(new DimensionFilterItem(key, Collections.singletonList(val))));
        return scope;
    }

    public static Map<String, String> parseDimStr(long modelId, String scopeExpr) {
        HashMap<String, String> dimMap = new HashMap<String, String>(4);
        Map shortNums = EpbsModelCacheHelper.get((long)modelId).getShortDimNum2DimNum();
        if (!scopeExpr.trim().isEmpty()) {
            String[] dims;
            for (String temp : dims = scopeExpr.split(",")) {
                String key;
                String[] split = temp.split("[@.]", 2);
                if (split.length < 2) {
                    throw new RuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e32%s\u683c\u5f0f\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a\u7ef4\u5ea6@\u6210\u5458", (String)"BizRuleUtil_19", (String)"fi-bcm-business", (Object[])new Object[0]), temp));
                }
                String dim = split[0].trim();
                String mem = split[1].trim();
                if (shortNums.containsValue(dim)) {
                    key = dim;
                } else if (shortNums.containsKey(dim)) {
                    key = (String)shortNums.get(dim);
                } else {
                    throw new RuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"BizRuleUtil_14", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
                }
                Map memberMap = EpbsMemberCacheHelper.get((long)modelId, (String)key).getMemberMap();
                MemberBean memberBean = null;
                for (Map.Entry entry : memberMap.entrySet()) {
                    MemberBean v = (MemberBean)entry.getValue();
                    if (!mem.equals(v.getNumber())) continue;
                    memberBean = v;
                    break;
                }
                if (memberBean == null) {
                    throw new RuleException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"BizRuleUtil_15", (String)"fi-bcm-business", (Object[])new Object[0]), mem));
                }
                dimMap.put(key, mem);
            }
        }
        return dimMap;
    }
}

