/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.epm.epbs.common.util.Pair;

public class RuleExecParam {
    private RuleExecCommonParam commonParam = new RuleExecCommonParam();
    private List<Pair<Long, String>> bizRuleList = new ArrayList<Pair<Long, String>>();
    private String modelNum;
    private String paperTemplateNumber = "";
    private Long paperTemplateId;
    private String calcTypeWay;

    public RuleExecParam(String modelNum) {
        this.modelNum = modelNum;
    }

    public List<Pair<Long, String>> getBizRuleList() {
        return this.bizRuleList;
    }

    public void setBizRuleList(List<Pair<Long, String>> bizRuleList) {
        this.bizRuleList = bizRuleList;
    }

    public void addBizRuleList(Pair<Long, String> bizRule) {
        this.bizRuleList.add(bizRule);
    }

    public RuleExecCommonParam getCommonParam() {
        return this.commonParam;
    }

    public String getPaperTemplateNumber() {
        return this.paperTemplateNumber;
    }

    public void setPaperTemplateNumber(String paperTemplateNumber) {
        this.paperTemplateNumber = paperTemplateNumber;
    }

    public Long getPaperTemplateId() {
        return this.paperTemplateId;
    }

    public void setPaperTemplateId(Long paperTemplateId) {
        this.paperTemplateId = paperTemplateId;
    }

    public String getCalcTypeWay() {
        return this.calcTypeWay;
    }

    public void setCalcTypeWay(String calcTypeWay) {
        this.calcTypeWay = calcTypeWay;
    }

    public long getIdFromCommonParam(String dimNumber) {
        Pair<Long, String> p = this.getCommonParam().getDimMemberPair(dimNumber);
        return p == null ? 0L : (Long)p.p1;
    }

    public String getNumberFromCommonParam(String dimNumber) {
        Pair<Long, String> p = this.getCommonParam().getDimMemberPair(dimNumber);
        return p == null ? "" : (String)p.p2;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public RuleExecCommonParam addCommonParamPair(String dimNum, Long id, String number) {
        return this.commonParam.addCommonParamPair(dimNum, id, number);
    }

    public RuleExecCommonParam addCommonParamPair(String dimNum, Pair<Long, String> member) {
        return this.commonParam.addCommonParamPair(dimNum, member);
    }

    public void addExternalCommParams(String dim, String ... members) {
        this.commonParam.addExternalCommParams(dim, members);
    }

    public static class RuleExecCommonParam {
        private Map<String, Pair<Long, String>> params = new HashMap<String, Pair<Long, String>>();
        private Map<String, String[]> externalCommParams = new HashMap<String, String[]>();

        public RuleExecCommonParam addCommonParamPair(String dimNum, Long id, String number) {
            Objects.requireNonNull(id, "id request non-null");
            Objects.requireNonNull(number, "number request non-null");
            this.params.put(dimNum, (Pair<Long, String>)Pair.onePair((Object)id, (Object)number));
            return this;
        }

        public RuleExecCommonParam addCommonParamPair(String dimNum, Pair<Long, String> member) {
            Objects.requireNonNull(member.p1, "id request non-null");
            Objects.requireNonNull(member.p2, "number request non-null");
            this.params.put(dimNum, member);
            return this;
        }

        public void addAllCommonParamPair(Map<String, Pair<Long, String>> param) {
            this.params.putAll(param);
        }

        public Map<String, Pair<Long, String>> getParams() {
            return this.params;
        }

        public Map<String, String[]> getExternalCommParams() {
            return this.externalCommParams;
        }

        public void addExternalCommParams(String dim, String ... members) {
            this.externalCommParams.put(dim, members);
        }

        public Pair<Long, String> getDimMemberPair(String dimNum) {
            return this.params.get(dimNum);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            this.params.forEach((key, value) -> str.append(String.format("%s:%s,", key, value.p2)));
            this.externalCommParams.forEach((key, value) -> str.append(String.format("%s:%s,", key, Arrays.toString(value))));
            if (str.length() > 0) {
                str.deleteCharAt(str.length() - 1);
            }
            return String.format("Params:%s", str);
        }
    }
}

