/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.rules.exception.RuleException;
import kd.epm.epbs.business.rules.models.RuleExpressionItem;
import kd.epm.epbs.business.rules.models.RuleFactor;
import kd.epm.epbs.business.rules.models.RuleMember;
import kd.epm.epbs.business.rules.models.RuleScopeDim;
import kd.epm.epbs.business.rules.support.formulas.DataFormula;
import kd.epm.epbs.business.rules.support.formulas.DimMemberFormula;
import kd.epm.epbs.business.rules.support.formulas.ExcludeFormula;
import kd.epm.epbs.business.rules.support.formulas.Formula;
import kd.epm.epbs.business.rules.support.formulas.FormulaRegister;
import kd.epm.epbs.business.rules.support.formulas.IFormula;
import kd.epm.epbs.business.rules.support.formulas.IncludeFormula;
import kd.epm.epbs.business.rules.support.formulas.ParamItem;
import kd.epm.epbs.business.rules.support.formulas.ScopeFormula;
import kd.epm.epbs.business.rules.support.parse.DefaultRuleParser;
import kd.epm.epbs.business.rules.support.vo.MemberParam;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.RuleExpressionNodeEnum;
import kd.epm.epbs.common.enums.RuleFactorFlagEnum;
import kd.epm.epbs.common.error.CommonErrorCode;
import kd.epm.epbs.common.formula.ICustomerFormat;
import kd.epm.epbs.common.formula.expr.BinaryOperationExpr;
import kd.epm.epbs.common.formula.expr.Expression;
import kd.epm.epbs.common.formula.expr.FunctionExpr;
import kd.epm.epbs.common.formula.expr.OperationExpr;
import kd.epm.epbs.common.formula.expr.OperationType;
import kd.epm.epbs.common.formula.expr.UnaryOperationExpr;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.Pair;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RuleUtil {
    public static final Pattern PATTERN = Pattern.compile("[+\\-*/><=]+");

    public static DynamicObject[] createExecRecord(Object[] bizRuleIds, Object modelId) {
        DynamicObject[] execInfos = new DynamicObject[bizRuleIds.length];
        for (int i = 0; i < bizRuleIds.length; ++i) {
            execInfos[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brexecuteinfoentity");
            RuleUtil.setExecRecord(execInfos[i], modelId, bizRuleIds[i]);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])execInfos);
    }

    private static void setExecRecord(DynamicObject execInfo, Object modelId, Object bizRuleId) {
        execInfo.set("bizrule", bizRuleId);
        execInfo.set("starttime", (Object)System.currentTimeMillis());
        execInfo.set("executor", (Object)RequestContext.get().getCurrUserId());
    }

    public static String checkScriptGrammar(String script) {
        try {
            DefaultRuleParser.getInstance().parse(script);
            return "";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static String checkNumberAndName(String name, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleUtil_5", (String)"epm-epbs-business", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleUtil_6", (String)"epm-epbs-business", (Object[])new Object[0]);
        }
        return "";
    }

    private static void restoreFunctionExpr(Expression ex) {
        if (ex instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)ex;
            functionExpr.setFuncionName(functionExpr.getFuncionName().toUpperCase(Locale.ENGLISH));
        }
    }

    private static void formatFunctionExpr(Expression ex) {
        if (ex instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)ex;
            String functionName = functionExpr.getFuncionName();
            functionExpr.setFuncionName(functionName.toLowerCase(Locale.ENGLISH));
        }
    }

    public static String convertScope2Js(List<RuleScopeDim> ruleScopeDims) {
        try {
            ScopeFormula scopeFormula = new ScopeFormula();
            ruleScopeDims.forEach(ruleScopeDim -> {
                Formula param = RuleUtil.buildFormula(ruleScopeDim, true);
                if (Objects.nonNull(param)) {
                    scopeFormula.paramItem(param);
                }
                if (Objects.nonNull(param = RuleUtil.buildFormula(ruleScopeDim, false))) {
                    scopeFormula.paramItem(param);
                }
            });
            return scopeFormula.convertToRuleFormula();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String convertExpression2Js(List<RuleExpressionItem> ruleExpressionItem) {
        try {
            if (CollectionUtils.isEmpty(ruleExpressionItem)) {
                return "";
            }
            StringBuilder jsBuilder = new StringBuilder();
            for (RuleExpressionItem expressionItem : ruleExpressionItem) {
                if (RuleUtil.isDim(expressionItem)) {
                    Formula formula = RuleUtil.buildFormula(expressionItem, expressionItem.getFactorFlag() == RuleFactorFlagEnum.Target);
                    if (formula == null) continue;
                    jsBuilder.append(formula.convertToRuleFormula());
                    continue;
                }
                jsBuilder.append(expressionItem.getText());
            }
            String[] expressions = jsBuilder.toString().split(";");
            ArrayList<String> jsFormulas = new ArrayList<String>(expressions.length);
            for (String expression : expressions) {
                String[] split = expression.split("=");
                if (split.length < 2) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f%s\u5fc5\u987b\u662f\u5de6\u53f3\u7b49\u5f0f", (String)"RuleUtil_8", (String)"epm-epbs-business", (Object[])new Object[0]), expression));
                }
                jsFormulas.add(expression);
            }
            jsBuilder.setLength(0);
            for (String jsFormula : jsFormulas) {
                Pair<String, List<IFormula>> formulaPair = DefaultRuleParser.getInstance().parse(jsFormula);
                String formulaUUID = (String)formulaPair.p1;
                HashMap<String, String> uuid2Temp = new HashMap<String, String>(((List)formulaPair.p2).size());
                HashMap<String, String> uuid2Formula = new HashMap<String, String>(((List)formulaPair.p2).size());
                int count = 1;
                for (IFormula formula : (List)formulaPair.p2) {
                    String uuid = formula.getUUID();
                    uuid2Temp.put(uuid, String.format("{{%s}}", count));
                    uuid2Formula.put(String.format("{{%s}}", count), formula.convertToRuleFormula());
                    ++count;
                }
                Matcher matcher = PATTERN.matcher(formulaUUID);
                HashSet<String> links = new HashSet<String>();
                while (matcher.find()) {
                    String group = matcher.group();
                    links.add(group);
                }
                List sortedLinks = links.stream().sorted((s1, s2) -> {
                    if (s1.equals("+") || s2.equals("+")) {
                        return 1;
                    }
                    return s2.compareToIgnoreCase((String)s1);
                }).collect(Collectors.toList());
                Iterator iterator = sortedLinks.iterator();
                while (iterator.hasNext()) {
                    String sortedLink;
                    String replacedSortedLink = sortedLink = (String)iterator.next();
                    if ("<>".endsWith(sortedLink)) {
                        replacedSortedLink = "!=";
                    }
                    formulaUUID = formulaUUID.replace(sortedLink, "+\"" + replacedSortedLink + "\"+");
                }
                String formulaJs = formulaUUID;
                for (Map.Entry entry : uuid2Temp.entrySet()) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    formulaJs = formulaJs.replace(k, v);
                }
                for (Map.Entry entry : uuid2Temp.entrySet()) {
                    formulaJs = formulaJs.replaceFirst((String)entry.getKey(), (String)entry.getValue());
                }
                for (Map.Entry entry : uuid2Formula.entrySet()) {
                    formulaJs = formulaJs.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                jsBuilder.append(String.format("RUNS(%s)", formulaJs));
                jsBuilder.append(";");
            }
            return jsBuilder.toString();
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static boolean isUserInput(RuleExpressionItem expressionItem) {
        return RuleExpressionNodeEnum.UserInput == expressionItem.getNodeType();
    }

    private static boolean isSignal(RuleExpressionItem expressionItem) {
        return RuleExpressionNodeEnum.Signal == expressionItem.getNodeType() && !RuleUtil.isFunction(expressionItem);
    }

    private static boolean isFunction(RuleExpressionItem expressionItem) {
        if (StringUtils.isEmpty((String)expressionItem.getText())) {
            return false;
        }
        return FormulaRegister.existFormula(expressionItem.getText());
    }

    private static boolean isDim(RuleExpressionItem expressionItem) {
        return RuleExpressionNodeEnum.Dim == expressionItem.getNodeType();
    }

    private static Formula buildFormula(RuleScopeDim ruleScopeDim, boolean include) {
        if (include) {
            if (CollectionUtils.isNotEmpty(ruleScopeDim.getMembers())) {
                IncludeFormula includeFormula = new IncludeFormula();
                includeFormula.paramItem(ruleScopeDim.getNumber());
                ruleScopeDim.getMembers().forEach(member -> {
                    Formula dimMember = new DimMemberFormula().paramItem(member.getViewNumber()).paramItem(member.getNumber()).paramItem(member.getRange()).paramItem(member.getType());
                    includeFormula.paramItem(dimMember);
                });
                return includeFormula;
            }
        } else if (CollectionUtils.isNotEmpty(ruleScopeDim.getExcepts())) {
            ExcludeFormula excludeFormula = new ExcludeFormula();
            excludeFormula.paramItem(ruleScopeDim.getNumber());
            ruleScopeDim.getExcepts().forEach(member -> {
                Formula dimMember = new DimMemberFormula().paramItem(member.getViewNumber()).paramItem(member.getNumber()).paramItem(member.getRange()).paramItem(member.getType());
                excludeFormula.paramItem(dimMember);
            });
            return excludeFormula;
        }
        return null;
    }

    private static Formula buildFormula(RuleExpressionItem expressionItem, boolean isTarget) {
        Formula formula = null;
        if (RuleExpressionNodeEnum.Dim == expressionItem.getNodeType()) {
            formula = new DataFormula();
            if (!isTarget) {
                formula.paramItem(expressionItem.getModel().getNumber());
            }
            StringJoiner stringJoiner = new StringJoiner(",");
            for (RuleFactor ruleFactor : expressionItem.getRuleFactors()) {
                for (RuleMember member : ruleFactor.getMembers()) {
                    stringJoiner.add(String.format("%s@%s", ruleFactor.getNumber(), member.getNumber()));
                }
            }
            formula.paramItem(stringJoiner.toString());
        } else if (RuleUtil.isFunction(expressionItem)) {
            Class<? extends IFormula> formulaModelClazz = FormulaRegister.getRuleSupportFormulaModelClazz(expressionItem.getText());
            try {
                formula = (Formula)formulaModelClazz.newInstance();
            }
            catch (Exception e) {
                throw new RuleException(CommonErrorCode.create((String)"20006", (Object[])new Object[]{expressionItem.getText()}), new Object[0]);
            }
        }
        return formula;
    }

    public static List<String> findAllMembers(MemberParam memberParam) {
        RangeEnum rangeEnum = RangeEnum.getRangeByVal((String)memberParam.getRangeNumber());
        if (rangeEnum == null) {
            return Collections.singletonList(memberParam.getMemberNumber());
        }
        long dimensionId = EpbsModelCacheHelper.get((long)memberParam.getModelId()).getDimension(memberParam.getDimNumber()).getId();
        EpbsMemberCache emrMemberCache = EpbsMemberCacheHelper.get((long)memberParam.getModelId(), (long)dimensionId);
        MemberBean member = emrMemberCache.getMember(memberParam.getViewNumber(), memberParam.getMemberNumber());
        if (member == null) {
            throw new RuleException(String.format(ResManager.loadKDString((String)"\u89c6\u56fe[%1$s]\u4e0b\u7684\u6210\u5458[%2$s]\u4e0d\u5b58\u5728", (String)"RuleUtil_7", (String)"epm-epbs-business", (Object[])new Object[0]), memberParam.getViewNumber(), memberParam.getMemberNumber()));
        }
        long memberId = member.getId();
        List members = emrMemberCache.getMembers(Long.valueOf(memberId), rangeEnum);
        return members.stream().map(BaseBean::getNumber).collect(Collectors.toList());
    }

    public static List<String> findAllMembers(MemberParam memberParam, long dimensionId) {
        RangeEnum rangeEnum = RangeEnum.getRangeByVal((String)memberParam.getRangeNumber());
        if (rangeEnum == null) {
            return Collections.singletonList(memberParam.getMemberNumber());
        }
        EpbsMemberCache emrMemberCache = EpbsMemberCacheHelper.get((long)memberParam.getModelId(), (long)dimensionId);
        MemberBean member = emrMemberCache.getMember(memberParam.getViewNumber(), memberParam.getMemberNumber());
        if (member == null) {
            throw new RuleException(String.format(ResManager.loadKDString((String)"\u89c6\u56fe[%1$s]\u4e0b\u7684\u6210\u5458[%2$s]\u4e0d\u5b58\u5728", (String)"RuleUtil_7", (String)"epm-epbs-business", (Object[])new Object[0]), memberParam.getViewNumber(), memberParam.getMemberNumber()));
        }
        long memberId = member.getId();
        List members = emrMemberCache.getMembers(Long.valueOf(memberId), rangeEnum);
        return members.stream().map(BaseBean::getNumber).collect(Collectors.toList());
    }

    public static boolean existNumber(List<String> numbers, String number) {
        return numbers.contains(number);
    }

    public static String getExprFormatOperate(ParamItem expression) {
        StringBuffer sb = new StringBuffer();
        if (expression.getParam() instanceof OperationExpr) {
            OperationExpr operationExpr = (OperationExpr)expression.getParam();
            operationExpr.output(sb, new ICustomerFormat(){

                public void beforeOutput(Expression ex, StringBuffer sb) {
                    RuleUtil.restoreFunctionExpr(ex);
                    if (ex instanceof UnaryOperationExpr && ((UnaryOperationExpr)ex).getOperationType() == 1 && sb.length() > 0) {
                        sb.setCharAt(sb.length() - 1, ' ');
                    }
                }

                public void afterOutput(Expression ex, StringBuffer sb) {
                    RuleUtil.restoreFunctionExpr(ex);
                }

                public String formatOP(String op) {
                    return op;
                }

                public boolean needBracket(BinaryOperationExpr myself, BinaryOperationExpr expression) {
                    return OperationType.comparePRI((int)myself.getOperationType(), (int)expression.getOperationType()) > 0;
                }
            });
        } else if (expression.getParam() instanceof FunctionExpr) {
            ((FunctionExpr)expression.getParam()).output(sb, new ICustomerFormat(){

                public void beforeOutput(Expression ex, StringBuffer sb) {
                    RuleUtil.restoreFunctionExpr(ex);
                }

                public void afterOutput(Expression ex, StringBuffer sb) {
                    RuleUtil.restoreFunctionExpr(ex);
                }

                public String formatOP(String op) {
                    return op;
                }
            });
        } else {
            sb.append("+").append(RuleUtil.wrapQuote(expression.toString()));
        }
        return sb.toString().replace(" ", "");
    }

    public static String wrapQuote(String str) {
        return "\"" + str + "\"";
    }

    public static String likeFormat(String condition) {
        return "%" + condition + "%";
    }

    static class FormulaParentheses {
        private final Formula formula;
        private final Stack<String> parentheses = new Stack();

        public FormulaParentheses(Formula formula) {
            this.formula = formula;
        }

        public Formula getFormula() {
            return this.formula;
        }

        public Stack<String> getParentheses() {
            return this.parentheses;
        }

        public void popParentheses() {
            this.parentheses.pop();
        }

        public void pushParentheses(String content) {
            this.parentheses.push(content);
        }

        public boolean isEmptyParentheses() {
            return this.parentheses.isEmpty();
        }
    }
}

