/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.formulas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.epm.epbs.business.rules.support.formulas.IFormatParam;
import kd.epm.epbs.business.rules.support.formulas.IFormula;
import kd.epm.epbs.business.rules.support.formulas.ParamItem;
import kd.epm.epbs.business.rules.support.formulas.ParamList;
import kd.epm.epbs.common.formula.expr.StringExpr;
import org.apache.commons.collections4.CollectionUtils;

public abstract class Formula
implements IFormula,
IFormatParam {
    private Object value;
    private ParamList params;
    private Exception exception;
    private String uuid;
    private int calcLevel = 0;
    private String exceptionMsg;
    private String logMsg;
    private String tipLogMsg;
    private int floatParamIndex = -1;
    private boolean periodInFormula = false;

    @Override
    public void initParam(ParamList params) {
        this.params = params;
    }

    @Override
    public <T> T getValue() {
        return (T)(this.hasException() ? this.exception : this.value);
    }

    @Override
    public ParamList getParamList() {
        return this.params;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception e) {
        this.exception = e;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public int getFloatParamIndex() {
        return this.floatParamIndex;
    }

    @Override
    public void setFloatParamIndex(int floatParamIndex) {
        this.floatParamIndex = floatParamIndex;
    }

    @Override
    public String getTipLogMsg() {
        return this.tipLogMsg;
    }

    @Override
    public void setTipLogMsg(String tipLogMsg) {
        this.tipLogMsg = tipLogMsg;
    }

    public String toString() {
        List list = this.params.stream().map(p -> {
            if (p.getParam() instanceof Number || p.getParam() instanceof Boolean) {
                return p.toString();
            }
            return "\"" + p + "\"";
        }).collect(Collectors.toList());
        return this.getName() + "(" + String.join((CharSequence)",", list) + ")";
    }

    public String convertToRuleFormula(String formulaName) {
        if (CollectionUtils.isEmpty((Collection)this.params)) {
            return "";
        }
        List list = this.params.stream().map(p -> {
            if (p.getParam() instanceof Number || p.getParam() instanceof Boolean) {
                return p.toString();
            }
            if (p.getParam() instanceof Formula) {
                return ((Formula)p.getParam()).convertToRuleFormula();
            }
            return "\"" + p + "\"";
        }).collect(Collectors.toList());
        return formulaName + "(" + String.join((CharSequence)",", list) + ")";
    }

    @Override
    public String convertToRuleFormula() {
        return this.convertToRuleFormula(this.getRuleName());
    }

    public String getRuleName() {
        return this.getName().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public void setCalcLevel(int level) {
        this.calcLevel = level;
    }

    @Override
    public int getCalcLevel() {
        return this.calcLevel;
    }

    @Override
    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    @Override
    public void setExceptionMsg(String exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
    }

    @Override
    public String getLogMsg() {
        return this.logMsg;
    }

    @Override
    public void setLogMsg(String logMsg) {
        this.logMsg = logMsg;
    }

    @Override
    public List<Object> formatParam() {
        ArrayList<Object> params = new ArrayList<Object>();
        this.getParamList().forEach(pitem -> {
            Object p = pitem.getParam();
            if (p instanceof StringExpr) {
                params.add(((StringExpr)p).getValue());
            } else if (p != null) {
                params.add(p.toString());
            } else {
                params.add("");
            }
        });
        return params;
    }

    public boolean iSParamCanAccExp(int index) {
        return false;
    }

    @Override
    public boolean isPeriodInFormula() {
        return this.periodInFormula;
    }

    @Override
    public void setPeriodInFormula(boolean periodInFormula) {
        this.periodInFormula = periodInFormula;
    }

    public Formula paramItem(Object param) {
        if (this.params == null) {
            this.initParam(new ParamList());
        }
        this.params.add(new ParamItem(param));
        return this;
    }
}

