/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.formulas;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.business.rules.annotation.RuleFunction;
import kd.epm.epbs.business.rules.support.formulas.IFormula;
import kd.epm.epbs.common.error.CommonErrorCode;
import kd.epm.epbs.common.util.PackageScanner;

public class FormulaRegister {
    private final Map<String, Class<? extends IFormula>> registers = new ConcurrentHashMap<String, Class<? extends IFormula>>();
    private final Map<String, Class<? extends IFormula>> ruleRegisters = new ConcurrentHashMap<String, Class<? extends IFormula>>();
    private static final Map<String, FormulaRegister> instances = new ConcurrentHashMap<String, FormulaRegister>();

    private FormulaRegister() {
        this.initRegister();
    }

    private void initRegister() {
        Set classes = PackageScanner.scanPackageByAnnotation((String)"kd.epm.epbs.business.rules.support.formulas", RuleFunction.class, (ClassLoader)this.getClass().getClassLoader());
        for (Class clazz : classes) {
            this.innerRegister(clazz.getAnnotation(RuleFunction.class).value(), clazz);
            this.registerRuleSupportFormula(clazz.getAnnotation(RuleFunction.class).value(), clazz);
        }
    }

    private void registerRuleSupportFormula(String formulaName, Class<? extends IFormula> modelClazz) {
        if (this.ruleRegisters.containsKey(FormulaRegister.toLowerCase(formulaName))) {
            return;
        }
        this.ruleRegisters.put(FormulaRegister.toLowerCase(formulaName), modelClazz);
    }

    private void innerRegister(String formulaName, Class<? extends IFormula> modelClazz) {
        if (this.registers.containsKey(FormulaRegister.toLowerCase(formulaName))) {
            return;
        }
        this.registers.put(FormulaRegister.toLowerCase(formulaName), modelClazz);
    }

    private static FormulaRegister getInstance() {
        return instances.computeIfAbsent(CacheKeyUtil.getAcctId(), k -> new FormulaRegister());
    }

    public static Class<? extends IFormula> getFormulaModelClazz(String formulaName) {
        Class<? extends IFormula> formulaClazz = FormulaRegister.getInstance().registers.get(FormulaRegister.toLowerCase(formulaName));
        if (formulaClazz != null) {
            return formulaClazz;
        }
        FormulaRegister.check(formulaName);
        return FormulaRegister.getInstance().registers.get(FormulaRegister.toLowerCase(formulaName));
    }

    public static Class<? extends IFormula> getRuleSupportFormulaModelClazz(String formulaName) {
        Class<? extends IFormula> formulaClazz = FormulaRegister.getInstance().ruleRegisters.get(FormulaRegister.toLowerCase(formulaName));
        if (formulaClazz != null) {
            return formulaClazz;
        }
        FormulaRegister.checkRuleFormula(formulaName);
        return FormulaRegister.getInstance().ruleRegisters.get(FormulaRegister.toLowerCase(formulaName));
    }

    private static void check(String formulaName) {
        if (!FormulaRegister.existFormula(formulaName)) {
            throw new KDBizException(CommonErrorCode.create((String)"20003", (Object[])new Object[]{formulaName}), new Object[0]);
        }
    }

    public static boolean existFormula(String formulaName) {
        return FormulaRegister.getInstance().registers.containsKey(FormulaRegister.toLowerCase(formulaName));
    }

    private static void checkRuleFormula(String formulaName) {
        if (!FormulaRegister.existRuleFormula(formulaName)) {
            throw new KDBizException(CommonErrorCode.create((String)"20003", (Object[])new Object[]{formulaName}), new Object[0]);
        }
    }

    public static boolean existRuleFormula(String formulaName) {
        return FormulaRegister.getInstance().ruleRegisters.containsKey(FormulaRegister.toLowerCase(formulaName));
    }

    private static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }
}

