/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.formulas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.epbs.business.rules.annotation.RuleFunction;
import kd.epm.epbs.business.rules.support.formulas.Formula;
import kd.epm.epbs.business.rules.support.formulas.IFormula;
import kd.epm.epbs.business.rules.support.formulas.NormalFormula;
import kd.epm.epbs.business.rules.support.formulas.ParamItem;
import kd.epm.epbs.business.rules.support.parse.DefaultRuleParser;
import kd.epm.epbs.common.util.Pair;

@RuleFunction(value="ROUND")
public class ROUNDFormula
extends NormalFormula {
    public static final String NAME = "ROUND";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String convertToRuleFormula(String formulaName) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.getParamList().size(); ++i) {
            ParamItem paramItem = (ParamItem)this.getParamList().get(i);
            Object p = paramItem.getParam();
            if (i == 0) {
                if (p instanceof Formula) {
                    list.add(((Formula)p).convertToRuleFormula());
                    continue;
                }
                Pair<String, List<IFormula>> formulaPair = DefaultRuleParser.getInstance().parse(p.toString());
                HashMap<String, String> uuid2Temp = new HashMap<String, String>(((List)formulaPair.p2).size());
                HashMap<String, String> uuid2Formula = new HashMap<String, String>(((List)formulaPair.p2).size());
                int count = 1;
                for (IFormula formula : (List)formulaPair.p2) {
                    String uuid = formula.getUUID();
                    uuid2Temp.put(uuid, String.format("{{%s}}", count));
                    uuid2Formula.put(String.format("{{%s}}", count), formula.convertToRuleFormula());
                    ++count;
                }
                String formulaJs = (String)formulaPair.p1;
                int j = 0;
                for (Map.Entry entry : uuid2Temp.entrySet()) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    formulaJs = j == 0 ? formulaJs.replace(k, v + "+\"") : formulaJs.replace(k, "\"+" + v + "+\"");
                    ++j;
                }
                formulaJs = formulaJs.endsWith("+\"") ? formulaJs.substring(0, formulaJs.length() - "+\"".length()) : formulaJs + "\"";
                for (Map.Entry entry : uuid2Temp.entrySet()) {
                    formulaJs = formulaJs.replaceFirst((String)entry.getKey(), (String)entry.getValue());
                }
                for (Map.Entry entry : uuid2Formula.entrySet()) {
                    formulaJs = formulaJs.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                list.add(formulaJs);
                continue;
            }
            if (p instanceof Number || p instanceof Boolean) {
                list.add(p.toString());
                continue;
            }
            if (p instanceof Formula) {
                list.add(((Formula)p).convertToRuleFormula());
                continue;
            }
            list.add("\"" + p + "\"");
        }
        return formulaName + "(" + String.join((CharSequence)",", list) + ")";
    }
}

