/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.formulas;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.epm.epbs.business.rules.annotation.RuleFunction;
import kd.epm.epbs.business.rules.support.formulas.Formula;
import kd.epm.epbs.common.constant.SystemSeparator;

@RuleFunction(value="V")
public class VFormula
extends Formula {
    public static final String NAME = "V";
    private String key;

    @Override
    public void fillBack(Map<String, Object> result) {
        Object v = result.get(this.getKey());
        if (v instanceof String && (v.toString().trim().equals("-") || v.toString().trim().equals("\uff0d"))) {
            v = 0;
        }
        this.setValue(v);
    }

    @Override
    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        List list = Lists.transform((List)this.getParamList(), p -> VFormula.splitDimAndMemb(p.toString())[1]);
        this.key = Joiner.on((String)"|").join((Iterable)list);
        return this.key;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static String[] splitDimAndMemb(String param) {
        param = param.trim();
        int first = param.indexOf(SystemSeparator.DIM_MEMB_SEPARATOR.charValue());
        String dim = param.substring(0, first);
        String member = param.substring(first + 1);
        return new String[]{dim, member};
    }

    public static String getVName() {
        return NAME;
    }
}

