/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.log;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.cache.ThreadCache;
import kd.epm.epbs.business.rules.support.log.BizRuleDebugLogInfo;
import kd.epm.epbs.business.rules.support.log.BizRuleDebugLogInfoEnum;
import org.mozilla.javascript.NativeObject;

public class ScriptDebugLogInfoUtil {
    private static BizRuleDebugLogInfo newLogInfo(BizRuleDebugLogInfoEnum level, String info) {
        return new BizRuleDebugLogInfo(level, info);
    }

    public static void debug(String bizModelId, Object info) {
        ScriptDebugLogInfoUtil.addInfo(bizModelId, BizRuleDebugLogInfoEnum.DEBUG, info);
    }

    public static void log(String bizModelId, Object info) {
        ScriptDebugLogInfoUtil.addInfo(bizModelId, BizRuleDebugLogInfoEnum.LOG, info);
    }

    private static void addInfo(String bizModelId, BizRuleDebugLogInfoEnum level, Object info) {
        List<BizRuleDebugLogInfo> infolist = ScriptDebugLogInfoUtil.getLogInfoByBizModelId(bizModelId);
        infolist.add(ScriptDebugLogInfoUtil.newLogInfo(level, info == null ? "null" : ScriptDebugLogInfoUtil.transObject(info)));
    }

    private static String transObject(Object info) {
        if (info instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)info;
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry entry : nativeObject.entrySet()) {
                jsonObject.put(ScriptDebugLogInfoUtil.transObject(entry.getKey()), (Object)ScriptDebugLogInfoUtil.transObject(entry.getValue()));
            }
            return jsonObject.toJSONString();
        }
        if (info instanceof HashMap) {
            JSONObject jsonObject = new JSONObject();
            HashMap map = (HashMap)info;
            for (Map.Entry entry : map.entrySet()) {
                jsonObject.put(ScriptDebugLogInfoUtil.transObject(entry.getKey()), (Object)ScriptDebugLogInfoUtil.transObject(entry.getValue()));
            }
            return jsonObject.toJSONString();
        }
        if (info instanceof Object[]) {
            StringBuilder stringBuilder = new StringBuilder("[");
            StringJoiner sj = new StringJoiner(", ");
            for (Object o : (Object[])info) {
                sj.add(ScriptDebugLogInfoUtil.transObject(o));
            }
            stringBuilder.append(sj).append("]");
            return stringBuilder.toString();
        }
        return info == null ? "null" : info.toString();
    }

    public static List<BizRuleDebugLogInfo> getLogInfoByBizModelId(String bizModelId) {
        return (List)ThreadCache.get((Object)bizModelId, ArrayList::new);
    }

    public static void collectLog2Cache(String key, String log) {
        ScriptDebugLogInfoUtil.getLogHolder(key).append(log);
    }

    public static String getCollectLogs(String key) {
        return ScriptDebugLogInfoUtil.getLogHolder(key).toString();
    }

    private static StringBuilder getLogHolder(String key) {
        return (StringBuilder)ThreadCache.get((Object)key, StringBuilder::new);
    }

    public static void removeCollectLogs(String key) {
        ThreadCache.remove((Object)key);
    }
}

