/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.parse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.business.rules.support.formulas.FormulaCalculateFactory;
import kd.epm.epbs.business.rules.support.formulas.IFormula;
import kd.epm.epbs.business.rules.support.formulas.ParamItem;
import kd.epm.epbs.business.rules.support.formulas.ParamList;
import kd.epm.epbs.common.formula.EncoderService;
import kd.epm.epbs.common.formula.ExcelFormulaParserHelper;
import kd.epm.epbs.common.formula.expr.BinaryOperationExpr;
import kd.epm.epbs.common.formula.expr.Expression;
import kd.epm.epbs.common.formula.expr.FunctionExpr;
import kd.epm.epbs.common.formula.expr.Functional;
import kd.epm.epbs.common.formula.expr.UnaryOperationExpr;
import kd.epm.epbs.common.util.Pair;

public class ExpressParser {
    public Pair<String, List<IFormula>> parse(String express, EncoderService encoder) throws Exception {
        if (express == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpressParser_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        Expression exprs = ExcelFormulaParserHelper.parse((String)express);
        StringBuffer buffer = new StringBuffer();
        exprs.outputEncodeExpr(buffer, x -> encoder.getCode());
        ArrayList<Functional> lst = new ArrayList<Functional>();
        this.collectFunctionExpr(lst, exprs);
        List formulas = Lists.transform(lst, f -> this.transFormulaExpr2Formula((Functional)f, true));
        ArrayList extendFormulas = new ArrayList();
        formulas.forEach(f -> this.extendFunctionExprOnParams((IFormula)f, encoder, 0, extendFormulas));
        extendFormulas.addAll(formulas);
        return Pair.onePair((Object)buffer.toString(), extendFormulas);
    }

    public List<Expression> parseAll(String express, EncoderService encoder) throws Exception {
        if (express == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpressParser_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        Expression exprs = ExcelFormulaParserHelper.parse((String)express);
        StringBuffer buffer = new StringBuffer();
        exprs.outputEncodeExpr(buffer, x -> encoder.getCode());
        ArrayList<Expression> lst = new ArrayList<Expression>();
        this.recursiveCollectExpr(lst, exprs);
        return lst;
    }

    private void recursiveCollectExpr(List<Expression> lst, Expression exprs) {
        if (exprs instanceof FunctionExpr) {
            ((FunctionExpr)exprs).getParameters().stream().map(parameter -> (Expression)parameter).forEach(e -> this.recursiveCollectExpr(lst, (Expression)e));
        } else if (exprs instanceof BinaryOperationExpr) {
            this.recursiveCollectExpr(lst, ((BinaryOperationExpr)exprs).getLeft());
            this.recursiveCollectExpr(lst, ((BinaryOperationExpr)exprs).getRight());
        } else if (exprs instanceof UnaryOperationExpr) {
            this.recursiveCollectExpr(lst, ((UnaryOperationExpr)exprs).getOperand());
        } else {
            lst.add(exprs);
        }
    }

    private IFormula transFormulaExpr2Formula(Functional f, boolean isSyncroUuid) {
        if (f instanceof FunctionExpr) {
            return this.constructFormulaModel((FunctionExpr)f, isSyncroUuid);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5185\u5bb9\u3010%s\u3011\u4e0d\u662f\u51fd\u6570\u8868\u8fbe\u5f0f ", (String)"ExpressParser_2", (String)"epm-epbs-business", (Object[])new Object[0]), f.toString()));
    }

    private IFormula constructFormulaModel(FunctionExpr f, boolean isSyncroUuid) {
        Object formula = FormulaCalculateFactory.getFormulaModel(f.getFuncionName());
        ParamList paramlist = new ParamList();
        f.getParameters().forEach(p -> this.fillParam(isSyncroUuid, p, paramlist));
        formula.initParam(paramlist);
        if (isSyncroUuid) {
            formula.setUUID(f.getUUID());
        }
        formula.setCalcLevel(0);
        return formula;
    }

    private void fillParam(boolean isSyncroUuid, Object p, ParamList paramlist) {
        if (p instanceof FunctionExpr) {
            paramlist.add(new ParamItem(this.constructFormulaModel((FunctionExpr)p, isSyncroUuid)));
        } else if (p instanceof BinaryOperationExpr) {
            ParamList paramList1 = new ParamList();
            this.fillParam(isSyncroUuid, ((BinaryOperationExpr)p).getLeft(), paramList1);
            this.fillParam(isSyncroUuid, ExpressParser.replaceOperation((BinaryOperationExpr)p), paramList1);
            this.fillParam(isSyncroUuid, ((BinaryOperationExpr)p).getRight(), paramList1);
            StringBuilder param = new StringBuilder();
            paramList1.forEach(p1 -> param.append(p1.toString()));
            paramlist.add(new ParamItem(param));
        } else {
            paramlist.add(new ParamItem(p));
        }
    }

    private static String replaceOperation(BinaryOperationExpr p) {
        if (p.getOperationType() == 15) {
            return "!=";
        }
        return p.getOperation();
    }

    private void extendFunctionExprOnParams(IFormula f, EncoderService encoder, int parentLevel, List<IFormula> extendFormulas) {
        f.getParamList().forEach(p -> {
            if (p.getParam() instanceof Expression) {
                this.collectFunctionExpr((Expression)p.getParam(), encoder, parentLevel, extendFormulas);
            }
        });
    }

    private void collectFunctionExpr(Expression exprs, EncoderService encoder, int parentLevel, List<IFormula> extendFormulas) {
        if (exprs instanceof FunctionExpr) {
            IFormula formula = this.transFormulaExpr2Formula((Functional)exprs, false);
            String uuid = encoder.getCode();
            exprs.setUUID(uuid);
            formula.setUUID(uuid);
            int level = parentLevel + 1;
            formula.setCalcLevel(level);
            extendFormulas.add(formula);
            this.extendFunctionExprOnParams(formula, encoder, level, extendFormulas);
        } else if (exprs instanceof BinaryOperationExpr) {
            this.collectFunctionExpr(((BinaryOperationExpr)exprs).getLeft(), encoder, parentLevel, extendFormulas);
            this.collectFunctionExpr(((BinaryOperationExpr)exprs).getRight(), encoder, parentLevel, extendFormulas);
        } else if (exprs instanceof UnaryOperationExpr) {
            this.collectFunctionExpr(((UnaryOperationExpr)exprs).getOperand(), encoder, parentLevel, extendFormulas);
        }
    }

    private void collectFunctionExpr(List<Functional> lst, Expression exprs) {
        if (exprs instanceof Functional) {
            lst.add((Functional)exprs);
        } else if (exprs instanceof BinaryOperationExpr) {
            this.collectFunctionExpr(lst, ((BinaryOperationExpr)exprs).getLeft());
            this.collectFunctionExpr(lst, ((BinaryOperationExpr)exprs).getRight());
        } else if (exprs instanceof UnaryOperationExpr) {
            this.collectFunctionExpr(lst, ((UnaryOperationExpr)exprs).getOperand());
        }
    }
}

