/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.support.parse;

import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.business.rules.support.formulas.IFormula;
import kd.epm.epbs.business.rules.support.parse.ExpressParser;
import kd.epm.epbs.common.error.CommonErrorCode;
import kd.epm.epbs.common.formula.EncoderService;
import kd.epm.epbs.common.util.Pair;

public class ExpressParserHelper {
    public static final Log LOG = LogFactory.getLog(ExpressParserHelper.class);
    public static final ExpressParser PARSER = new ExpressParser();
    public static final EncoderService ENCODER_SERVICE = new EncoderService();

    public static Pair<String, List<IFormula>> parse(String expression, boolean replaceSpecialCharacter) {
        if (replaceSpecialCharacter) {
            expression = expression.replace('\u00a0', ' ');
        }
        try {
            Pair<String, List<IFormula>> pair = PARSER.parse(expression, ENCODER_SERVICE);
            return pair;
        }
        catch (Exception e) {
            LOG.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new KDBizException(CommonErrorCode.create((String)"20006", (Object[])new Object[]{expression}), new Object[]{e});
        }
        finally {
            ENCODER_SERVICE.reset();
        }
    }

    public static Pair<String, List<IFormula>> parse(String expression) {
        return ExpressParserHelper.parse(expression, false);
    }
}

