/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.trace;

import java.util.HashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.olap.dataSources.CommandInfo;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.epm.epbs.business.rules.trace.TraceLogCache;
import kd.epm.epbs.business.rules.trace.TraceLogMsg;
import kd.epm.epbs.common.util.GlobalIdUtil;

public class OlapComTraceUtil {
    public static final String TraceOlapCache = "toc";
    public static final String TraceOpCache = "topc";
    public static final String TraceId = "traceId";
    public static final String ComCommand = "00000000";
    public static final String RuleId = "ruleid";
    public static final String Uniqueid = "uniqueid";

    public static void setTraceId(CommandInfo commandInfo) {
        OlapComTraceUtil.setTraceId(commandInfo, true);
    }

    public static void setTraceId(CommandInfo commandInfo, boolean setOpInfo) {
        if (!OlapComTraceUtil.isTrace()) {
            return;
        }
        if (commandInfo.getExtProperties() == null) {
            commandInfo.setExtProperties(new HashMap());
        }
        if (TraceLogCache.exists(RuleId)) {
            commandInfo.getExtProperties().put(TraceId, OlapComTraceUtil.getUniqueid() + OlapComTraceUtil.subRuleId(TraceLogCache.get(RuleId).toString()));
        } else {
            commandInfo.getExtProperties().put(TraceId, OlapComTraceUtil.getUniqueid() + ComCommand);
        }
        OlapTraceServiceHelper.setTraceLog(Long.parseLong(OlapComTraceUtil.getUniqueid()), null);
    }

    public static void setTraceLog(AppLogInfo applogInfo) {
        if (!OlapComTraceUtil.isTrace()) {
            return;
        }
        String key = OlapComTraceUtil.getOpCacheKey(RequestContext.get());
        TraceLogMsg log = new TraceLogMsg();
        if (TraceLogCache.exists(key)) {
            TraceLogMsg info = (TraceLogMsg)TraceLogCache.get(key);
            info.setOpdesc(info.getOpdesc() + ";" + applogInfo.getOpName());
            log = info;
        } else {
            log.setOpname(applogInfo.getOpName());
            log.setOpdesc(applogInfo.getOpDescription());
            log.setOpdate(applogInfo.getOpTime());
        }
        TraceLogCache.put(key, log);
    }

    private static void cacheOlapTraceLog() {
        String key = OlapComTraceUtil.getOlapCacheKey(RequestContext.get());
        if (!TraceLogCache.exists(key)) {
            TraceLogCache.put(key, OlapComTraceUtil.getThreadTrace());
        }
    }

    static String getOlapCacheKey(RequestContext ctx) {
        return TraceOlapCache + ctx.getTraceId();
    }

    static String getOpCacheKey(RequestContext ctx) {
        return TraceOpCache + ctx.getTraceId();
    }

    public static String getThreadTrace() {
        StringBuilder traceInfo = new StringBuilder(500);
        StackTraceElement[] lvStacks = Thread.currentThread().getStackTrace();
        int size = lvStacks.length;
        for (int i = 2; i < size; ++i) {
            String msg = lvStacks[i].toString();
            if (msg.contains("OlapComTraceUtil") || !msg.contains("kd.fi.bcm.")) continue;
            String[] ss = msg.split("\\.");
            msg = ss[ss.length - 2] + "." + ss[ss.length - 1];
            traceInfo.append(i == 0 ? msg : "  " + msg);
            if (i < size - 1) {
                traceInfo.append("\n");
            }
            if (traceInfo.length() > 500) break;
        }
        return traceInfo.toString();
    }

    public static boolean isTrace() {
        return (Boolean)ThreadCache.get((Object)"OlapComTraceUtil.isTrace", () -> false);
    }

    public static String getUniqueid() {
        return (String)TraceLogCache.get(Uniqueid, () -> {
            String uniqueid = String.valueOf(GlobalIdUtil.genGlobalLongId());
            return uniqueid.substring(uniqueid.length() - 10);
        });
    }

    public static long subUniqueidFromOlap(String olaptraceid) {
        return Long.parseLong(olaptraceid.substring(0, olaptraceid.length() - 8));
    }

    public static String subRuleId(String id) {
        return id.substring(0, 2) + id.substring(id.length() - 6);
    }

    public static String subRuleIdFromOlap(String olaptraceid) {
        return olaptraceid.substring(olaptraceid.length() - 8);
    }
}

