/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.rules.webapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.rules.api.DefaultRuleExecutor;
import kd.epm.epbs.business.rules.api.Rules;
import kd.epm.epbs.business.rules.core.RuleSegment;
import kd.epm.epbs.business.rules.support.log.BizRuleDebugLogInfo;
import kd.epm.epbs.business.rules.support.log.BizRuleDebugLogInfoEnum;
import kd.epm.epbs.business.rules.trace.TraceLogCache;
import kd.epm.epbs.common.enums.ExecuteStatusEnum;
import kd.epm.epbs.common.enums.RuleStatusEnum;
import kd.epm.epbs.common.error.CommonErrorCode;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import org.apache.commons.collections4.CollectionUtils;

public class RuleExecuteServiceHelper {
    private static final Log LOG = LogFactory.getLog(RuleExecuteServiceHelper.class);

    public static Map<Long, String> executeBizRules(List<Rules> bizRules) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        ArrayList records = new ArrayList();
        boolean isDebug = false;
        boolean throwException = false;
        for (Rules bizRule : bizRules) {
            Map resultMap;
            if (!isDebug) {
                isDebug = bizRule.isDebug();
            }
            long starttime = System.currentTimeMillis();
            if (!result.containsKey(bizRule.getId()) && !bizRule.isEmpty()) {
                try {
                    TraceLogCache.put("ruleid", bizRule.getId());
                    DefaultRuleExecutor ruleExecutor = new DefaultRuleExecutor();
                    ruleExecutor.execute(bizRule);
                    TraceLogCache.remove("ruleid");
                }
                catch (Exception e) {
                    LOG.error("olap operator: excute script(" + bizRule.getId() + "), result: failure, spendtime ", (Throwable)e);
                    result.put(bizRule.getId(), e.getMessage());
                    throwException = isDebug;
                }
            }
            if ((resultMap = (Map)TraceLogCache.get(bizRule.getId())) != null) {
                resultMap.forEach((k, v) -> {
                    DynamicObject ruleExecRecord = BusinessDataServiceHelper.newDynamicObject((String)EpbsModelCacheHelper.get((long)bizRule.getModelId()).getMetaDataEntity("epbs_rule_executerecord"));
                    ruleExecRecord.set("rule", (Object)bizRule.getId());
                    ruleExecRecord.set("bizmodel", k);
                    ruleExecRecord.set("starttime", (Object)starttime);
                    ruleExecRecord.set("endtime", (Object)System.currentTimeMillis());
                    ruleExecRecord.set("executestatus", (Object)(v.isEmpty() ? ExecuteStatusEnum.SUCCESS.getIndex() : ExecuteStatusEnum.FAILED.getIndex()));
                    ruleExecRecord.set("executor", (Object)RequestContext.get().getCurrUserId());
                    List infos = (List)ThreadCache.get((Object)("" + k));
                    List messages = null;
                    if (infos != null) {
                        messages = infos.stream().filter(bizRuleDebugLogInfo -> {
                            if (!bizRule.isDebug()) {
                                return bizRuleDebugLogInfo.getLevel() == BizRuleDebugLogInfoEnum.LOG;
                            }
                            return true;
                        }).map(BizRuleDebugLogInfo::getInfo).collect(Collectors.toList());
                    }
                    if (CollectionUtils.isNotEmpty(messages)) {
                        ruleExecRecord.set("executelog", (Object)(String.join((CharSequence)System.lineSeparator(), v) + System.lineSeparator() + messages));
                    } else {
                        ruleExecRecord.set("executelog", (Object)String.join((CharSequence)System.lineSeparator(), v));
                    }
                    records.add(ruleExecRecord);
                });
            }
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            if (!throwException) continue;
            throw new KDBizException(CommonErrorCode.create((String)"20006", (Object[])new Object[0]), new Object[0]);
        }
        return result;
    }

    public static Map<Long, String> executeBizRules(Rules bizRule) {
        return RuleExecuteServiceHelper.executeBizRules(Collections.singletonList(bizRule));
    }

    public static Map<Long, String> executeBizRules(long modelId, long templateId) {
        EpbsModelCache epbsModelCache = EpbsModelCacheHelper.get((long)modelId);
        DynamicObjectCollection assignRules = QueryServiceHelper.query((String)epbsModelCache.getMetaDataEntity("epbs_rule_assigntemplate"), (String)"rule", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)});
        List ruleIds = assignRules.stream().map(dy -> dy.getLong("rule")).collect(Collectors.toList());
        DynamicObject[] ruleDys = BusinessDataServiceHelper.load((String)epbsModelCache.getMetaDataEntity("epbs_rule_entity"), (String)("id,model,domain,number,sequence,entryentity,entryentity.seq," + RuleExecuteServiceHelper.getEntryEntityFields("segment_", "name,isenable,commitjsexpr,ownermodel")), (QFilter[])new QFilter[]{new QFilter("id", "in", ruleIds).and("status", "=", (Object)RuleStatusEnum.ENABLE.getStatus())});
        ArrayList<Rules> rulesList = new ArrayList<Rules>(ruleDys.length);
        for (DynamicObject ruleDy : ruleDys) {
            Rules rules = new Rules(ruleDy.getLong("id"), ruleDy.getLong("model_id"), ruleDy.getLong("domain_id"), ruleDy.getString("number"), ruleDy.getInt("sequence"));
            DynamicObjectCollection ruleSegments = ruleDy.getDynamicObjectCollection("entryentity");
            ruleSegments.forEach(ruleSegment -> {
                if (!RuleStatusEnum.RuleLogicStatusEnum.DisEnabled.getValue().equals(ruleSegment.getString("segment_isenable"))) {
                    rules.register(new RuleSegment(ruleSegment.getString("segment_name"), ruleSegment.getString("segment_commitjsexpr"), ruleSegment.getLong("segment_ownermodel_id"), ruleSegment.getInt("seq")));
                }
            });
            rulesList.add(rules);
        }
        return RuleExecuteServiceHelper.executeBizRules(rulesList);
    }

    private static String getEntryEntityFields(String prefix, String fields) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (String field : fields.split(",")) {
            stringJoiner.add("entryentity." + prefix + field);
        }
        return stringJoiner.toString();
    }
}

