/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.spi;

import kd.bos.form.IFormView;
import kd.epm.epbs.common.bean.IContext;
import kd.epm.epbs.common.page.CommandParam;
import kd.epm.epbs.common.page.InteractivePageUtil;
import kd.epm.epbs.common.util.EpbsOperationResult;

public interface IPluginProviderService<T, K> {
    public IFormView getView();

    default public EpbsOperationResult<K> sendMessage(String targetFormId, IContext<T> context) {
        CommandParam commandParam = this.createCommandParam(targetFormId, context);
        InteractivePageUtil.invoke((IFormView)this.getView(), (CommandParam)commandParam);
        if (!commandParam.getResult().isEmpty() && commandParam.getResult().get(0) instanceof EpbsOperationResult) {
            return (EpbsOperationResult)commandParam.getResult().get(0);
        }
        return new EpbsOperationResult(false, "not found method!");
    }

    default public CommandParam createCommandParam(String targetFormId, IContext<T> context) {
        CommandParam commandParam = new CommandParam(this.getView().getEntityId(), targetFormId, "receiveMessage", new Object[]{context});
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getEntityId().equals(targetFormId)) {
            commandParam.setIsInvokeParent();
        }
        return commandParam;
    }

    default public EpbsOperationResult<K> sendMessage(IContext<T> context) {
        return this.sendMessage("", context);
    }
}

