/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.analytics;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.id.ID;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.mservice.EPDMDataRequest;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.business.mservice.EPDMOrder;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.ICache;
import kd.epm.epbs.common.cache.factory.CacheGenFactory;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.util.D;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epdm.business.etl.EtlFieldSelectFormPluginHelper;
import kd.epm.epdm.business.etl.helper.EtlDataViewHelper;
import kd.epm.epdm.business.vo.FilterEntityKey;
import kd.epm.epdm.common.database.ModelUtils;
import kd.epm.epdm.common.enums.DataModelFieldDataTypeEnum;
import kd.epm.epdm.common.enums.EpdmQueryFuncsEnum;
import kd.epm.epdm.common.enums.form.EpdmAnalysisEnum;
import kd.epm.epdm.common.enums.form.EpdmAnalysisFuncEnum;
import kd.epm.epdm.common.enums.form.EpdmAnalysisInfoEnum;
import kd.epm.epdm.common.enums.form.EpdmAnalyticsdesignFullEnum;
import kd.epm.epdm.common.enums.form.EpdmDatamodelEnum;
import kd.epm.epdm.common.util.IDataModelUtils;

public class QueryDesignerControlHelper {
    private static final ICache cache = CacheGenFactory.getCommonCache();
    private static final String CACHE_KEY = "EPDM_Q_DY_";

    public static void putAnalysisCache(DynamicObject dyAnalysis) {
        cache.put(CACHE_KEY + UserUtils.getUserId(), (Object)dyAnalysis);
    }

    public static DynamicObject getAnalysisCache() {
        return (DynamicObject)cache.getIfPresent(CACHE_KEY + UserUtils.getUserId());
    }

    public static void rmAnalysisCache() {
        cache.invalidateByKey(CACHE_KEY + UserUtils.getUserId());
    }

    public static DynamicObject getDefault(IFormView view) {
        DynamicObject dyAnalysis;
        if (null != view.getFormShowParameter()) {
            Object id;
            Object analysis = view.getFormShowParameter().getCustomParam("analysis");
            dyAnalysis = analysis != null ? (null == (id = IDataModelUtils.getObjectValue((Object)analysis, (String)"id")) ? QueryDesignerControlHelper.getFromDraft() : BusinessDataServiceHelper.loadSingle((Object)id, (String)EpdmAnalysisEnum.getFormId())) : QueryDesignerControlHelper.getFromDraft();
            Object oLink = view.getFormShowParameter().getCustomParam(EpdmAnalysisEnum.link.s());
            long link = D.l((Object)IDataModelUtils.getObjectValue((Object)oLink, (String)"id"));
            if (link > 0L) {
                dyAnalysis.set(EpdmAnalysisEnum.link.s(), (Object)link);
            }
        } else {
            dyAnalysis = QueryDesignerControlHelper.getFromDraft();
        }
        if (null != dyAnalysis && UserUtils.getUserId().toString().equals(dyAnalysis.getString(EpdmAnalysisInfoEnum.number.s()))) {
            dyAnalysis.set(EpdmAnalysisInfoEnum.number.s(), (Object)"");
        }
        return dyAnalysis;
    }

    public static List<Map<String, Object>> query(long id, LinkedList<String> headers, String linkNumber, int size, boolean widthDef) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)EpdmAnalysisEnum.getFormId());
        return QueryDesignerControlHelper.query(dy, headers, linkNumber, size, widthDef);
    }

    public static List<Map<String, Object>> query(DynamicObject dy, LinkedList<String> headers, String linkNumber, int size, boolean widthDef) {
        EPDMDataResponse res;
        EPDMDataRequest request = new EPDMDataRequest();
        request.setApp("epdm");
        request.setModel(D.s((Object)IDataModelUtils.getEntityValue((DynamicObject)dy, (String)EpdmAnalysisEnum.model.s(), (String)"id")));
        if (!StringUtils.isEmpty((String)linkNumber)) {
            request.setLink(linkNumber);
        } else {
            request.setLink(D.s((Object)IDataModelUtils.getEntityValue((DynamicObject)dy, (String)EpdmAnalysisEnum.link.s(), (String)"number")));
        }
        if ("UT_0001".equals(EpdmAnalysisEnum.number.getString(dy)) || "UT_0001_copy".equals(EpdmAnalysisEnum.number.getString(dy))) {
            request.setSize(50);
        } else {
            request.setSize(size);
        }
        FilterEntityKey entityKey = new FilterEntityKey("filter_field", "filter_compare", "left_bracket", "filter_value", "filter_datatype", "right_bracket", "union");
        List<Map<String, Object>> mapList = QueryDesignerControlHelper.getEntityFromDraft(dy, EpdmAnalysisEnum.filters.s());
        if (mapList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5168\u8868\u67e5\u8be2\uff0c\u8bf7\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"QueryDesignerControlHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)EpdmAnalyticsdesignFullEnum.getFormId());
        DynamicObjectCollection dynamicObjects = IDataModelUtils.buildEntities((DynamicObjectCollection)object.getDynamicObjectCollection(EpdmAnalysisEnum.filters.s()), mapList);
        request.setCustomWhere(EtlDataViewHelper.getWhereFromFilterEntity(dynamicObjects, entityKey));
        DynamicObjectCollection fields = dy.getDynamicObjectCollection("fields");
        request.setSelectFields(new LinkedList<String>());
        fields.forEach(f -> {
            String label = f.getString("field").toLowerCase(Locale.ROOT);
            if (!StringUtils.isEmpty((String)f.getString("label"))) {
                label = f.getString("label").toLowerCase(Locale.ROOT);
                label = label.replace("-", "_");
                label = label.replace(" ", "_");
                label = label.replaceAll("\\s", "_");
            }
            if (StringUtils.isNumeric((String)label)) {
                label = "f" + label;
            }
            if (D.x((Object)f.get("iscount")) && !StringUtils.isEmpty((String)D.s((Object)f.get("func")))) {
                if (f.getString("func").startsWith(EpdmQueryFuncsEnum.COLASMD + "(")) {
                    int pos = f.getString("func").indexOf("(");
                    label = ModelUtils.validityASLabel((String)label);
                    request.getSelectFields().add(f.getString("func").substring(pos) + " AS " + label);
                } else {
                    label = ModelUtils.validityASLabel((String)label);
                    request.getSelectFields().add(f.getString("func") + " AS " + label);
                }
                headers.add(label);
            } else if (!StringUtils.isEmpty((String)f.getString("label"))) {
                label = ModelUtils.validityASLabel((String)label);
                request.getSelectFields().add(f.getString("field") + " AS " + label);
                headers.add(label);
            } else {
                request.getSelectFields().add(f.getString("field"));
                headers.add(f.getString("field"));
            }
        });
        request.setOrds(new ArrayList<EPDMOrder>());
        mapList = QueryDesignerControlHelper.getEntityFromDraft(dy, EpdmAnalysisEnum.orders.s());
        if (!mapList.isEmpty()) {
            for (Map map : mapList) {
                request.getOrds().add(new EPDMOrder(D.s((Object)IDataModelUtils.getObjectValue((Object)map, (String)"order_field")), D.s((Object)IDataModelUtils.getObjectValue((Object)map, (String)"ordby"))));
            }
        }
        if ((res = (EPDMDataResponse)DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"getQueryId", (Object[])new Object[]{request})).getCode() != 200) {
            throw new KDBizException(res.getMessage());
        }
        EPDMDataResponse ePDMDataResponse = (EPDMDataResponse)DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"queryData", (Object[])new Object[]{((Map)res.getData()).get("qid")});
        if (ePDMDataResponse.getCode() != 200) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u7b26\u5408\u51fd\u6570\u8bf4\u660e\uff0c\u6240\u7528\u7b26\u53f7\u662f\u5426\u51c6\u786e\uff0c\u5982\u662f\u5426\u4f7f\u7528\u82f1\u6587\u683c\u5f0f\u7684\u7b26\u53f7\u7b49\u3002", (String)"DbQueryUtils_6", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (widthDef && (ePDMDataResponse.getData() == null || ((List)ePDMDataResponse.getData()).isEmpty())) {
            return QueryDesignerControlHelper.buildDefRows(request.getSelectFields(), 1, "");
        }
        return (List)ePDMDataResponse.getData();
    }

    public static List<Map<String, Object>> buildDefRows(List<String> fields, int size, String defValue) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(8);
        HashMap<String, String> row = new HashMap<String, String>(fields.size());
        for (int i = 0; i < size; ++i) {
            for (String field : fields) {
                int pos = field.indexOf(" AS ");
                if (pos > 0) {
                    row.put(field.substring(pos + 3), "");
                    continue;
                }
                row.put(field, defValue);
            }
            rows.add(row);
        }
        return rows;
    }

    public static void modelCallBack(IDataModel model, ClosedCallBackEvent event) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
        if (rows != null && !rows.isEmpty()) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue(), (String)EpdmDatamodelEnum.getFormId());
            String json = "{\"id\":" + rows.get(0).getPrimaryKeyValue() + ",\"number\":\"" + rows.get(0).getNumber() + "\",\"" + EpdmDatamodelEnum.table.name() + "\":\"" + EpdmDatamodelEnum.table.getString(dy) + "\"}";
            model.setValue("model_txt_tag", (Object)json);
            model.setValue("model", (Object)rows.get(0).getNumber());
            model.setValue("model_txt", rows.get(0).getPrimaryKeyValue());
        }
    }

    public static void funcFullCallBack(IDataModel model, IFormView view, ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof Map) {
            Map returnMap = (Map)returnData;
            int row = (Integer)returnMap.get("$row");
            String field = D.s(returnMap.get(EpdmAnalysisFuncEnum.field.s()));
            if (!StringUtils.isEmpty((String)field)) {
                field = field.toLowerCase(Locale.ROOT);
            }
            model.setValue(EpdmAnalysisFuncEnum.field.s(), (Object)field, row);
            String script = D.s(returnMap.get(EpdmAnalysisFuncEnum.script.s()));
            if (!StringUtils.isEmpty((String)script)) {
                script = script.replace("\"", "'");
            }
            model.setValue("func", (Object)QueryDesignerControlHelper.replaceCnChar(script), row);
            model.setValue("datatype", returnMap.get(EpdmAnalysisFuncEnum.returntype.s()), row);
        }
    }

    public static String replaceCnChar(String script) {
        if (StringUtils.isEmpty((String)script)) {
            return script;
        }
        script = script.replace("\uff08", "(");
        script = script.replace("\uff09", ")");
        script = script.replace("\uff0c", ",");
        script = script.replace("\u2018", "'");
        script = script.replace("\u201c", "'");
        script = script.replace("\u201c", "'");
        return script;
    }

    public static void fieldsFullCallBack(IDataModel model, IFormView view, ClosedCallBackEvent event, Map<String, String> mapping) {
        Object returnData = event.getReturnData();
        if (returnData instanceof List) {
            List dataList;
            String entryName = event.getActionId();
            DynamicObjectCollection entries = model.getDataEntity(true).getDynamicObjectCollection(entryName);
            String fieldKey = null;
            for (DynamicObject dy : entries) {
                DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
                for (IDataEntityProperty pro : properties) {
                    String col = pro.getName().toLowerCase(Locale.ROOT);
                    if (!col.equals("field") && !col.startsWith("field_") && !col.endsWith("_field")) continue;
                    fieldKey = pro.getName();
                    break;
                }
                if (null == fieldKey) continue;
                break;
            }
            if (!(dataList = (List)returnData).isEmpty()) {
                QueryDesignerControlHelper.updateEntryByDataList(entries, fieldKey, dataList, model, view, mapping);
                int size = entries.size();
                ArrayList<DynamicObject> emptyList = new ArrayList<DynamicObject>(size);
                for (DynamicObject dy : entries) {
                    if (!StringUtils.isEmpty((String)D.s((Object)dy.get(fieldKey)))) continue;
                    emptyList.add(dy);
                }
                for (DynamicObject dy : emptyList) {
                    entries.remove((Object)dy);
                }
            }
        }
    }

    public static void autofill(String entryName, IFormView view, IDataModel model, Map<String, String> mapping) {
        long dataModelId = QueryDesignerControlHelper.getModelId(model);
        if (dataModelId != 0L) {
            List<Map<String, Object>> fields = EtlFieldSelectFormPluginHelper.getFieldsByDataModel(dataModelId, null, null);
            model.setValue(entryName, (Object)QueryDesignerControlHelper.toObjectCollection(fields, entryName, model, mapping));
            view.updateView(entryName);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6a21\u578b\u3002", (String)"QueryDesignerControlHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
    }

    public static DynamicObjectCollection toObjectCollection(List<Map<String, Object>> list, String entryName, IDataModel model, Map<String, String> mapping) {
        DynamicObjectCollection entries = model.getEntryEntity(entryName);
        entries.clear();
        if (!CollectionUtils.isEmpty(list)) {
            for (Map<String, Object> rowMap : list) {
                DynamicObject entry = entries.addNew();
                IDataModelUtils.mapToEntry(rowMap, (DynamicObject)entry, (long)ID.genLongId(), mapping);
            }
        }
        return entries;
    }

    private static void updateEntryByDataList(DynamicObjectCollection entries, String fieldKey, List<Map<String, Object>> dataList, IDataModel model, IFormView view, Map<String, String> mapping) throws KDException {
        String entryName = entries.getDynamicObjectType().getName();
        Map<String, Object> firstRecord = dataList.get(0);
        Object customData = firstRecord.get("customData");
        if (customData instanceof Map) {
            int index = D.i(((Map)customData).get("$row"));
            HashSet<String> fieldSet = "filter_field".equals(fieldKey) ? new HashSet<String>(4) : IDataModelUtils.getExistedFieldSet((DynamicObjectCollection)entries, (String)fieldKey);
            if (dataList.size() == 1) {
                QueryDesignerControlHelper.updateOneRecord(dataList, index, fieldSet, entryName, model, view, mapping);
            } else {
                DynamicObject entry = model.getEntryRowEntity(entryName, index);
                if (null != entry && StringUtils.isEmpty((String)entry.getString(fieldKey))) {
                    entries.remove(index);
                }
                QueryDesignerControlHelper.updateSelectors(entries, index, dataList, fieldSet, mapping);
            }
        }
    }

    private static void updateOneRecord(List<Map<String, Object>> dataList, int index, Set<String> fieldSet, String entryName, IDataModel model, IFormView view, Map<String, String> mapping) {
        Map<String, Object> dataMap = dataList.get(0);
        Object field = dataMap.get("fullnumber");
        if (!fieldSet.contains(field)) {
            DynamicObject entry = model.getEntryRowEntity(entryName, index);
            IDataModelUtils.mapToEntry(dataMap, (DynamicObject)entry, (long)ID.genLongId(), mapping);
        } else {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%s\u3011\u5df2\u5b58\u5728\u3002", (String)"QueryDesignerControlHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), field));
        }
    }

    private static void updateSelectors(DynamicObjectCollection entries, int index, List<Map<String, Object>> dataList, Set<String> fieldSet, Map<String, String> mapping) {
        for (Map<String, Object> dataMap : dataList) {
            Object field = dataMap.get("fullnumber");
            if (fieldSet.contains(field)) continue;
            DynamicObject entry = IDataModelUtils.insertEntries((int)(++index), (DynamicObjectCollection)entries);
            IDataModelUtils.mapToEntry(dataMap, (DynamicObject)entry, (long)ID.genLongId(), mapping);
        }
    }

    public static long getModelId(IDataModel iModel) {
        return IDataModelUtils.getDynamicObjectId((String)"model", (IDataModel)iModel);
    }

    public static void validity(IDataModel iModel) {
        DynamicObjectCollection filters = iModel.getEntryEntity(EpdmAnalyticsdesignFullEnum.filters.s());
        if (!filters.isEmpty()) {
            int size = filters.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject dyFilter = (DynamicObject)filters.get(i);
                if ("IS_NULL".equalsIgnoreCase(dyFilter.getString("filter_compare")) || "IS_NOT_NULL".equalsIgnoreCase(dyFilter.getString("filter_compare"))) continue;
                if ("in".equalsIgnoreCase(dyFilter.getString("filter_compare")) || "not in".equalsIgnoreCase(dyFilter.getString("filter_compare"))) {
                    if (!StringUtils.isEmpty((String)D.s((Object)dyFilter.get("filter_value")))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u7b2c[%1$s]\u884c[%2$s],\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryDesignerControlHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), i + 1, dyFilter.getString("filter_field")));
                }
                String type = dyFilter.getString("filter_datatype");
                String value = dyFilter.getString("filter_value");
                if (null == value || value.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u7b2c[%1$s]\u884c[%2$s],\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryDesignerControlHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), i + 1, dyFilter.getString("filter_field")));
                }
                if (DataModelFieldDataTypeEnum.validity((String)type, (Object)value)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u7b2c[%1$s]\u884c[%2$s],\u6bd4\u8f83\u503c\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u3002", (String)"QueryDesignerControlHelper_5", (String)"epm-epbs-business", (Object[])new Object[0]), i + 1, dyFilter.getString("filter_field")));
            }
        }
    }

    public static List<QFilter> listFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter draftFilter = QueryDesignerControlHelper.getDraftFilter()[0];
        QFilter filter = new QFilter(EpdmAnalysisEnum.status.s(), "=", (Object)"2");
        QFilter seFilter = new QFilter(EpdmAnalysisEnum.security.s(), "=", (Object)"4");
        seFilter.or(new QFilter(EpdmAnalysisEnum.security.s(), "=", (Object)"1").and(new QFilter("creatorid", "=", (Object)UserUtils.getUserId())));
        QFilter uFilter = new QFilter(EpdmAnalysisEnum.users + ".fbasedataid", "=", (Object)UserUtils.getUserId());
        seFilter.or(new QFilter(EpdmAnalysisEnum.security.s(), "=", (Object)"2").and(uFilter));
        filter.and(seFilter);
        filter.or(draftFilter);
        qFilters.add(filter);
        return qFilters;
    }

    private static QFilter[] getDraftFilter() {
        String number = UserUtils.getUserId() + "";
        QFilter filter = new QFilter(EpdmAnalysisEnum.number.s(), "=", (Object)number).and(EpdmAnalysisEnum.status.s(), "=", (Object)"1");
        return new QFilter[]{filter};
    }

    public static DynamicObject saveDraft(IDataModel iModel, long id, boolean save, boolean saveOther) {
        HashMap<String, Object> row;
        ArrayList rows;
        Object value;
        boolean isNew = false;
        DynamicObject updateDy = id > 0L ? BusinessDataServiceHelper.loadSingle((Object)id, (String)EpdmAnalysisEnum.getFormId()) : BusinessDataServiceHelper.loadSingle((String)EpdmAnalysisEnum.getFormId(), (String)EpdmAnalysisEnum.get().selectFields(), (QFilter[])QueryDesignerControlHelper.getDraftFilter());
        if (null == updateDy) {
            id = IDService.get().genLongId();
            updateDy = BusinessDataServiceHelper.newDynamicObject((String)EpdmAnalysisEnum.getFormId());
            updateDy.set(EpdmAnalysisEnum.id.s(), (Object)id);
            updateDy.set(EpdmAnalysisEnum.number.s(), (Object)(UserUtils.getUserId() + ""));
            updateDy.set(EpdmAnalysisEnum.name.s(), (Object)ResManager.loadKDString((String)"\u4e34\u65f6\u67e5\u8be2", (String)"QueryDesignerControlHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
            updateDy.set(EpdmAnalysisEnum.status.s(), (Object)"1");
            updateDy.set(EpdmAnalysisEnum.creatorid.s(), (Object)UserUtils.getUserId());
            isNew = true;
        }
        if (null != (value = iModel.getValue(EpdmAnalyticsdesignFullEnum.model.s()))) {
            updateDy.set(EpdmAnalyticsdesignFullEnum.model.s(), value);
        }
        updateDy.set(EpdmAnalysisEnum.link.s(), iModel.getValue(EpdmAnalysisEnum.link.s()));
        if (saveOther) {
            updateDy.set(EpdmAnalysisEnum.creatorid.s(), (Object)UserUtils.getUserId());
        } else if (!isNew && save) {
            Object userId = IDataModelUtils.getEntityValue((DynamicObject)updateDy, (String)EpdmAnalysisEnum.creatorid.s(), (String)"id");
            if (!D.s((Object)UserUtils.getUserId()).equals(D.s((Object)userId))) {
                String creator = D.s((Object)IDataModelUtils.getObjectValue((Object)updateDy.get(EpdmAnalysisEnum.creatorid.s()), (String)"name"));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u521b\u5efa\u4eba%s\u624d\u6709\u65b9\u6848\u4fee\u6539\u6743\u9650\u3002", (String)"QueryDesignerControlHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]), creator));
            }
            updateDy.set(EpdmAnalysisEnum.creatorid.s(), (Object)UserUtils.getUserId());
        }
        updateDy.set(EpdmAnalysisEnum.modifierid.s(), (Object)UserUtils.getUserId());
        DynamicObjectCollection entries = iModel.getEntryEntity(EpdmAnalyticsdesignFullEnum.fields.s());
        if (null != entries) {
            IDataModelUtils.setEntry((IDataModel)iModel, (String)EpdmAnalyticsdesignFullEnum.fields.s(), (DynamicObject)updateDy);
        }
        if (null != (entries = iModel.getEntryEntity(EpdmAnalyticsdesignFullEnum.filters.s())) && !entries.isEmpty()) {
            rows = new ArrayList(entries.size());
            for (DynamicObject dy : entries) {
                if (StringUtils.isEmpty((String)dy.getString("filter_field"))) continue;
                row = new HashMap<String, Object>(8);
                row.put("left_bracket", dy.getString("left_bracket"));
                row.put("filter_field", dy.getString("filter_field"));
                row.put("filter_compare", dy.getString("filter_compare"));
                row.put("filter_datatype", dy.getString("filter_datatype"));
                row.put("filter_label", dy.getString("filter_label"));
                if (" ".equals(dy.getString("filter_value"))) {
                    row.put("filter_value", "_blank()");
                } else {
                    row.put("filter_value", dy.getString("filter_value"));
                }
                row.put("right_bracket", dy.getString("right_bracket"));
                row.put("union", dy.getString("union"));
                row.put("id", dy.getLong("id"));
                rows.add(row);
            }
            updateDy.set(EpdmAnalysisEnum.filters.s(), (Object)JSON.toJSONString(rows));
        } else {
            updateDy.set(EpdmAnalysisEnum.filters.s(), (Object)JSON.toJSONString(new ArrayList()));
        }
        entries = iModel.getEntryEntity(EpdmAnalyticsdesignFullEnum.orders.s());
        if (null != entries && !entries.isEmpty()) {
            rows = new ArrayList(entries.size());
            for (DynamicObject dy : entries) {
                if (StringUtils.isEmpty((String)dy.getString("order_field"))) continue;
                row = new HashMap(8);
                row.put("order_field", dy.getString("order_field"));
                row.put("order_datatype", dy.getString("order_datatype"));
                row.put("order_label", dy.getString("order_label"));
                row.put("ordby", dy.getString("ordby"));
                row.put("id", dy.getLong("id"));
                rows.add(row);
            }
            updateDy.set(EpdmAnalyticsdesignFullEnum.orders.s(), (Object)JSON.toJSONString(rows));
        } else {
            updateDy.set(EpdmAnalysisEnum.orders.s(), (Object)JSON.toJSONString(new ArrayList()));
        }
        entries = iModel.getEntryEntity(EpdmAnalyticsdesignFullEnum.groups.s());
        if (null != entries && !entries.isEmpty()) {
            rows = new ArrayList(entries.size());
            for (DynamicObject dy : entries) {
                if (StringUtils.isEmpty((String)dy.getString("group_field"))) continue;
                row = new HashMap(8);
                row.put("group_field", dy.getString("group_field"));
                row.put("group_datatype", dy.getString("group_datatype"));
                row.put("group_label", dy.getString("group_label"));
                row.put("id", dy.getLong("id"));
                rows.add(row);
            }
            updateDy.set(EpdmAnalyticsdesignFullEnum.groups.s(), (Object)JSON.toJSONString(rows));
        } else {
            updateDy.set(EpdmAnalysisEnum.groups.s(), (Object)JSON.toJSONString(new ArrayList()));
        }
        if (save) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateDy});
        }
        return updateDy;
    }

    public static DynamicObject getFromDraft() {
        DynamicObject dyAnalysis = QueryDesignerControlHelper.getAnalysisCache();
        if (null != dyAnalysis) {
            return dyAnalysis;
        }
        return BusinessDataServiceHelper.loadSingle((String)EpdmAnalysisEnum.getFormId(), (String)EpdmAnalysisEnum.get().selectFields(), (QFilter[])QueryDesignerControlHelper.getDraftFilter());
    }

    public static List<Map<String, Object>> getEntityFromDraft(DynamicObject dyDraft, String key) {
        String json = dyDraft.getString(key);
        if (StringUtils.isEmpty((String)json) || !json.startsWith("[") || !json.endsWith("]")) {
            return new ArrayList<Map<String, Object>>();
        }
        JSONArray array = JSON.parseArray((String)json);
        if (null == array || array.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(array.size());
        for (Object obj : array) {
            if (!(obj instanceof Map)) continue;
            rows.add((Map)obj);
        }
        return rows;
    }

    public static void writeLog(IFormView view, IDataModel iModel, IOperationTypeInfo opName, MultiLangEnumBridge opDesc) {
        OperationLogUtil.writeLog((String)view.getFormShowParameter().getAppId(), (String)iModel.getDataEntityType().getName(), (IOperationTypeInfo)opName, (MultiLangEnumBridge)opDesc, (Long)QueryDesignerControlHelper.getModelId(iModel));
    }

    public static void setFuncEnable(IFormView view, IDataModel model) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(EpdmAnalyticsdesignFullEnum.fields.s());
        if (null == entryEntity || entryEntity.isEmpty()) {
            return;
        }
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            boolean isCount;
            if (StringUtils.isEmpty((String)D.s((Object)((DynamicObject)entryEntity.get(i)).get("field")))) {
                isCount = false;
            } else if (StringUtils.isEmpty((String)D.s((Object)((DynamicObject)entryEntity.get(i)).get("func")))) {
                isCount = false;
                ((DynamicObject)entryEntity.get(i)).set("iscount", (Object)isCount);
            } else {
                isCount = D.x((Object)((DynamicObject)entryEntity.get(i)).get("iscount"));
            }
            view.setEnable(Boolean.valueOf(isCount), i, new String[]{"func"});
        }
    }
}

