/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.analytics;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.epm.epbs.common.fileImport.FileImportUtils;
import kd.epm.epbs.common.fileImport.entity.Header;
import kd.epm.epbs.common.fileImport.entity.ImportEntity;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.enums.form.EpdmResultViewEnum;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class QueryResultHelper {
    private static final String RESULT = "result";

    public static void showResult(AbstractFormPlugin form, IFormView view, LinkedList<String> headers, List<Map<String, Object>> rows) {
        String pageId;
        if (form.getPageCache().get(RESULT) != null) {
            pageId = form.getPageCache().get(RESULT);
            form.getPageCache().remove(RESULT);
            IFormView childFormView = view.getView(pageId);
            childFormView.close();
            view.sendFormAction(childFormView);
        }
        pageId = QueryResultHelper.showQueryResultView(view, headers, rows);
        form.getPageCache().put(RESULT, pageId);
    }

    public static String showQueryResultView(IFormView view, LinkedList<String> headers, List<Map<String, Object>> rows) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(EpdmResultViewEnum.getFormId());
        showParameter.setCustomParam("rows", rows);
        showParameter.setCustomParam("headers", headers);
        showParameter.setFormId("epdm_query_result");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(RESULT);
        String pageId = "RESULT_" + view.getPageId() + System.currentTimeMillis();
        showParameter.setPageId(pageId);
        StyleCss css = new StyleCss();
        css.setHeight("100%");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        view.showForm((FormShowParameter)showParameter);
        return pageId;
    }

    public static String buildExcelSheet(LinkedList<String> headers, List<Map<String, Object>> rows, String modelNumber) {
        if (null == rows || rows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a\u3002", (String)"QueryResultHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        ImportEntity importEntity = new ImportEntity();
        int idx = 0;
        importEntity.setSheetHeaderMap(new LinkedHashMap(16));
        if (null == headers || headers.isEmpty()) {
            headers = new LinkedList<String>(rows.get(0).keySet());
        }
        for (String key : headers) {
            String rowId = QueryResultHelper.getRowId(idx++);
            importEntity.getSheetHeaderMap().put(rowId, new Header(key, rowId));
        }
        importEntity.setSheetTitle(String.format(ResManager.loadKDString((String)"[%s]\u6570\u636e\u5bfc\u51fa", (String)"QueryResultHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), modelNumber));
        importEntity.setSheetName(modelNumber);
        importEntity.setSheetNotes(ResManager.loadKDString((String)"\u6700\u5927\u652f\u630110\u4e07\u884c\u6570\u636e\u5bfc\u51fa\u3002", (String)"QueryResultHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]));
        FileImportUtils importUtils = new FileImportUtils(importEntity);
        Workbook workbook = importUtils.createImportTemplate();
        Sheet sheet = workbook.getSheet(importEntity.getSheetName());
        idx = 3;
        int size = headers.size();
        for (Map<String, Object> row : rows) {
            Row r = importUtils.getRow(sheet, idx++);
            for (int i = 0; i < size; ++i) {
                String key = headers.get(i);
                importUtils.setCellStringValue(importUtils.getCell(r, i), D.s((Object)row.get(key)));
            }
        }
        return importUtils.saveFileAsUrl(workbook, modelNumber + "_" + System.currentTimeMillis());
    }

    private static String getRowId(int decimal) {
        return String.valueOf(decimal);
    }
}

