/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.balance;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.service.ExportBillListService;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.business.voucher.EPMDVoucherHelper;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class EPMDBalanceServiceHelper {
    private static final String ACCOUNT_FILTER = "accountbasefilter";
    private static final String ENTITY_FILTER = "entitybasefilter";
    private static final String PERIOD_FILTER_START = "periodbasefilterstart";
    private static final String PERIOD_EFILTER_END = "periodbasefilterend";
    private static final String YYYY_MM = "yyyyMM";
    private static final String BASE_FILTER_FLAG = "basefilter";
    private static final DBRoute dbRoute;

    public static void fillCurrencyId() {
        EpbsThreadPools.commonExecute(() -> {
            String querySql = "SELECT fcurrency, fid FROM t_epm_balance WHERE fcurrencyid=?";
            HashSet<String> currencyNumbers = new HashSet<String>(16);
            HashMap<String, Long> currencyNumberIdMap = new HashMap<String, Long>(16);
            LinkedList<Runnable> currencyActions = new LinkedList<Runnable>();
            LinkedList<Object[]> updateParam = new LinkedList<Object[]>();
            Object[] params = new SqlParameter[]{new SqlParameter(":fcurrencyid", -5, (Object)0)};
            DB.query((DBRoute)dbRoute, (String)querySql, (Object[])params, rs -> {
                while (rs.next()) {
                    Object id = rs.getObject("fid");
                    String currency = rs.getString("fcurrency");
                    Object[] param = new Object[2];
                    param[1] = id;
                    updateParam.add(param);
                    Long currencyId = (Long)currencyNumberIdMap.get(currency);
                    if (currencyId == null) {
                        currencyActions.add(() -> {
                            param[0] = currencyNumberIdMap.getOrDefault(currency, -1L);
                        });
                        currencyNumbers.add(currency);
                    } else {
                        param[0] = currencyId;
                    }
                    EPMDBalanceServiceHelper.doUpdate(updateParam.size() > 1000, updateParam, currencyNumbers, currencyNumberIdMap, currencyActions);
                }
                return null;
            });
            EPMDBalanceServiceHelper.doUpdate(!updateParam.isEmpty(), updateParam, currencyNumbers, currencyNumberIdMap, currencyActions);
        });
    }

    private static void doUpdate(boolean isUpdate, List<Object[]> updateParam, Set<String> currencyNumbers, Map<String, Long> currencyNumberIdMap, List<Runnable> currencyActions) {
        if (isUpdate) {
            EPMDVoucherHelper.queryCurrencyAccNumberIdMapThenDoAction(currencyNumberIdMap, currencyNumbers, currencyActions);
            String updateSql = "UPDATE t_epm_balance SET fcurrencyid=? WHERE fid=?";
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, updateParam);
            updateParam.clear();
            currencyNumbers.clear();
            currencyActions.clear();
        }
    }

    public static void addUserPresetToCol(List<IListColumn> listColumns) {
        DataModelPresetHelper.addUserPresetToCol(listColumns, DataModelPresetEnum.T_EPM_BALANCE, 3);
    }

    public static void dealCommonBaseDataFilter(QFilter[] filters) {
        for (QFilter filter : filters) {
            String property = filter.getProperty();
            String filterCP = filter.getCP();
            String entityName = "";
            if (property.startsWith(ACCOUNT_FILTER)) {
                entityName = "bd_accountview";
            } else if (property.startsWith(ENTITY_FILTER)) {
                entityName = "bos_org";
            } else if (property.startsWith(PERIOD_FILTER_START)) {
                filter.__setCP(">=");
                entityName = "bd_period";
            } else {
                if (!property.startsWith(PERIOD_EFILTER_END)) continue;
                filter.__setCP("<=");
                entityName = "bd_period";
            }
            Object value = filter.getValue();
            BillEntityType dataEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityName);
            String billNo = dataEntityType.getBillNo();
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)billNo, (QFilter[])new QFilter[]{new QFilter(dataEntityType.getPrimaryKey().getName(), filterCP, value)});
            if (query.isEmpty()) {
                filter.__setProperty("1");
                filter.__setCP("=");
                filter.__setValue((Object)1);
                continue;
            }
            List list = query.stream().map(dy -> dy.get(billNo)).collect(Collectors.toList());
            int base = property.indexOf(BASE_FILTER_FLAG);
            filter.__setProperty(property.substring(0, base));
            List v = "in".equals(filter.getCP()) ? list : list.get(0);
            filter.__setValue(v);
        }
    }

    public static void addAccountNameToDy(DynamicObjectCollection pageData, String accountName) {
        String accountPN;
        DynamicObjectType dynamicObjectType = pageData.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        if (!properties.containsKey((Object)(accountPN = "account")) || !properties.containsKey((Object)accountName)) {
            return;
        }
        HashMap<String, String> accountNumberNameMap = new HashMap<String, String>(pageData.size());
        LinkedList<String> accList = new LinkedList<String>();
        ArrayList<Runnable> setAccNameFunc = new ArrayList<Runnable>(pageData.size());
        for (DynamicObject pageDatum : pageData) {
            String account = pageDatum.getString(accountPN);
            accList.add(account);
            setAccNameFunc.add(() -> pageDatum.set(accountName, accountNumberNameMap.get(account)));
        }
        DataModelPresetHelper.queryPresetAccNumberNameMapThenDoAction(DataModelPresetEnum.T_EPM_BALANCE, accountNumberNameMap, accList, setAccNameFunc);
    }

    public static void initCommonFilterColumnsDefaultValue(List<FilterColumn> commonFilterColumns) {
        String idCurrencyField = "id";
        String numberCurrencyField = "number";
        String idPeriodField = "id";
        String numberPeriodField = "number";
        DynamicObjectCollection currencyCNY = QueryServiceHelper.query((String)"bd_currency", (String)idCurrencyField, (QFilter[])new QFilter[]{new QFilter(numberCurrencyField, "=", (Object)"CNY")});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY_MM);
        DynamicObjectCollection currentPeriod = QueryServiceHelper.query((String)"bd_period", (String)idPeriodField, (QFilter[])new QFilter[]{new QFilter(numberPeriodField, "=", (Object)simpleDateFormat.format(new Date()))});
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            if (!(commonFilterColumn instanceof CommonBaseDataFilterColumn)) continue;
            CommonBaseDataFilterColumn comm = (CommonBaseDataFilterColumn)commonFilterColumn;
            String refEntityId = comm.getFilterField().getRefEntityId();
            if ("bd_currency".equals(refEntityId) && !currencyCNY.isEmpty()) {
                comm.setDefaultValue(((DynamicObject)currencyCNY.get(0)).getString(idCurrencyField));
                continue;
            }
            if (!"bd_period".equals(refEntityId) || currentPeriod.isEmpty()) continue;
            comm.setDefaultValue(((DynamicObject)currentPeriod.get(0)).getString("id"));
        }
    }

    public static void export(BillList billList, Consumer<QFilter[]> dealQFilter) {
        ExportBillListService service = new ExportBillListService(billList, ResManager.loadKDString((String)"\u4f59\u989d\u8868\u5bfc\u51fa", (String)"EPMDBalanceServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        LinkedList<String> accNumbers = new LinkedList<String>();
        LinkedList<Runnable> setAccName = new LinkedList<Runnable>();
        HashMap<String, String> accNumberNameMap = new HashMap<String, String>(16);
        service.addUserActions("accountname", (row, cell) -> {
            String accNumber = row.getString("account");
            accNumbers.add(accNumber);
            setAccName.add(() -> cell.setCellValue((String)accNumberNameMap.get(accNumber)));
        });
        List filters = service.getFilters();
        dealQFilter.accept(filters.toArray(new QFilter[0]));
        service.queryData();
        DataModelPresetHelper.queryPresetAccNumberNameMapThenDoAction(DataModelPresetEnum.T_EPM_BALANCE, accNumberNameMap, accNumbers, setAccName);
        service.export();
    }

    private EPMDBalanceServiceHelper() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"EPMDBalanceServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }

    static {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epdm_balance");
        dbRoute = new DBRoute(dataEntityType.getDBRouteKey());
    }
}

