/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.cashflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.service.ExportBillListService;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class EPMLCashFlowHelper {
    private static final String BASE_FILTER_FLAG = "basefilter";
    private static final String PERIOD_FILTER = "periodbasefilter";
    private static final String ENTITY_FILTER = "entitybasefilter";
    private static final String CASH_FLOW_FILTER = "cashflowitembasefilter";

    public static void addUserPresetToCol(List<IListColumn> listColumns) {
        DataModelPresetHelper.addUserPresetToCol(listColumns, DataModelPresetEnum.T_EPM_CASHFLOW);
    }

    public static void dealCommonBaseDataFilter(QFilter[] filters) {
        for (QFilter filter : filters) {
            String property = filter.getProperty();
            String filterCP = filter.getCP();
            String entityName = "";
            if (property.startsWith(PERIOD_FILTER)) {
                entityName = "bd_period";
            } else if (property.startsWith("currencybasefilter")) {
                entityName = "bd_currency";
            } else if (property.startsWith(ENTITY_FILTER)) {
                entityName = "bos_org";
            } else {
                if (!property.startsWith(CASH_FLOW_FILTER)) continue;
                entityName = "gl_cashflowitem";
            }
            Object value = filter.getValue();
            BillEntityType dataEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityName);
            String billNo = dataEntityType.getBillNo();
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)billNo, (QFilter[])new QFilter[]{new QFilter(dataEntityType.getPrimaryKey().getName(), filterCP, value)});
            if (query.isEmpty()) {
                filter.__setProperty("1");
                filter.__setCP("=");
                filter.__setValue((Object)1);
                continue;
            }
            List list = query.stream().map(dy -> dy.get(billNo)).collect(Collectors.toList());
            int base = property.indexOf(BASE_FILTER_FLAG);
            filter.__setProperty(property.substring(0, base));
            List v = "in".equals(filter.getCP()) ? list : list.get(0);
            filter.__setValue(v);
        }
    }

    public static void export(BillList billList, Consumer<QFilter[]> dealQFilter) {
        ExportBillListService service = new ExportBillListService(billList, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\u5bfc\u51fa", (String)"EPMLCashFlowHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        LinkedList<String> itemNumbers = new LinkedList<String>();
        LinkedList<Runnable> setItemName = new LinkedList<Runnable>();
        HashMap<String, String> itemNumberNameMap = new HashMap<String, String>(16);
        service.addUserActions("cashflowitemname", (row, cell) -> {
            String accNumber = row.getString("cashflowitem");
            itemNumbers.add(accNumber);
            setItemName.add(() -> cell.setCellValue((String)itemNumberNameMap.get(accNumber)));
        });
        List filters = service.getFilters();
        dealQFilter.accept(filters.toArray(new QFilter[0]));
        service.queryData();
        DataModelPresetHelper.queryPresetFieldNumberNameMapThenDoAction(DataModelPresetEnum.T_EPM_CASHFLOW, itemNumberNameMap, itemNumbers, setItemName, "fcashflowitem");
        service.export();
    }

    public static void queryNoAliasField(DynamicObjectCollection pageData) {
        DynamicObjectType dynamicObjectType = pageData.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        List allQueryField = properties.stream().map(IMetadata::getName).collect(Collectors.toList());
        HashSet<String> itemNumberList = new HashSet<String>(pageData.size());
        HashMap<String, String> itemNumberNameMap = new HashMap<String, String>(pageData.size());
        ArrayList<Runnable> setItemNameFunc = new ArrayList<Runnable>(pageData.size());
        HashSet<String> currencyNumberList = new HashSet<String>(pageData.size());
        HashMap<String, DynamicObject> currencyNumberDynMap = new HashMap<String, DynamicObject>(pageData.size());
        ArrayList<Runnable> setCurrencyDynFunc = new ArrayList<Runnable>(pageData.size());
        boolean hasItem = allQueryField.contains("cashflowitem");
        boolean hasCurrency = allQueryField.contains("currency");
        for (DynamicObject dynamicObject : pageData) {
            if (hasItem) {
                String itemNumber = dynamicObject.getString("cashflowitem");
                itemNumberList.add(itemNumber);
                setItemNameFunc.add(() -> dynamicObject.set("cashflowitemname", itemNumberNameMap.get(itemNumber)));
            }
            if (!hasCurrency) continue;
            String currencyNumber = dynamicObject.getString("currency");
            currencyNumberList.add(currencyNumber);
            setCurrencyDynFunc.add(() -> dynamicObject.set("currencybasefilter", currencyNumberDynMap.get(currencyNumber)));
        }
        if (allQueryField.contains("cashflowitemname")) {
            DataModelPresetHelper.queryPresetFieldNumberNameMapThenDoAction(DataModelPresetEnum.T_EPM_CASHFLOW, itemNumberNameMap, itemNumberList, setItemNameFunc, "fcashflowitem");
        }
        if (allQueryField.contains("currencybasefilter")) {
            DataModelPresetHelper.queryPresetFieldNumberDynThenDoAction(DataModelPresetEnum.T_EPM_CASHFLOW, currencyNumberDynMap, currencyNumberList, setCurrencyDynFunc, "fcurrency");
        }
    }

    private EPMLCashFlowHelper() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"EPMLCashFlowHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }
}

